/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.docker.integration.tests.container;

import org.apache.commons.lang.StringUtils;
import org.eclipse.linuxtools.docker.core.IDockerConnection;
import org.eclipse.linuxtools.docker.integration.tests.image.AbstractImageBotTest;
import org.eclipse.linuxtools.docker.integration.tests.mock.MockDockerConnectionManager;
import org.eclipse.linuxtools.docker.integration.tests.mock.MockUtils;
import org.eclipse.linuxtools.docker.reddeer.condition.ContainerIsDeployedCondition;
import org.eclipse.linuxtools.docker.reddeer.core.ui.wizards.ImageRunSelectionPage;
import org.eclipse.linuxtools.docker.reddeer.ui.DockerExplorerView;
import org.eclipse.linuxtools.docker.reddeer.ui.DockerTerminal;
import org.eclipse.linuxtools.internal.docker.core.DockerConnection;
import org.eclipse.linuxtools.internal.docker.ui.testutils.MockContainerFactory;
import org.eclipse.linuxtools.internal.docker.ui.testutils.MockContainerInfoFactory;
import org.eclipse.linuxtools.internal.docker.ui.testutils.MockDockerClientFactory;
import org.eclipse.linuxtools.internal.docker.ui.testutils.MockDockerConnectionFactory;
import org.eclipse.linuxtools.internal.docker.ui.testutils.MockImageFactory;
import org.eclipse.reddeer.common.condition.WaitCondition;
import org.eclipse.reddeer.common.wait.TimePeriod;
import org.eclipse.reddeer.common.wait.WaitUntil;
import org.eclipse.reddeer.common.wait.WaitWhile;
import org.eclipse.reddeer.core.reference.ReferencedComposite;
import org.eclipse.reddeer.eclipse.ui.console.ConsoleView;
import org.eclipse.reddeer.swt.api.CTabItem;
import org.eclipse.reddeer.swt.impl.menu.ContextMenu;
import org.eclipse.reddeer.workbench.core.condition.JobIsRunning;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mandas.docker.client.DockerClient;
import org.mandas.docker.client.messages.Container;
import org.mandas.docker.client.messages.ContainerInfo;

public class ContainerLogTest
extends AbstractImageBotTest {
    private static final String IMAGE_NAME = "docker.io/hello-world";
    private static final String CONTAINER_NAME = "test_run";
    private static final String CONSOLE_TEXT = "test_run Console output";

    @Before
    public void before() {
        ContainerLogTest.deleteAllConnections();
        this.getConnection();
        this.pullImage(IMAGE_NAME);
        new WaitWhile((WaitCondition)new JobIsRunning());
        DockerExplorerView explorer = new DockerExplorerView();
        explorer.open();
        this.getConnection().refresh();
        this.getConnection().getImage(IMAGE_NAME).run();
        ImageRunSelectionPage firstPage = new ImageRunSelectionPage((ReferencedComposite)explorer);
        firstPage.setContainerName(CONTAINER_NAME);
        firstPage.setAllocatePseudoTTY();
        firstPage.setKeepSTDINOpen();
        firstPage.finish();
        if (this.mockitoIsUsed()) {
            this.runContainer();
            this.getConnection().refresh();
            new WaitUntil((WaitCondition)new ContainerIsDeployedCondition(CONTAINER_NAME, this.getConnection()));
        }
        new WaitWhile((WaitCondition)new JobIsRunning(), TimePeriod.DEFAULT);
    }

    @Test
    public void testDislayLog() {
        this.getConnection().getContainer(CONTAINER_NAME).select();
        String consoleText = this.getContainerLog();
        Assert.assertTrue((String)"Log for container:test_run is empty!", (boolean)StringUtils.isNotEmpty((String)consoleText));
    }

    @Override
    @After
    public void after() {
        this.deleteImageContainerAfter(CONTAINER_NAME);
        this.deleteImageContainerAfter(IMAGE_NAME);
        this.cleanDockerTerminal();
    }

    private void runContainer() {
        DockerClient client = MockDockerClientFactory.container((Container)MockContainerFactory.name((String)CONTAINER_NAME, (String[])new String[0]).status("Stopped").build(), (ContainerInfo)MockContainerInfoFactory.link((String)"docker.io/hello-world:latest").id("TestTestTestTestTest").ipAddress("127.0.0.1").build()).image(MockImageFactory.id((String)"987654321abcde").name("fnichol/uhttpd:latest", new String[0]).build()).build();
        DockerConnection dockerConnection = MockDockerConnectionFactory.from((String)"default", (DockerClient)client).withDefaultTCPConnectionSettings();
        MockDockerConnectionManager.configureConnectionManager(new IDockerConnection[]{dockerConnection});
    }

    private String getContainerLog() {
        String consoleText;
        new ContextMenu().getItem(new String[]{"Display Log"}).select();
        if (this.mockitoIsUsed()) {
            ConsoleView consoleView = new ConsoleView();
            consoleView.open();
            consoleView = MockUtils.getConsoleViewText(CONSOLE_TEXT);
            consoleText = consoleView.getConsoleText();
        } else {
            DockerTerminal dockerTerminal = new DockerTerminal();
            dockerTerminal.activate();
            consoleText = dockerTerminal.getTextFromPage(CONTAINER_NAME);
        }
        return consoleText;
    }

    private void cleanDockerTerminal() {
        if (!this.mockitoIsUsed()) {
            DockerTerminal dockerTerminal = new DockerTerminal();
            dockerTerminal.activate();
            CTabItem tabItem = dockerTerminal.getPage(CONTAINER_NAME);
            tabItem.close();
            dockerTerminal.close();
        }
    }
}

