/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.docker.integration.tests.container;

import java.io.IOException;
import org.eclipse.linuxtools.docker.integration.tests.image.AbstractImageBotTest;
import org.eclipse.linuxtools.docker.integration.tests.mock.MockUtils;
import org.eclipse.linuxtools.docker.reddeer.core.ui.wizards.ImageRunSelectionPage;
import org.eclipse.linuxtools.docker.reddeer.ui.DockerImagesTab;
import org.eclipse.linuxtools.docker.reddeer.utils.BrowserContentsCheck;
import org.eclipse.reddeer.common.condition.WaitCondition;
import org.eclipse.reddeer.common.wait.WaitWhile;
import org.eclipse.reddeer.core.reference.ReferencedComposite;
import org.eclipse.reddeer.eclipse.condition.ConsoleHasNoChange;
import org.eclipse.reddeer.eclipse.ui.browser.WebBrowserView;
import org.eclipse.reddeer.workbench.core.condition.JobIsRunning;
import org.junit.After;
import org.junit.Test;

public class ExposePortTest
extends AbstractImageBotTest {
    private static final String CONTAINER_NAME = "test_run_uhttpd";
    private static final String EXPOSED_PORT = "80";

    @Test
    public void testExposePort() throws IOException {
        this.pullImage("fnichol/uhttpd", "latest");
        DockerImagesTab imagesTab = this.openDockerImagesTab();
        this.runContainer("fnichol/uhttpd", "latest", CONTAINER_NAME, imagesTab);
        if (this.mockitoIsUsed()) {
            MockUtils.runContainer("default", "fnichol/uhttpd", "latest", CONTAINER_NAME);
        }
        this.assertPortIsAccessible(EXPOSED_PORT);
    }

    private void assertPortIsAccessible(String exposedPort) {
        WebBrowserView browserView = new WebBrowserView();
        browserView.open();
        String url = this.createURL(":" + exposedPort);
        if (!this.mockitoIsUsed()) {
            BrowserContentsCheck.checkBrowserForErrorPage((WebBrowserView)browserView, (String)url);
        }
    }

    private void runContainer(String imageName, String imageTag, String containerName, DockerImagesTab imagesTab) {
        imagesTab.runImage(String.valueOf(imageName) + ":" + imageTag);
        ImageRunSelectionPage firstPage = new ImageRunSelectionPage((ReferencedComposite)imagesTab);
        firstPage.setContainerName(containerName);
        firstPage.setPublishAllExposedPorts(false);
        firstPage.finish();
        new WaitWhile((WaitCondition)new JobIsRunning());
        new WaitWhile((WaitCondition)new ConsoleHasNoChange());
    }

    @Override
    @After
    public void after() {
        this.deleteContainerIfExists(CONTAINER_NAME);
    }
}

