/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.docker.integration.tests.container;

import com.google.common.collect.ImmutableMap;
import org.eclipse.linuxtools.docker.core.IDockerConnection;
import org.eclipse.linuxtools.docker.integration.tests.image.AbstractImageBotTest;
import org.eclipse.linuxtools.docker.integration.tests.mock.MockDockerConnectionManager;
import org.eclipse.linuxtools.docker.reddeer.condition.ContainerIsDeployedCondition;
import org.eclipse.linuxtools.docker.reddeer.core.ui.wizards.ImageRunResourceVolumesVariablesPage;
import org.eclipse.linuxtools.docker.reddeer.core.ui.wizards.ImageRunSelectionPage;
import org.eclipse.linuxtools.docker.reddeer.ui.DockerContainersTab;
import org.eclipse.linuxtools.docker.reddeer.ui.DockerImagesTab;
import org.eclipse.linuxtools.internal.docker.core.DockerConnection;
import org.eclipse.linuxtools.internal.docker.ui.testutils.MockContainerFactory;
import org.eclipse.linuxtools.internal.docker.ui.testutils.MockContainerInfoFactory;
import org.eclipse.linuxtools.internal.docker.ui.testutils.MockDockerClientFactory;
import org.eclipse.linuxtools.internal.docker.ui.testutils.MockDockerConnectionFactory;
import org.eclipse.linuxtools.internal.docker.ui.testutils.MockImageFactory;
import org.eclipse.reddeer.common.condition.WaitCondition;
import org.eclipse.reddeer.common.wait.WaitUntil;
import org.eclipse.reddeer.common.wait.WaitWhile;
import org.eclipse.reddeer.core.reference.ReferencedComposite;
import org.eclipse.reddeer.eclipse.ui.views.properties.PropertySheet;
import org.eclipse.reddeer.workbench.core.condition.JobIsRunning;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mandas.docker.client.DockerClient;
import org.mandas.docker.client.exceptions.DockerException;
import org.mandas.docker.client.messages.Container;
import org.mandas.docker.client.messages.ContainerInfo;

public class LabelsTest
extends AbstractImageBotTest {
    private static final String CONTAINER_LABEL_VALUE = "bar";
    private static final String CONTAINER_LABEL_KEY = "foo";
    private static final String IMAGE_NAME = "busybox";
    private static final String IMAGE_TAG = "latest";
    private static final String CONTAINER_NAME = "test_run_busybox_label";

    @Before
    public void before() throws DockerException, InterruptedException {
        LabelsTest.deleteAllConnections();
        this.getConnection();
        this.pullImage(IMAGE_NAME, IMAGE_TAG);
    }

    @Test
    public void testLabels() {
        DockerImagesTab imagesTab = this.openDockerImagesTab();
        imagesTab.runImage("busybox:latest");
        ImageRunSelectionPage firstPage = new ImageRunSelectionPage((ReferencedComposite)imagesTab);
        firstPage.setContainerName(CONTAINER_NAME);
        firstPage.setAllocatePseudoTTY();
        firstPage.setKeepSTDINOpen();
        firstPage.setGiveExtendedPrivileges();
        firstPage.next();
        ImageRunResourceVolumesVariablesPage secondPage = new ImageRunResourceVolumesVariablesPage((ReferencedComposite)firstPage);
        secondPage.addLabel(CONTAINER_LABEL_KEY, CONTAINER_LABEL_VALUE);
        secondPage.finish();
        new WaitWhile((WaitCondition)new JobIsRunning());
        if (this.mockitoIsUsed()) {
            this.runContainer();
            this.getConnection().refresh();
            new WaitUntil((WaitCondition)new ContainerIsDeployedCondition(CONTAINER_NAME, this.getConnection()));
        }
        DockerContainersTab containerTab = new DockerContainersTab();
        containerTab.searchContainer(CONTAINER_NAME);
        containerTab.select(CONTAINER_NAME);
        PropertySheet propertiesView = new PropertySheet();
        propertiesView.open();
        this.getConnection().getContainer(CONTAINER_NAME).select();
        propertiesView.selectTab("Inspect");
        String labelProp = propertiesView.getProperty(new String[]{"Config", "Labels", CONTAINER_LABEL_KEY}).getPropertyValue();
        Assert.assertTrue((String)"Container does not have label foo!", (boolean)labelProp.equals(CONTAINER_LABEL_VALUE));
    }

    @Override
    @After
    public void after() {
        LabelsTest.killRunningImageJobs();
        this.deleteContainerIfExists(CONTAINER_NAME);
    }

    private void runContainer() {
        ImmutableMap labels = ImmutableMap.of((Object)CONTAINER_LABEL_KEY, (Object)CONTAINER_LABEL_VALUE);
        DockerClient client = MockDockerClientFactory.container((Container)MockContainerFactory.id((String)"1MockContainer").name(CONTAINER_NAME, new String[0]).imageName("1a2b3c4d5e6f7g").status("Started 1 second ago").build(), (ContainerInfo)MockContainerInfoFactory.link((String)"busybox:latest").privilegedMode(true).id("TestTestTestTestTest").ipAddress("127.0.0.1").labels(labels).build()).image(MockImageFactory.id((String)"1a2b3c4d5e6f7g").name("busybox:latest", new String[0]).build()).build();
        DockerConnection dockerConnection = MockDockerConnectionFactory.from((String)"default", (DockerClient)client).withDefaultTCPConnectionSettings();
        MockDockerConnectionManager.configureConnectionManager(new IDockerConnection[]{dockerConnection});
    }
}

