/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.docker.integration.tests.image;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.eclipse.linuxtools.docker.integration.tests.AbstractDockerBotTest;
import org.eclipse.linuxtools.docker.integration.tests.mock.MockUtils;
import org.eclipse.linuxtools.docker.reddeer.condition.ContainerIsDeployedCondition;
import org.eclipse.linuxtools.docker.reddeer.preferences.RegistryAccountsPreferencePage;
import org.eclipse.linuxtools.docker.reddeer.ui.DockerImagesTab;
import org.eclipse.linuxtools.docker.reddeer.ui.resources.DockerImage;
import org.eclipse.reddeer.common.condition.WaitCondition;
import org.eclipse.reddeer.common.exception.RedDeerException;
import org.eclipse.reddeer.common.exception.WaitTimeoutExpiredException;
import org.eclipse.reddeer.common.wait.TimePeriod;
import org.eclipse.reddeer.common.wait.WaitWhile;
import org.eclipse.reddeer.core.exception.CoreLayerException;
import org.eclipse.reddeer.core.reference.ReferencedComposite;
import org.eclipse.reddeer.eclipse.condition.ConsoleHasNoChange;
import org.eclipse.reddeer.eclipse.ui.console.ConsoleView;
import org.eclipse.reddeer.eclipse.ui.views.properties.PropertySheet;
import org.eclipse.reddeer.jface.preference.PreferencePage;
import org.eclipse.reddeer.swt.impl.button.PushButton;
import org.eclipse.reddeer.swt.impl.shell.DefaultShell;
import org.eclipse.reddeer.workbench.core.condition.JobIsRunning;
import org.eclipse.reddeer.workbench.ui.dialogs.WorkbenchPreferenceDialog;
import org.junit.After;
import org.junit.Assert;

public class AbstractImageBotTest
extends AbstractDockerBotTest {
    protected static final String NAME_TAG_SEPARATOR = ":";
    protected static final String IMAGE_TAG_LATEST = "latest";
    protected static final String IMAGE_TEST_BUILD = "test_build";
    protected static final String IMAGE_BUSYBOX = "busybox";
    protected static final String IMAGE_BUSYBOX_LATEST = "busybox:latest";
    protected static final String IMAGE_ALPINE = "alpine";
    protected static final String IMAGE_ALPINE_TAG = "3.3";
    protected static final String IMAGE_ALPINE_33 = "alpine:3.3";
    protected static final String IMAGE_CIRROS = "cirros";
    protected static final String IMAGE_CIRROS_TAG = "0.3.4";
    protected static final String IMAGE_UHTTPD = "fnichol/uhttpd";
    protected static final String IMAGE_HELLO_WORLD = "hello-world";
    protected static final String REGISTRY_SERVER_ADDRESS = "registry.access.redhat.com";
    protected static final String IMAGE_RHEL = "rhel7.2";
    protected static final String DOCKERFILE_FOLDER = "resources/test-build";
    protected static final String EDIT_DOCKERFILE_FOLDER = "resources/test-edit-dockerfile";
    protected static final String REGISTRY_URL = "https://index.docker.io";
    private static final String CONSOLE_SUCCESS_MSG = "Successfully built";
    protected static final String MOCKITO = System.getProperty("dockerMockito");

    @After
    public void after() {
        this.cleanUpWorkspace();
    }

    protected DockerImagesTab openDockerImagesTab() {
        DockerImagesTab imageTab = new DockerImagesTab();
        imageTab.activate();
        imageTab.refresh();
        new WaitWhile((WaitCondition)new JobIsRunning(), TimePeriod.DEFAULT);
        return imageTab;
    }

    protected void buildImage(String imageName, String dockerFileFolder, DockerImagesTab imageTab) {
        try {
            String dockerFilePath = new File(dockerFileFolder).getCanonicalPath();
            this.getConnection();
            imageTab.buildImage(imageName, dockerFilePath);
            new WaitWhile((WaitCondition)new JobIsRunning(), TimePeriod.VERY_LONG);
        }
        catch (IOException ex) {
            Assert.fail((String)"Resource file not found!");
        }
    }

    protected void assertConsoleSuccess() {
        this.assertConsoleContains(CONSOLE_SUCCESS_MSG);
    }

    protected void assertConsoleContains(String text) {
        new WaitWhile((WaitCondition)new ConsoleHasNoChange());
        ConsoleView consoleView = new ConsoleView();
        consoleView.open();
        if (this.mockitoIsUsed()) {
            consoleView = MockUtils.getConsoleViewText(text);
        }
        Assert.assertFalse((String)"Console has no output!", (boolean)consoleView.getConsoleText().isEmpty());
        Assert.assertTrue((String)"Build has not been successful", (boolean)consoleView.getConsoleText().contains(text));
    }

    protected void setUpRegister(String serverAddress, String email, String userName, String password) {
        WorkbenchPreferenceDialog dialog = new WorkbenchPreferenceDialog();
        RegistryAccountsPreferencePage page = new RegistryAccountsPreferencePage((ReferencedComposite)dialog);
        dialog.open();
        dialog.select((PreferencePage)page);
        page.removeRegistry(serverAddress);
        page.addRegistry(serverAddress, email, userName, password);
        try {
            new DefaultShell("New Registry Account").setFocus();
        }
        catch (CoreLayerException e) {
            new DefaultShell("Preferences").setFocus();
        }
        new PushButton("Apply and Close").click();
    }

    protected void deleteRegister(String serverAddress) {
        WorkbenchPreferenceDialog dialog = new WorkbenchPreferenceDialog();
        RegistryAccountsPreferencePage page = new RegistryAccountsPreferencePage((ReferencedComposite)dialog);
        dialog.open();
        dialog.select((PreferencePage)page);
        page.removeRegistry(serverAddress);
        new WaitWhile((WaitCondition)new JobIsRunning());
        dialog.ok();
    }

    protected void deleteRegisterIfExists(String serverAddress) {
        try {
            this.deleteRegister(serverAddress);
        }
        catch (RedDeerException redDeerException) {
            // empty catch block
        }
    }

    protected void pullImage(String imageName) {
        this.pullImage(imageName, null, null);
    }

    protected void pullImage(String imageName, String imageTag) {
        this.pullImage(imageName, imageTag, null);
    }

    protected void pullImage(String imageName, String imageTag, String dockerRegister) {
        if (this.mockitoIsUsed()) {
            MockUtils.pullImage("default", imageName, imageTag == null ? IMAGE_TAG_LATEST : imageTag);
        } else {
            try {
                this.getConnection().pullImage(imageName, imageTag, dockerRegister);
            }
            catch (WaitTimeoutExpiredException ex) {
                AbstractImageBotTest.killRunningImageJobs();
                Assert.fail((String)("Timeout expired when pulling image:" + imageName + (imageTag == null ? "" : NAME_TAG_SEPARATOR + imageTag) + "!"));
            }
        }
    }

    protected String getCompleteImageName(String imageName) {
        for (String image : this.getConnection().getImagesNames()) {
            if (!image.contains(imageName)) continue;
            imageName = image.replace(NAME_TAG_SEPARATOR, "");
        }
        return imageName;
    }

    protected void deleteImageIfExists(String imageName) {
        this.deleteImageIfExists(imageName, IMAGE_TAG_LATEST);
    }

    protected void deleteImageIfExists(String imageName, String imageTag) {
        String name = this.getCompleteImageName(imageName);
        if (this.imageIsDeployed(String.valueOf(name) + NAME_TAG_SEPARATOR + imageTag)) {
            if (this.mockitoIsUsed()) {
                MockUtils.removeImage("default", imageName, imageTag);
            } else {
                this.getConnection().getImage(name, imageTag).remove();
            }
        }
    }

    protected void deleteImage(String imageName) {
        this.deleteImage(imageName, IMAGE_TAG_LATEST);
    }

    protected void deleteImage(String imageName, String imageTag) {
        if (this.mockitoIsUsed()) {
            MockUtils.removeImage("default", imageName, imageTag);
            return;
        }
        String completeImageName = this.getCompleteImageName(imageName);
        DockerImage image = this.getConnection().getImage(completeImageName, imageTag);
        if (image == null) {
            Assert.fail((String)("Image " + imageName + NAME_TAG_SEPARATOR + imageTag + "(" + completeImageName + NAME_TAG_SEPARATOR + imageTag + ")" + " does not exists!"));
        }
        image.remove();
    }

    protected void deleteImages(List<String> images) {
        for (String image : images) {
            this.deleteImage(image);
        }
    }

    protected boolean imageIsDeployed(String imageName) {
        return this.getConnection().imageIsDeployed(imageName);
    }

    protected int deployedImagesCount(String imageName) {
        return this.getConnection().deployedImagesCount(imageName);
    }

    protected boolean containerIsDeployed(String containerName) {
        return this.getConnection().containerIsDeployed(containerName);
    }

    protected void deleteContainerIfExists(String containerName) {
        if (this.containerIsDeployed(containerName)) {
            this.getConnection().getContainer(containerName).remove();
            if (!this.mockitoIsUsed()) {
                new WaitWhile((WaitCondition)new ContainerIsDeployedCondition(containerName, this.getConnection()));
            }
        }
    }

    protected void deleteContainer(String containerName) {
        if (!this.containerIsDeployed(containerName)) {
            Assert.fail((String)("Container " + containerName + " does not exists!"));
        }
        this.getConnection().getContainer(containerName).remove();
        if (!this.mockitoIsUsed()) {
            new WaitWhile((WaitCondition)new ContainerIsDeployedCondition(containerName, this.getConnection()));
        }
    }

    protected void deleteImageContainerAfter(String ... imageContainerNames) {
        AbstractImageBotTest.killRunningImageJobs();
        this.deleteImageContainer(imageContainerNames);
    }

    protected void deleteImageContainer(String ... imageContainerNames) {
        String[] stringArray = imageContainerNames;
        int n = imageContainerNames.length;
        int n2 = 0;
        while (n2 < n) {
            String imageContainerName = stringArray[n2];
            String[] nameAndTag = imageContainerName.split(NAME_TAG_SEPARATOR);
            if (this.imageIsDeployed(imageContainerName)) {
                if (nameAndTag.length == 1) {
                    this.deleteImage(imageContainerName);
                } else {
                    this.deleteImage(nameAndTag[0], nameAndTag[1]);
                }
            }
            if (this.containerIsDeployed(imageContainerName)) {
                this.deleteContainer(imageContainerName);
            }
            ++n2;
        }
    }

    protected String getContainerIP(String containerName) {
        PropertySheet propertiesView = this.openPropertiesTabForContainer("Inspect", containerName);
        return propertiesView.getProperty(new String[]{"NetworkSettings", "IPAddress"}).getPropertyValue();
    }

    protected void addTagToImage(String imageName, String imageTag) {
        DockerImagesTab imagesTab = this.openDockerImagesTab();
        imagesTab.activate();
        if (this.mockitoIsUsed()) {
            MockUtils.pullImage("default", imageName, imageTag);
        } else {
            imagesTab.addTagToImage(imageName, imageTag);
        }
    }

    protected void removeTagFromImage(String imageName, String imageTagToRemove) {
        DockerImagesTab imagesTab = this.openDockerImagesTab();
        imagesTab.activate();
        if (this.mockitoIsUsed()) {
            MockUtils.pullImage("default", imageName, IMAGE_TAG_LATEST);
        } else {
            imagesTab.removeTagFromImage(imageName, imageTagToRemove);
        }
    }
}

