/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.docker.integration.tests.image;

import org.eclipse.linuxtools.docker.integration.tests.image.AbstractImageBotTest;
import org.eclipse.linuxtools.docker.reddeer.ui.DockerExplorerView;
import org.eclipse.linuxtools.docker.reddeer.ui.DockerImagesTab;
import org.eclipse.reddeer.common.condition.WaitCondition;
import org.eclipse.reddeer.common.exception.WaitTimeoutExpiredException;
import org.eclipse.reddeer.common.wait.WaitWhile;
import org.eclipse.reddeer.swt.impl.button.CancelButton;
import org.eclipse.reddeer.workbench.core.condition.JobIsRunning;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ImageTagTest
extends AbstractImageBotTest {
    private static final String IMAGE_NAME = "busybox";
    private static final String IMAGE_TAG = "testtag";
    private static final String IMAGE_TAG_UPPERCASE = "UPPERCASETAG";

    @Before
    public void before() {
        ImageTagTest.deleteAllConnections();
        this.getConnection();
        this.pullImage(IMAGE_NAME);
        this.getConnection().refresh();
        new WaitWhile((WaitCondition)new JobIsRunning());
        Assert.assertTrue((String)"Image has not been deployed!", (boolean)this.imageIsDeployed(IMAGE_NAME));
    }

    @Test
    public void testAddRemoveTagToImage() {
        DockerImagesTab imagesTab = this.openDockerImagesTab();
        imagesTab.activate();
        this.addTagToImage(IMAGE_NAME, IMAGE_TAG);
        new WaitWhile((WaitCondition)new JobIsRunning());
        Assert.assertTrue((String)"Image tag has not been added", (boolean)imagesTab.getImageTags(IMAGE_NAME).contains(IMAGE_TAG));
        this.removeTagFromImage(IMAGE_NAME, IMAGE_TAG);
        new WaitWhile((WaitCondition)new JobIsRunning());
        Assert.assertTrue((String)"ImageTaghasNotBeenRemoved", (!imagesTab.getImageTags(IMAGE_NAME).contains(IMAGE_TAG) ? 1 : 0) != 0);
    }

    @Test
    public void testAddUpperCaseTagToImage() {
        DockerExplorerView explorer = new DockerExplorerView();
        explorer.open();
        try {
            this.getConnection().getImage(IMAGE_NAME).addTagToImage(IMAGE_TAG_UPPERCASE);
        }
        catch (WaitTimeoutExpiredException ex) {
            new CancelButton().click();
        }
    }

    @Override
    @After
    public void after() {
        this.deleteImageContainerAfter(IMAGE_NAME);
        this.cleanUpWorkspace();
    }
}

