/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.docker.integration.tests.ui;

import org.eclipse.linuxtools.docker.integration.tests.image.AbstractImageBotTest;
import org.eclipse.linuxtools.docker.integration.tests.mock.MockUtils;
import org.eclipse.linuxtools.docker.reddeer.core.ui.wizards.ImageRunSelectionPage;
import org.eclipse.linuxtools.docker.reddeer.ui.DockerContainersTab;
import org.eclipse.linuxtools.docker.reddeer.ui.DockerImagesTab;
import org.eclipse.reddeer.common.condition.WaitCondition;
import org.eclipse.reddeer.common.wait.TimePeriod;
import org.eclipse.reddeer.common.wait.WaitWhile;
import org.eclipse.reddeer.core.reference.ReferencedComposite;
import org.eclipse.reddeer.eclipse.ui.views.properties.PropertySheet;
import org.eclipse.reddeer.swt.api.TableItem;
import org.eclipse.reddeer.workbench.core.condition.JobIsRunning;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ContainerTabTest
extends AbstractImageBotTest {
    private static final String IMAGE_NAME = "busybox";
    private static final String CONTAINER_NAME = "test_run_busybox";

    @Before
    public void before() {
        ContainerTabTest.deleteAllConnections();
        this.getConnection();
        this.pullImage(IMAGE_NAME);
    }

    @Test
    public void testContainerTab() {
        this.runContainer("default", IMAGE_NAME, "latest", CONTAINER_NAME);
        DockerContainersTab containerTab = new DockerContainersTab();
        containerTab.activate();
        containerTab.refresh();
        new WaitWhile((WaitCondition)new JobIsRunning(), TimePeriod.DEFAULT);
        String nameFromTable = "";
        String imageFromTable = "";
        String createdFromTable = "";
        String commandFromTable = "";
        String portsFromTable = "";
        String statusFromTable = "";
        containerTab.refresh();
        TableItem item = this.getContainerItem(CONTAINER_NAME, containerTab);
        Assert.assertNotNull((String)"Container tab item test_run_busybox was not found.", (Object)item);
        nameFromTable = item.getText();
        imageFromTable = item.getText(1);
        createdFromTable = item.getText(2);
        commandFromTable = item.getText(3);
        portsFromTable = item.getText(4);
        statusFromTable = item.getText(5);
        PropertySheet propertiesView = new PropertySheet();
        propertiesView.open();
        this.getConnection().getContainer(CONTAINER_NAME).select();
        propertiesView.selectTab("Info");
        String nameProp = propertiesView.getProperty(new String[]{"Names"}).getPropertyValue();
        String imageProp = propertiesView.getProperty(new String[]{"Image"}).getPropertyValue();
        String createdProp = propertiesView.getProperty(new String[]{"Created"}).getPropertyValue();
        String commandProp = propertiesView.getProperty(new String[]{"Command"}).getPropertyValue();
        String portsProp = propertiesView.getProperty(new String[]{"Ports"}).getPropertyValue();
        String statusProp = propertiesView.getProperty(new String[]{"Status"}).getPropertyValue();
        Assert.assertTrue((String)("Name in table and in Properties do not match!(" + nameProp + "-" + nameFromTable + ")"), (boolean)nameFromTable.contains(nameProp));
        Assert.assertTrue((String)("Image in table and in Properties do not match!(" + imageProp + "-" + imageFromTable + ")"), (boolean)imageProp.equals(imageFromTable));
        Assert.assertTrue((String)("Created in table and in Properties do not match!(" + createdProp + "-" + createdFromTable + ")"), (boolean)createdProp.equals(createdFromTable));
        Assert.assertTrue((String)("Command in table and in Properties do not match!(" + commandProp + "-" + commandFromTable + ")"), (boolean)commandProp.startsWith(commandFromTable));
        Assert.assertTrue((String)("Ports in table and in Properties do not match!(" + portsProp + "-" + portsFromTable + ")"), (boolean)portsProp.startsWith(portsFromTable));
        Assert.assertTrue((String)("Status in table and in Properties do not match!(" + statusProp + "-" + statusFromTable + ")"), (boolean)statusProp.startsWith(statusFromTable));
    }

    @Test
    public void testContainerTabSearch() {
        this.runContainer("default", IMAGE_NAME, "latest", CONTAINER_NAME);
        DockerContainersTab containerTab = new DockerContainersTab();
        containerTab.activate();
        containerTab.refresh();
        containerTab.searchContainer("aaa");
        Assert.assertTrue((String)"Search result is not 0!", (containerTab.getTableItems().size() == 0 ? 1 : 0) != 0);
        containerTab.searchContainer("");
        Assert.assertTrue((String)"Search result is 0!", (containerTab.getTableItems().size() > 0 ? 1 : 0) != 0);
    }

    private void runContainer(String connectionName, String imageName, String imageTag, String containerName) {
        DockerImagesTab imagesTab = this.openDockerImagesTab();
        imagesTab.runImage(imageName);
        ImageRunSelectionPage firstPage = new ImageRunSelectionPage((ReferencedComposite)imagesTab);
        firstPage.setContainerName(containerName);
        firstPage.finish();
        if (this.mockitoIsUsed()) {
            MockUtils.runContainer(connectionName, imageName, imageTag, containerName);
        }
        this.getConnection().refresh();
        new WaitWhile((WaitCondition)new JobIsRunning());
    }

    private TableItem getContainerItem(String containerName, DockerContainersTab containersTab) {
        for (TableItem item : containersTab.getTableItems()) {
            if (!item.getText(0).contains(containerName)) continue;
            return item;
        }
        return null;
    }

    @Override
    @After
    public void after() {
        this.deleteContainerIfExists(CONTAINER_NAME);
    }
}

