/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.docker.integration.tests.ui;

import org.eclipse.linuxtools.docker.integration.tests.image.AbstractImageBotTest;
import org.eclipse.linuxtools.docker.integration.tests.mock.MockUtils;
import org.eclipse.linuxtools.docker.reddeer.condition.ContainerIsDeployedCondition;
import org.eclipse.linuxtools.docker.reddeer.ui.RunDockerImageLaunchConfiguration;
import org.eclipse.reddeer.common.condition.WaitCondition;
import org.eclipse.reddeer.common.exception.RedDeerException;
import org.eclipse.reddeer.common.wait.TimePeriod;
import org.eclipse.reddeer.common.wait.WaitUntil;
import org.eclipse.reddeer.common.wait.WaitWhile;
import org.eclipse.reddeer.workbench.core.condition.JobIsRunning;
import org.eclipse.reddeer.workbench.handler.WorkbenchShellHandler;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LaunchDockerImageTest
extends AbstractImageBotTest {
    private static final String CONTAINER_NAME = "test_variables";
    private static final String CONFIGURATION_NAME = "test_configuration";

    @Before
    public void before() {
        LaunchDockerImageTest.deleteAllConnections();
        this.getConnection();
        this.pullImage("hello-world");
    }

    @Test
    public void testLaunchConfiguration() {
        String imageName = this.getCompleteImageName("hello-world");
        RunDockerImageLaunchConfiguration runImageConf = new RunDockerImageLaunchConfiguration();
        this.runDockerImageLaunchConfiguration(String.valueOf(imageName) + ":" + "latest", CONTAINER_NAME, CONFIGURATION_NAME, runImageConf);
        if (this.mockitoIsUsed()) {
            MockUtils.runContainer("default", imageName, "latest", CONTAINER_NAME);
            this.getConnection().refresh();
            new WaitUntil((WaitCondition)new ContainerIsDeployedCondition(CONTAINER_NAME, this.getConnection()));
        }
        Assert.assertTrue((String)"Container is not deployed!", (boolean)this.containerIsDeployed(CONTAINER_NAME));
    }

    private void runDockerImageLaunchConfiguration(String imageName, String containerName, String configurationName, RunDockerImageLaunchConfiguration runImageConf) {
        runImageConf.open();
        runImageConf.createNewConfiguration(configurationName);
        runImageConf.setContainerName(containerName);
        runImageConf.selectImage(imageName);
        runImageConf.setPrivilegedMode(true);
        runImageConf.apply();
        runImageConf.runConfiguration(configurationName);
        new WaitWhile((WaitCondition)new JobIsRunning(), TimePeriod.LONG);
    }

    private void deleteIfExists(String configurationName) {
        RunDockerImageLaunchConfiguration runImageConf = new RunDockerImageLaunchConfiguration();
        try {
            runImageConf.open();
            runImageConf.deleteRunConfiguration(configurationName);
            runImageConf.close();
        }
        catch (RedDeerException redDeerException) {
            // empty catch block
        }
    }

    @Override
    @After
    public void after() {
        WorkbenchShellHandler.getInstance().closeAllNonWorbenchShells();
        this.deleteIfExists(CONFIGURATION_NAME);
        this.deleteImageContainerAfter(CONTAINER_NAME);
    }
}

