/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.docker.integration.tests.ui;

import org.eclipse.linuxtools.docker.integration.tests.image.AbstractImageBotTest;
import org.eclipse.linuxtools.docker.integration.tests.mock.MockUtils;
import org.eclipse.linuxtools.docker.reddeer.core.ui.wizards.ImageRunSelectionPage;
import org.eclipse.linuxtools.docker.reddeer.ui.DockerContainersTab;
import org.eclipse.linuxtools.docker.reddeer.ui.DockerImagesTab;
import org.eclipse.reddeer.common.condition.WaitCondition;
import org.eclipse.reddeer.common.wait.WaitWhile;
import org.eclipse.reddeer.core.reference.ReferencedComposite;
import org.eclipse.reddeer.eclipse.ui.views.properties.PropertySheet;
import org.eclipse.reddeer.workbench.core.condition.JobIsRunning;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class PropertiesViewTest
extends AbstractImageBotTest {
    private static final String IMAGE_NAME = "busybox";
    private static final String CONTAINER_NAME = "test_run_docker_busybox";

    @Before
    public void before() {
        PropertiesViewTest.deleteAllConnections();
        this.getConnection();
        this.pullImage(IMAGE_NAME);
    }

    @Test
    public void testContainerPropertiesTab() {
        DockerImagesTab imagesTab = this.openDockerImagesTab();
        imagesTab.runImage(IMAGE_NAME);
        ImageRunSelectionPage firstPage = new ImageRunSelectionPage((ReferencedComposite)imagesTab);
        firstPage.setContainerName(CONTAINER_NAME);
        firstPage.finish();
        DockerContainersTab containerTab = new DockerContainersTab();
        containerTab.activate();
        containerTab.refresh();
        new WaitWhile((WaitCondition)new JobIsRunning());
        if (this.mockitoIsUsed()) {
            MockUtils.runContainer("default", IMAGE_NAME, "latest", CONTAINER_NAME);
        }
        this.getConnection();
        PropertySheet propertiesView = new PropertySheet();
        propertiesView.open();
        containerTab.select(CONTAINER_NAME);
        propertiesView.selectTab("Info");
    }

    @Test
    public void testImagePropertiesTab() {
        DockerImagesTab imagesTab = this.openDockerImagesTab();
        imagesTab.selectImage(IMAGE_NAME);
        PropertySheet propertiesView = new PropertySheet();
        propertiesView.open();
        propertiesView.selectTab("Info");
    }

    @Override
    @After
    public void after() {
        this.deleteContainerIfExists(CONTAINER_NAME);
    }
}

