/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.docker.reddeer.core.ui.wizards;

import java.util.List;
import org.eclipse.reddeer.common.condition.WaitCondition;
import org.eclipse.reddeer.common.wait.TimePeriod;
import org.eclipse.reddeer.common.wait.WaitUntil;
import org.eclipse.reddeer.common.wait.WaitWhile;
import org.eclipse.reddeer.core.reference.ReferencedComposite;
import org.eclipse.reddeer.jface.wizard.WizardPage;
import org.eclipse.reddeer.swt.api.TableItem;
import org.eclipse.reddeer.swt.condition.ShellIsAvailable;
import org.eclipse.reddeer.swt.impl.button.CancelButton;
import org.eclipse.reddeer.swt.impl.button.FinishButton;
import org.eclipse.reddeer.swt.impl.table.DefaultTable;
import org.eclipse.reddeer.workbench.core.condition.JobIsRunning;

public class ImageTagSelectionPage
extends WizardPage {
    public ImageTagSelectionPage(ReferencedComposite referencedComposite) {
        super(referencedComposite);
        new WaitUntil((WaitCondition)new ShellIsAvailable("Search and pull a Docker image"), TimePeriod.DEFAULT);
    }

    public void finish() {
        new FinishButton().click();
        new WaitWhile((WaitCondition)new JobIsRunning(), TimePeriod.VERY_LONG);
    }

    public List<TableItem> getTags() {
        return new DefaultTable().getItems();
    }

    public boolean tagsContains(String tagName) {
        for (TableItem item : this.getTags()) {
            if (!tagName.equals(item.getText())) continue;
            return true;
        }
        return false;
    }

    public void selectTag(String tag) {
        for (TableItem item : this.getTags()) {
            if (!tag.contains(item.getText())) continue;
            item.select();
        }
    }

    public void cancel() {
        new CancelButton().click();
    }
}

