/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.docker.reddeer.core.ui.wizards;

import org.eclipse.linuxtools.docker.reddeer.ui.DockerExplorerView;
import org.eclipse.reddeer.common.condition.WaitCondition;
import org.eclipse.reddeer.common.wait.TimePeriod;
import org.eclipse.reddeer.common.wait.WaitUntil;
import org.eclipse.reddeer.common.wait.WaitWhile;
import org.eclipse.reddeer.core.reference.ReferencedComposite;
import org.eclipse.reddeer.jface.wizard.WizardPage;
import org.eclipse.reddeer.swt.api.Control;
import org.eclipse.reddeer.swt.condition.ControlIsEnabled;
import org.eclipse.reddeer.swt.condition.ShellIsAvailable;
import org.eclipse.reddeer.swt.impl.button.CheckBox;
import org.eclipse.reddeer.swt.impl.button.FinishButton;
import org.eclipse.reddeer.swt.impl.button.OkButton;
import org.eclipse.reddeer.swt.impl.button.PushButton;
import org.eclipse.reddeer.swt.impl.button.RadioButton;
import org.eclipse.reddeer.swt.impl.table.DefaultTable;
import org.eclipse.reddeer.swt.impl.text.LabeledText;
import org.eclipse.reddeer.swt.impl.toolbar.DefaultToolItem;
import org.eclipse.reddeer.workbench.core.condition.JobIsRunning;

public class NewDockerConnectionPage
extends WizardPage {
    private static final String NEW_DOCKER_CONNECTION_SHELL = "New Docker Connection";

    public NewDockerConnectionPage(ReferencedComposite referencedComposite) {
        super(referencedComposite);
    }

    public void open() {
        new DockerExplorerView().open();
        new DefaultToolItem("Add Connection").click();
        new WaitUntil((WaitCondition)new ShellIsAvailable(NEW_DOCKER_CONNECTION_SHELL), TimePeriod.LONG);
    }

    public void finish() {
        new WaitUntil((WaitCondition)new ShellIsAvailable(NEW_DOCKER_CONNECTION_SHELL));
        new WaitUntil((WaitCondition)new ControlIsEnabled((Control)new FinishButton()));
        new FinishButton().click();
        new WaitWhile((WaitCondition)new ShellIsAvailable(NEW_DOCKER_CONNECTION_SHELL), TimePeriod.LONG);
        new WaitWhile((WaitCondition)new JobIsRunning(), TimePeriod.VERY_LONG);
    }

    public void setConnectionName(String name) {
        new LabeledText("Connection name:").setText(name);
    }

    public void setUnixSocket(String unixSocket) {
        new CheckBox("Use custom connection settings:").toggle(true);
        new LabeledText("Location:").setText(unixSocket);
    }

    public void setTcpConnection(String uri) {
        this.setTcpConnection(uri, null, false);
    }

    public void setTcpConnection(String uri, String authentificationCertificatePath, boolean pingConnection) {
        this.setTcpUri(uri);
        if (authentificationCertificatePath != null) {
            new CheckBox("Enable authentication").toggle(true);
            new LabeledText("Path:").setText(authentificationCertificatePath);
        }
        if (pingConnection) {
            this.pingConnection();
        }
    }

    public void setTcpUri(String uri) {
        this.setConnectionName(uri);
        new CheckBox("Use custom connection settings:").toggle(true);
        new LabeledText("Location:").setText("");
        new RadioButton("TCP Connection").toggle(true);
        new LabeledText("URI:").setText(uri);
    }

    public void pingConnection() {
        PushButton testConnectionButton = new PushButton("Test Connection");
        testConnectionButton.click();
        new WaitUntil((WaitCondition)new ShellIsAvailable("Success"));
        new OkButton().click();
    }

    public void search(String connectionName) {
        new PushButton("Search...").click();
        new WaitUntil((WaitCondition)new ShellIsAvailable("Docker Connection Selection"));
        DefaultTable table = new DefaultTable();
        table.getItem(connectionName).select();
        new OkButton().click();
    }
}

