/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.docker.reddeer.requirements;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.linuxtools.docker.reddeer.ui.DockerExplorerView;
import org.eclipse.linuxtools.docker.reddeer.ui.resources.DockerConnection;
import org.eclipse.reddeer.common.logging.Logger;
import org.eclipse.reddeer.core.exception.CoreLayerException;
import org.eclipse.reddeer.junit.requirement.Requirement;
import org.eclipse.reddeer.swt.api.TreeItem;
import org.eclipse.reddeer.swt.impl.tree.DefaultTree;

public class CleanDockerExplorerRequirement
implements Requirement<CleanDockerExplorer> {
    private CleanDockerExplorer cleanDocker;
    private static final Logger log = Logger.getLogger(CleanDockerExplorerRequirement.class);

    public void fulfill() {
        this.removeAllDockerConnections();
    }

    public void setDeclaration(CleanDockerExplorer declaration) {
        this.cleanDocker = declaration;
    }

    public CleanDockerExplorer getDeclaration() {
        return this.cleanDocker;
    }

    public void cleanUp() {
        if (this.cleanDocker.cleanup()) {
            this.removeAllDockerConnections();
        }
    }

    public void initializeExplorer() {
        new DockerExplorerView().open();
    }

    public List<DockerConnection> getDockerConnections() {
        this.initializeExplorer();
        log.info("Getting all available Docker connections...");
        try {
            return new DefaultTree().getItems().stream().map(x -> new DockerConnection((TreeItem)x)).collect(Collectors.toList());
        }
        catch (CoreLayerException coreLayerException) {
            return new ArrayList<DockerConnection>();
        }
    }

    public void removeAllDockerConnections() {
        List<DockerConnection> connections = this.getDockerConnections();
        if (!connections.isEmpty()) {
            connections.stream().forEach(x -> {
                log.info("Removing: " + x.getName());
                x.removeConnection();
            });
        } else {
            log.info("There was no connection...");
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface CleanDockerExplorer {
        public boolean cleanup() default false;
    }
}

