/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.docker.core;

import java.net.URI;
import java.net.URISyntaxException;
import org.assertj.core.api.Assertions;
import org.eclipse.linuxtools.docker.core.DockerException;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mandas.docker.client.exceptions.DockerRequestException;

@RunWith(value=Parameterized.class)
public class DockerExceptionTest {
    @Parameterized.Parameter(value=0)
    public DockerException dockerException;
    @Parameterized.Parameter(value=1)
    public String expectedMessage;

    @Parameterized.Parameters
    public static Object[][] getData() throws URISyntaxException {
        Object[][] data = new Object[][]{{new DockerException("this is an error"), "this is an error"}, {new DockerException("error with message: 232"), "error with message: 232"}, {new DockerException(null, (Throwable)new RuntimeException("This is a test")), "java.lang.RuntimeException: This is a test"}, {new DockerException("First", (Throwable)new RuntimeException("This is a test")), "First"}, {new DockerException("{\"message\":\"invalid reference format: repository name must be lowercase\"}"), "{\"message\":\"invalid reference format: repository name must be lowercase\"}"}, {new DockerException(null, (Throwable)new DockerRequestException("m", new URI("http://none"), 404, "{\"message\":\"invalid reference format: repository name must be lowercase\"}", null)), "invalid reference format: repository name must be lowercase"}, {new DockerException("Additional info", (Throwable)new DockerRequestException("m", new URI("http://none"), 404, "{\"message\":\"invalid reference format: repository name must be lowercase\"}", null)), "Additional info; invalid reference format: repository name must be lowercase"}, {new DockerException((Throwable)new DockerRequestException("Hello", new URI("http://none"), 404, "Response", null)), "org.mandas.docker.client.exceptions.DockerRequestException: Request error: Hello http://none: 404, body: Response"}, {new DockerException("Additional info", (Throwable)new DockerRequestException("Hello", new URI("http://none"), 404, "Response", null)), "Additional info"}, {new DockerException(null, (Throwable)new RuntimeException((Throwable)new DockerRequestException("m", new URI("http://none"), 404, "{\"message\":\"invalid reference format: repository name must be lowercase\"}", null))), "invalid reference format: repository name must be lowercase"}, {new DockerException(null, (Throwable)new RuntimeException("Hello", (Throwable)new DockerRequestException("m", new URI("http://none"), 404, "{\"message\":\"invalid reference format: repository name must be lowercase\"}", null))), "invalid reference format: repository name must be lowercase"}, {new DockerException(null, (Throwable)new RuntimeException(new RuntimeException((Throwable)new DockerRequestException("m", new URI("http://none"), 404, "{\"message\":\"invalid reference format: repository name must be lowercase\"}", null)))), "invalid reference format: repository name must be lowercase"}, {new DockerException(null, (Throwable)new RuntimeException("Hello", (Throwable)new DockerRequestException("m", new URI("http://none"), 404, "Do not show this", null))), "java.lang.RuntimeException: Hello"}};
        return data;
    }

    @Test
    public void shouldGetCorrectExceptionMessage() {
        String message = this.dockerException.getMessage();
        Assertions.assertThat((String)message).isEqualTo(this.expectedMessage);
    }
}

