/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.core;

import java.util.Properties;
import org.assertj.core.api.Assertions;
import org.eclipse.linuxtools.docker.core.IDockerConnectionSettings;
import org.eclipse.linuxtools.internal.docker.core.ShellConnectionSettingsProvider;
import org.eclipse.linuxtools.internal.docker.core.TCPConnectionSettings;
import org.junit.Test;

public class DefaultDockerConnectionSettingsFinderSWTBotTest {
    @Test
    public void shouldCreateSecuredConnectionSettingsFromProperties() {
        Properties properties = new Properties();
        properties.setProperty("DOCKER_HOST", "tcp://foo");
        properties.setProperty("DOCKER_CERT_PATH", "/path/to/certs");
        IDockerConnectionSettings connectionSettings = ShellConnectionSettingsProvider.createDockerConnectionSettings((Properties)properties);
        Assertions.assertThat((boolean)connectionSettings.isSettingsResolved()).isFalse();
        Assertions.assertThat((Comparable)connectionSettings.getType()).isEqualTo((Object)IDockerConnectionSettings.BindingType.TCP_CONNECTION);
        Assertions.assertThat((String)((TCPConnectionSettings)connectionSettings).getHost()).isEqualTo("https://foo");
        Assertions.assertThat((String)((TCPConnectionSettings)connectionSettings).getPathToCertificates()).isEqualTo("/path/to/certs");
        Object[] connectionProperties = ((TCPConnectionSettings)connectionSettings).getProperties();
        Assertions.assertThat((connectionProperties.length == 3 ? 1 : 0) != 0);
        Object[] firstProperty = (Object[])connectionProperties[0];
        Assertions.assertThat((boolean)((String)firstProperty[0]).equals("Type"));
        Assertions.assertThat((boolean)((String)firstProperty[1]).equals("TCP_CONNECTION"));
        Object[] secondProperty = (Object[])connectionProperties[1];
        Assertions.assertThat((boolean)((String)secondProperty[0]).equals("Host"));
        Assertions.assertThat((boolean)((String)secondProperty[1]).equals("https://foo"));
        Object[] thirdProperty = (Object[])connectionProperties[2];
        Assertions.assertThat((boolean)((String)thirdProperty[0]).equals("Certificates"));
        Assertions.assertThat((boolean)((String)thirdProperty[1]).equals("/path/to/certs"));
        Assertions.assertThat((boolean)((TCPConnectionSettings)connectionSettings).isTlsVerify()).isTrue();
    }

    @Test
    public void shouldNotCreateConnectionSettingsWhenMissingHost() {
        Properties properties = new Properties();
        properties.setProperty("DOCKER_CERT_PATH", "/path/to/certs");
        IDockerConnectionSettings connectionSettings = ShellConnectionSettingsProvider.createDockerConnectionSettings((Properties)properties);
        Assertions.assertThat((Object)connectionSettings).isNull();
    }
}

