/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.consoles;

import java.util.ArrayList;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.linuxtools.internal.docker.ui.consoles.StyledTextBuilder;
import org.eclipse.linuxtools.internal.docker.ui.consoles.StylerBuilder;
import org.eclipse.linuxtools.internal.docker.ui.testutils.swt.SWTUtils;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class StyledConsoleLogsTest {
    @Parameterized.Parameter(value=0)
    public String lineText;
    @Parameterized.Parameter(value=1)
    public StyledString expectedStyledString;

    @Parameterized.Parameters
    public static Object[][] getData() {
        ParametersBuilder parametersBuilder = new ParametersBuilder();
        parametersBuilder.add("\u001b[33mcontainerid|\u001b[0mstandard_content", new StyledString().append("containerid|", StylerBuilder.styler((int)33)).append("standard_content", StylerBuilder.defaultStyler()));
        parametersBuilder.add("prefix_content\u001b[33mcontainerid|\u001b[0mstandard_content", new StyledString().append("prefix_content", StylerBuilder.defaultStyler()).append("containerid|", StylerBuilder.styler((int)33)).append("standard_content", StylerBuilder.defaultStyler()));
        parametersBuilder.add("\u001b[33merror_content", new StyledString().append("error_content", StylerBuilder.styler((int)33)));
        parametersBuilder.add("\u001b[33mcontainerid|\u001b[0mstandard_content1\u001b[34mcolorized_content\u001b[0mstandard_content2", new StyledString().append("containerid|", StylerBuilder.styler((int)33)).append("standard_content1", StylerBuilder.defaultStyler()).append("colorized_content", StylerBuilder.styler((int)34)).append("standard_content2", StylerBuilder.defaultStyler()));
        parametersBuilder.add("\u001b[33mcontainerid|\u001b[0mstandard_content1\u001b[34mcolorized_content\u001b[0mstandard_content2\u001b[35mcolorized_content2", new StyledString().append("containerid|", StylerBuilder.styler((int)33)).append("standard_content1", StylerBuilder.defaultStyler()).append("colorized_content", StylerBuilder.styler((int)34)).append("standard_content2", StylerBuilder.defaultStyler()).append("colorized_content2", StylerBuilder.styler((int)35)));
        parametersBuilder.add("\u001b[0m\u001b[33merror_content", new StyledString().append("", StylerBuilder.defaultStyler()).append("error_content", StylerBuilder.styler((int)33)));
        parametersBuilder.add("\u001b[0m", new StyledString().append("", StylerBuilder.defaultStyler()));
        return parametersBuilder.build();
    }

    @Test
    public void shouldGenerateStyledString() {
        StyledString result = StyledTextBuilder.parse((String)this.lineText);
        Assertions.assertThat((Object[])SWTUtils.syncExec(() -> result.getStyleRanges())).isEqualTo((Object)SWTUtils.syncExec(() -> this.expectedStyledString.getStyleRanges()));
        Assertions.assertThat((String)result.getString()).isEqualTo(this.expectedStyledString.getString());
    }

    private static class ParametersBuilder {
        private final List<Object[]> parameters = new ArrayList<Object[]>();

        private ParametersBuilder() {
        }

        ParametersBuilder add(String lineText, StyledString expectation) {
            this.parameters.add(new Object[]{lineText, expectation});
            return this;
        }

        Object[][] build() {
            return (Object[][])this.parameters.toArray((T[])new Object[0][0]);
        }
    }
}

