/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.launch;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.assertj.core.data.MapEntry;
import org.eclipse.linuxtools.docker.core.IDockerPortBinding;
import org.eclipse.linuxtools.internal.docker.core.DockerPortBinding;
import org.eclipse.linuxtools.internal.docker.ui.launch.LaunchConfigurationUtils;
import org.junit.Test;

public class LaunchConfigurationUtilsTest {
    @Test
    public void shouldConvertToUnixPathWhenRunningOnWin32() {
        String path = "C:\\path\\to\\data";
        String convertedToUnix = LaunchConfigurationUtils.convertToUnixPath((String)"win32", (String)"C:\\path\\to\\data");
        Assertions.assertThat((String)convertedToUnix).isEqualTo("/c/path/to/data");
    }

    @Test
    public void shouldNotConvertToUnixPathWhenNotRunningOnWin32() {
        String path = "/foo/bar";
        String convertedToUnix = LaunchConfigurationUtils.convertToUnixPath((String)"macosx", (String)"/foo/bar");
        Assertions.assertThat((String)convertedToUnix).isEqualTo("/foo/bar");
    }

    @Test
    public void shouldConvertToWin32PathWhenRunningOnWin32() {
        String path = "/c/path/to/data";
        String convertedToUnix = LaunchConfigurationUtils.convertToWin32Path((String)"win32", (String)"/c/path/to/data");
        Assertions.assertThat((String)convertedToUnix).isEqualTo("C:\\path\\to\\data");
    }

    @Test
    public void shouldNotConvertToWin32PathWhenNotRunningOnWin32() {
        String path = "/foo/bar";
        String convertedToUnix = LaunchConfigurationUtils.convertToUnixPath((String)"macosx", (String)"/foo/bar");
        Assertions.assertThat((String)convertedToUnix).isEqualTo("/foo/bar");
    }

    @Test
    public void shouldSerializeEmptyPortBindingsFromMap() {
        HashMap bindings = new HashMap();
        List result = LaunchConfigurationUtils.serializePortBindings(bindings);
        Assertions.assertThat((List)result).isEmpty();
    }

    @Test
    public void shouldSerializePortBindingsFromMap() {
        HashMap<String, List<IDockerPortBinding>> bindings = new HashMap<String, List<IDockerPortBinding>>();
        bindings.put("8080/tcp", Arrays.asList(new DockerPortBinding("1.2.3.4", "8080"), new DockerPortBinding(null, "8080")));
        bindings.put("9090/tcp", Arrays.asList(new DockerPortBinding("1.2.3.4", "9090"), new DockerPortBinding(null, "9090")));
        List result = LaunchConfigurationUtils.serializePortBindings(bindings);
        Assertions.assertThat((List)result).containsExactly((Object[])new String[]{"8080/tcp:1.2.3.4:8080", "8080/tcp::8080", "9090/tcp:1.2.3.4:9090", "9090/tcp::9090"});
    }

    @Test
    public void shouldNotSerializeNullPortBindingsFromMap() {
        List result = LaunchConfigurationUtils.serializePortBindings(null);
        Assertions.assertThat((List)result).isEmpty();
    }

    @Test
    public void shouldSerializeEmptyPortBindingsFromSet() {
        HashSet bindings = new HashSet();
        List result = LaunchConfigurationUtils.serializePortBindings(bindings);
        Assertions.assertThat((List)result).isEmpty();
    }

    @Test
    public void shouldSerializePortBindingsFromset() {
        HashSet<String> bindings = new HashSet<String>();
        bindings.add("8080/tcp");
        bindings.add("9090/tcp");
        List result = LaunchConfigurationUtils.serializePortBindings(bindings);
        Assertions.assertThat((List)result).containsExactly((Object[])new String[]{"8080/tcp::8080", "9090/tcp::9090"});
    }

    @Test
    public void shouldNotSerializeNullPortBindingsFromSet() {
        List result = LaunchConfigurationUtils.serializePortBindings(null);
        Assertions.assertThat((List)result).isEmpty();
    }

    @Test
    public void shouldDeserializeBindings() {
        List<String> publishedPorts = Arrays.asList("8080/tcp:1.2.3.4:8080", "8080/tcp::8080", "9090/tcp:1.2.3.4:9090", "9090/tcp::9090");
        Map result = LaunchConfigurationUtils.deserializePortBindings(publishedPorts);
        Assertions.assertThat((Map)result).containsOnly(new Map.Entry[]{MapEntry.entry((Object)"8080/tcp", Arrays.asList(new DockerPortBinding("1.2.3.4", "8080"), new DockerPortBinding(null, "8080"))), MapEntry.entry((Object)"9090/tcp", Arrays.asList(new DockerPortBinding("1.2.3.4", "9090"), new DockerPortBinding(null, "9090")))});
    }
}

