/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.testutils;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Date;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.eclipse.linuxtools.docker.core.Messages;
import org.eclipse.linuxtools.internal.docker.ui.testutils.MockStatusProvider;
import org.mandas.docker.client.messages.Container;
import org.mockito.Mockito;

public class MockContainerFactory {
    public static Builder id(String id) {
        return new Builder().id(id);
    }

    public static Builder name(String repoTag, String ... otherRepoTags) {
        return new Builder().randomId().name(repoTag, otherRepoTags);
    }

    public static class Builder {
        private static char[] hexa = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        private final Container container = (Container)Mockito.mock(Container.class);

        private Builder() {
        }

        private Builder id(String id) {
            Mockito.when((Object)this.container.id()).thenReturn((Object)id);
            return this;
        }

        private Builder randomId() {
            String id = IntStream.range(0, 12).mapToObj(i -> Character.valueOf(hexa[new Random().nextInt(16)]).toString()).collect(Collectors.joining());
            Mockito.when((Object)this.container.id()).thenReturn((Object)id);
            return this;
        }

        public Builder name(String name, String ... otherNames) {
            ArrayList<String> repoTags = new ArrayList<String>();
            repoTags.add(name);
            Stream.of(otherNames).forEach(r -> {
                boolean bl = repoTags.add((String)r);
            });
            Mockito.when((Object)this.container.status()).thenReturn((Object)Messages.Running_specifier);
            Mockito.when((Object)this.container.names()).thenReturn((Object)ImmutableList.copyOf(repoTags));
            Mockito.when((Object)this.container.created()).thenReturn((Object)new Date().getTime());
            return this;
        }

        public Builder imageName(String imageId) {
            Mockito.when((Object)this.container.image()).thenReturn((Object)imageId);
            return this;
        }

        public Builder status(String status) {
            Mockito.when((Object)this.container.status()).thenReturn((Object)status);
            return this;
        }

        public Builder statusProvider(MockStatusProvider statusProvider) {
            Mockito.when((Object)this.container.status()).thenReturn((Object)statusProvider.getStatus());
            return this;
        }

        public Container build() {
            return this.container;
        }
    }
}

