/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.testutils;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mandas.docker.client.messages.ContainerConfig;
import org.mandas.docker.client.messages.ContainerInfo;
import org.mandas.docker.client.messages.HostConfig;
import org.mandas.docker.client.messages.NetworkSettings;
import org.mandas.docker.client.messages.PortBinding;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;

public class MockContainerInfoFactory {
    public static Builder port(String privatePort, String hostIp, String hostPort) {
        return new Builder().port(privatePort, hostIp, hostPort);
    }

    public static Builder link(String link) {
        return new Builder().link(link);
    }

    public static Builder volume(String volume) {
        return new Builder().volume(volume);
    }

    public static Builder networkMode(String networkMode) {
        return new Builder().networkMode(networkMode);
    }

    public static Builder id(String id) {
        return new Builder().id(id);
    }

    public static Builder image(String image) {
        return new Builder().image(image);
    }

    public static Builder ipAddress(String ipAddress) {
        return new Builder().ipAddress(ipAddress);
    }

    public static ContainerInfo build() {
        return new Builder().build();
    }

    public static Builder privilegedMode(boolean mode) {
        return new Builder().privilegedMode(mode);
    }

    public static Builder securityOpt(String profile) {
        return new Builder().securityOpt(profile);
    }

    public static Builder labels(ImmutableMap<String, String> labels) {
        return new Builder().labels(labels);
    }

    public static class Builder {
        private final ContainerInfo containerInfo = (ContainerInfo)Mockito.mock(ContainerInfo.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        private ImmutableMap<String, String> labels;
        private ImmutableMap<String, List<PortBinding>> ports;
        private ImmutableList<String> links;
        private ImmutableList<String> volumes;
        private String networkMode;
        private String ipAddress;
        private Boolean privilegedMode;
        private ImmutableList<String> securityOpt;

        private Builder() {
            Mockito.when((Object)this.containerInfo.created()).thenReturn((Object)new Date());
            Mockito.when((Object)this.containerInfo.path()).thenReturn(null);
            Mockito.when((Object)this.containerInfo.args()).thenReturn(null);
            Mockito.when((Object)this.containerInfo.hostConfig()).thenReturn(null);
            Mockito.when((Object)this.containerInfo.state()).thenReturn(null);
            Mockito.when((Object)this.containerInfo.image()).thenReturn(null);
            Mockito.when((Object)this.containerInfo.networkSettings()).thenReturn(null);
            Mockito.when((Object)this.containerInfo.resolvConfPath()).thenReturn(null);
            Mockito.when((Object)this.containerInfo.hostnamePath()).thenReturn(null);
            Mockito.when((Object)this.containerInfo.hostsPath()).thenReturn(null);
            Mockito.when((Object)this.containerInfo.name()).thenReturn(null);
            Mockito.when((Object)this.containerInfo.driver()).thenReturn(null);
            Mockito.when((Object)this.containerInfo.execDriver()).thenReturn(null);
            Mockito.when((Object)this.containerInfo.processLabel()).thenReturn(null);
            Mockito.when((Object)this.containerInfo.hostsPath()).thenReturn(null);
            Mockito.when((Object)this.containerInfo.mountLabel()).thenReturn(null);
            Mockito.when((Object)this.containerInfo.mounts()).thenReturn(null);
        }

        public Builder labels(ImmutableMap<String, String> labels) {
            this.labels = labels;
            return this;
        }

        public Builder privilegedMode(boolean mode) {
            this.privilegedMode = mode;
            return this;
        }

        public Builder ipAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        public Builder id(String id) {
            Mockito.when((Object)this.containerInfo.id()).thenReturn((Object)id);
            return this;
        }

        public Builder link(String link) {
            if (this.links == null) {
                this.links = ImmutableList.of();
            }
            ArrayList<String> tmp = new ArrayList<String>((Collection<String>)this.links);
            tmp.add(link);
            this.links = ImmutableList.copyOf(tmp);
            return this;
        }

        public Builder securityOpt(String opt) {
            if (this.securityOpt == null) {
                this.securityOpt = ImmutableList.of();
            }
            ArrayList<String> tmp = new ArrayList<String>((Collection<String>)this.securityOpt);
            tmp.add(opt);
            this.securityOpt = ImmutableList.copyOf(tmp);
            return this;
        }

        public Builder volume(String volume) {
            if (this.volumes == null) {
                this.volumes = ImmutableList.of();
            }
            ArrayList<String> tmp = new ArrayList<String>((Collection<String>)this.volumes);
            tmp.add(volume);
            this.volumes = ImmutableList.copyOf(tmp);
            return this;
        }

        public Builder networkMode(String networkMode) {
            this.networkMode = networkMode;
            return this;
        }

        public Builder image(String image) {
            Mockito.when((Object)this.containerInfo.image()).thenReturn((Object)image);
            return this;
        }

        public Builder port(String privatePort, String hostIp, String hostPort) {
            if (this.ports == null) {
                this.ports = ImmutableMap.of();
            }
            PortBinding binding = (PortBinding)Mockito.mock(PortBinding.class);
            Mockito.when((Object)binding.hostIp()).thenReturn((Object)hostIp);
            Mockito.when((Object)binding.hostPort()).thenReturn((Object)hostPort);
            HashMap<String, List<PortBinding>> tmp = new HashMap<String, List<PortBinding>>((Map<String, List<PortBinding>>)this.ports);
            tmp.put(privatePort, new ArrayList());
            this.ports = ImmutableMap.copyOf(tmp);
            ((List)this.ports.get((Object)privatePort)).add(binding);
            return this;
        }

        public ContainerInfo build() {
            NetworkSettings networkSettings = (NetworkSettings)Mockito.mock(NetworkSettings.class);
            Mockito.when((Object)this.containerInfo.networkSettings()).thenReturn((Object)networkSettings);
            Mockito.when((Object)networkSettings.ports()).thenReturn(this.ports);
            Mockito.when((Object)networkSettings.ipAddress()).thenReturn((Object)this.ipAddress);
            HostConfig hostConfig = (HostConfig)Mockito.mock(HostConfig.class);
            Mockito.when((Object)this.containerInfo.hostConfig()).thenReturn((Object)hostConfig);
            Mockito.when((Object)hostConfig.links()).thenReturn(this.links);
            Mockito.when((Object)hostConfig.securityOpt()).thenReturn(this.securityOpt);
            Mockito.when((Object)hostConfig.binds()).thenReturn(this.volumes);
            Mockito.when((Object)hostConfig.networkMode()).thenReturn((Object)this.networkMode);
            Mockito.when((Object)hostConfig.privileged()).thenReturn((Object)this.privilegedMode);
            ContainerConfig containerConfig = (ContainerConfig)Mockito.mock(ContainerConfig.class);
            Mockito.when((Object)this.containerInfo.config()).thenReturn((Object)containerConfig);
            Mockito.when((Object)containerConfig.labels()).thenReturn(this.labels);
            return this.containerInfo;
        }
    }
}

