/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.testutils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.mandas.docker.client.DockerClient;
import org.mandas.docker.client.exceptions.DockerException;
import org.mandas.docker.client.messages.Container;
import org.mandas.docker.client.messages.ContainerInfo;
import org.mandas.docker.client.messages.Image;
import org.mandas.docker.client.messages.ImageInfo;
import org.mandas.docker.client.messages.ImageSearchResult;
import org.mandas.docker.client.messages.Info;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class MockDockerClientFactory {
    public static DockerClient build() {
        return MockDockerClientFactory.image(null).build();
    }

    public static Builder image(Image image) {
        Builder builder = new Builder();
        builder.image(image);
        return builder;
    }

    public static Builder images(Image[] images) {
        Builder builder = new Builder();
        Stream.of(images).forEach(i -> {
            Builder builder2 = builder.image((Image)i);
        });
        return builder;
    }

    public static Builder image(Image image, ImageInfo imageInfo) {
        Builder builder = new Builder();
        builder.image(image, imageInfo);
        return builder;
    }

    public static Builder container(Container container) {
        Builder builder = new Builder();
        builder.container(container);
        return builder;
    }

    public static Builder container(Container container, ContainerInfo containerInfo) {
        Builder builder = new Builder();
        builder.container(container, containerInfo);
        return builder;
    }

    public static Builder onSearch(String term, ImageSearchResult ... results) {
        Builder builder = new Builder();
        builder.onSearch(term, Arrays.asList(results));
        return builder;
    }

    public static void addContainer(DockerClient dockerClient, Container container, ContainerInfo containerInfo) {
        try {
            List containers = dockerClient.listContainers(new DockerClient.ListContainersParam[0]);
            containers.add(container);
            Mockito.when((Object)dockerClient.inspectContainer(container.id())).thenReturn((Object)containerInfo);
            Mockito.when((Object)dockerClient.listContainers((DockerClient.ListContainersParam[])ArgumentMatchers.any())).thenReturn((Object)containers);
        }
        catch (InterruptedException | DockerException throwable) {
            // empty catch block
        }
    }

    public static class Builder {
        private final DockerClient dockerClient;
        private final List<Image> images = new ArrayList<Image>();
        private final List<Container> containers = new ArrayList<Container>();
        private final Map<String, List<ImageSearchResult>> searchResults = new HashMap<String, List<ImageSearchResult>>();

        private Builder() {
            this.dockerClient = (DockerClient)Mockito.mock(DockerClient.class);
            try {
                Info info = (Info)Mockito.mock(Info.class);
                Mockito.when((Object)info.memTotal()).thenReturn((Object)1024L);
                Mockito.when((Object)this.dockerClient.info()).thenReturn((Object)info);
            }
            catch (InterruptedException | DockerException throwable) {
                // empty catch block
            }
        }

        public Builder image(Image image) {
            if (image != null) {
                this.images.add(image);
            }
            return this;
        }

        public Builder image(Image image, ImageInfo imageInfo) {
            if (image != null) {
                this.images.add(image);
            }
            try {
                Mockito.when((Object)this.dockerClient.inspectImage(image.id())).thenReturn((Object)imageInfo);
            }
            catch (InterruptedException | DockerException throwable) {
                // empty catch block
            }
            return this;
        }

        public Builder container(Container container) {
            if (container != null) {
                this.containers.add(container);
            }
            return this;
        }

        public Builder container(Container container, ContainerInfo containerInfo) {
            if (container != null) {
                this.containers.add(container);
            }
            try {
                Mockito.when((Object)this.dockerClient.inspectContainer(container.id())).thenReturn((Object)containerInfo);
            }
            catch (InterruptedException | DockerException throwable) {
                // empty catch block
            }
            return this;
        }

        public Builder onSearch(String term, List<ImageSearchResult> results) {
            this.searchResults.put(term, results);
            return this;
        }

        public DockerClient build() {
            try {
                Mockito.when((Object)this.dockerClient.listImages((DockerClient.ListImagesParam[])ArgumentMatchers.any())).thenReturn(this.images);
                Mockito.when((Object)this.dockerClient.listContainers((DockerClient.ListContainersParam[])ArgumentMatchers.any())).thenAnswer(invocation -> this.containers);
                for (Map.Entry<String, List<ImageSearchResult>> searchResult : this.searchResults.entrySet()) {
                    Mockito.when((Object)this.dockerClient.searchImages(searchResult.getKey())).thenReturn(searchResult.getValue());
                }
            }
            catch (InterruptedException | DockerException throwable) {
                // empty catch block
            }
            return this.dockerClient;
        }
    }
}

