/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.testutils;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import org.eclipse.linuxtools.internal.docker.core.DockerContainerConfig;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;

public class MockDockerContainerConfigFactory {
    public static Builder cmd(String cmd) {
        return new Builder().cmd(cmd);
    }

    public static Builder labels(Map<String, String> labels) {
        return new Builder().labels(labels);
    }

    public static class Builder {
        private final DockerContainerConfig containerConfig = (DockerContainerConfig)Mockito.mock(DockerContainerConfig.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        private final Map<String, String> labels = Collections.emptyMap();

        private Builder() {
        }

        public Builder labels(Map<String, String> labels) {
            Mockito.when((Object)this.containerConfig.labels()).thenReturn(labels);
            return this;
        }

        public Builder cmd(String cmd) {
            Mockito.when((Object)this.containerConfig.cmd()).thenReturn(Arrays.asList(cmd));
            return this;
        }

        public DockerContainerConfig build() {
            Mockito.when((Object)this.containerConfig.exposedPorts()).thenReturn(Collections.emptySet());
            Mockito.when((Object)this.containerConfig.env()).thenReturn(Collections.emptyList());
            Mockito.when((Object)this.containerConfig.labels()).thenReturn(this.labels);
            return this.containerConfig;
        }
    }
}

