/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.testutils;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Date;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.mandas.docker.client.messages.Image;
import org.mockito.Mockito;

public class MockImageFactory {
    public static final char[] HEXA = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static Builder id(String id) {
        return new Builder().id(id);
    }

    public static Builder name(String repoTag, String ... otherRepoTags) {
        return new Builder().randomId().name(repoTag, otherRepoTags);
    }

    public static class Builder {
        private final Image image = (Image)Mockito.mock(Image.class);

        private Builder() {
        }

        private Builder id(String id) {
            Mockito.when((Object)this.image.id()).thenReturn((Object)id);
            return this;
        }

        private Builder randomId() {
            String id = IntStream.range(0, 12).mapToObj(i -> Character.valueOf(HEXA[new Random().nextInt(16)]).toString()).collect(Collectors.joining());
            Mockito.when((Object)this.image.id()).thenReturn((Object)id);
            return this;
        }

        public Builder name(String repoTag, String ... otherRepoTags) {
            ArrayList<String> repoTags = new ArrayList<String>();
            repoTags.add(repoTag);
            Stream.of(otherRepoTags).forEach(r -> {
                boolean bl = repoTags.add((String)r);
            });
            Mockito.when((Object)this.image.repoTags()).thenReturn((Object)ImmutableList.copyOf(repoTags));
            Mockito.when((Object)this.image.created()).thenReturn((Object)Long.toString(new Date().getTime()));
            return this;
        }

        public Builder parentId(String parentId) {
            Mockito.when((Object)this.image.parentId()).thenReturn((Object)parentId);
            return this;
        }

        public Image build() {
            return this.image;
        }
    }
}

