/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.testutils.swt;

import org.eclipse.linuxtools.docker.core.DockerConnectionManager;
import org.eclipse.linuxtools.docker.core.IDockerConnectionSettingsFinder;
import org.eclipse.linuxtools.internal.docker.core.DefaultDockerConnectionSettingsFinder;
import org.eclipse.linuxtools.internal.docker.ui.testutils.swt.SWTUtils;
import org.eclipse.swtbot.eclipse.finder.SWTWorkbenchBot;
import org.eclipse.swtbot.swt.finder.exceptions.WidgetNotFoundException;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotButton;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotShell;
import org.eclipse.ui.PlatformUI;
import org.junit.rules.ExternalResource;

public class CloseShellRule
extends ExternalResource {
    private final String buttonLabel;

    public CloseShellRule(String buttonLabel) {
        this.buttonLabel = buttonLabel;
    }

    protected void after() {
        SWTWorkbenchBot bot = new SWTWorkbenchBot();
        try {
            while (CloseShellRule.isInDialog(bot) && CloseShellRule.getButton(bot, this.buttonLabel) != null) {
                CloseShellRule.getButton(bot, this.buttonLabel).click();
            }
            DockerConnectionManager.getInstance().setConnectionSettingsFinder((IDockerConnectionSettingsFinder)new DefaultDockerConnectionSettingsFinder());
        }
        catch (WidgetNotFoundException widgetNotFoundException) {
            // empty catch block
        }
    }

    private static boolean isInDialog(SWTWorkbenchBot bot) {
        SWTBotShell activeShell = bot.activeShell();
        String text = SWTUtils.syncExec(() -> PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().getText());
        String shellText = activeShell.getText();
        return text != null && !text.equals(shellText);
    }

    private static SWTBotButton getButton(SWTWorkbenchBot bot, String buttonLabel) {
        return bot.button(buttonLabel);
    }
}

