/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.testutils.swt;

import org.eclipse.linuxtools.internal.docker.ui.testutils.swt.SWTUtils;
import org.eclipse.swtbot.eclipse.finder.SWTWorkbenchBot;
import org.eclipse.swtbot.eclipse.finder.widgets.SWTBotView;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PlatformUI;
import org.junit.Assert;
import org.junit.rules.ExternalResource;

public class SWTBotViewRule
extends ExternalResource {
    private final SWTWorkbenchBot bot = new SWTWorkbenchBot();
    private final String viewId;
    private SWTBotView botView = null;
    private IViewPart view = null;

    public SWTBotViewRule(String viewId) {
        this.viewId = viewId;
    }

    protected void before() {
        SWTUtils.asyncExec(() -> {
            try {
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView(this.viewId);
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.fail((String)("Failed to open view with id '" + this.viewId + "': " + e.getMessage()));
            }
        });
        this.botView = this.bot.viewById(this.viewId);
        this.botView.show();
        this.view = this.botView.getViewReference().getView(true);
    }

    public SWTBotView bot() {
        return this.botView;
    }

    public <T> T view() {
        return (T)this.view;
    }

    public void close() {
        this.botView.close();
    }
}

