/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.testutils.swt;

import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.linuxtools.internal.docker.ui.views.DockerExplorerView;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swtbot.eclipse.finder.SWTWorkbenchBot;
import org.eclipse.swtbot.eclipse.finder.waits.Conditions;
import org.eclipse.swtbot.eclipse.finder.widgets.SWTBotView;
import org.eclipse.swtbot.swt.finder.exceptions.WidgetNotFoundException;
import org.eclipse.swtbot.swt.finder.finders.ContextMenuHelper;
import org.eclipse.swtbot.swt.finder.finders.UIThreadRunnable;
import org.eclipse.swtbot.swt.finder.results.VoidResult;
import org.eclipse.swtbot.swt.finder.widgets.AbstractSWTBot;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotMenu;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTable;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTableItem;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotToolbarButton;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTree;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTreeItem;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.progress.UIJob;
import org.junit.Assert;
import org.junit.ComparisonFailure;

public class SWTUtils {
    public static <V> V syncExec(Supplier<V> supplier) {
        ArrayBlockingQueue result = new ArrayBlockingQueue(1);
        Display.getDefault().syncExec(() -> {
            boolean bl = result.add(supplier.get());
        });
        return (V)result.poll();
    }

    public static void syncExec(Runnable runnable) {
        Display.getDefault().syncExec(runnable);
    }

    public static void syncAssert(Runnable runnable) throws SWTException, ComparisonFailure {
        ArrayBlockingQueue failure = new ArrayBlockingQueue(1);
        ArrayBlockingQueue swtException = new ArrayBlockingQueue(1);
        Display.getDefault().syncExec(() -> {
            try {
                runnable.run();
            }
            catch (ComparisonFailure e1) {
                failure.add(e1);
            }
            catch (SWTException e2) {
                swtException.add(e2);
            }
        });
        if (!failure.isEmpty()) {
            throw (ComparisonFailure)((Object)failure.poll());
        }
        if (!swtException.isEmpty()) {
            throw (SWTException)((Object)swtException.poll());
        }
    }

    public static void asyncExec(Runnable runnable) {
        SWTUtils.asyncExec(runnable, true);
    }

    public static void asyncExec(Runnable runnable, boolean waitForJobsToComplete) {
        ArrayBlockingQueue failure = new ArrayBlockingQueue(1);
        ArrayBlockingQueue swtException = new ArrayBlockingQueue(1);
        Display.getDefault().asyncExec(() -> {
            try {
                runnable.run();
            }
            catch (ComparisonFailure e1) {
                failure.add(e1);
            }
            catch (SWTException e2) {
                swtException.add(e2);
            }
        });
        if (waitForJobsToComplete) {
            SWTUtils.waitForJobsToComplete();
        }
        if (!failure.isEmpty()) {
            throw (ComparisonFailure)((Object)failure.poll());
        }
        if (!swtException.isEmpty()) {
            throw (SWTException)((Object)swtException.poll());
        }
    }

    public static void waitForJobsToComplete() {
        SWTUtils.wait(1, TimeUnit.SECONDS);
        while (!Job.getJobManager().isIdle()) {
            SWTUtils.wait(1, TimeUnit.SECONDS);
        }
    }

    public static void waitForJobsToComplete(Object familly) {
        Conditions.waitForJobs(DockerExplorerView.class, (String)"Docker Explorer View jobs");
    }

    public static SWTBotTreeItem getTreeItem(SWTBotView viewBot, String ... paths) {
        SWTBotTree tree = viewBot.bot().tree();
        return SWTUtils.getTreeItem(tree.getAllItems(), paths);
    }

    public static SWTBotTreeItem getTreeItem(SWTBotTreeItem parentTreeItem, String ... paths) {
        if (paths.length == 1) {
            return SWTUtils.getTreeItem(parentTreeItem, paths[0]);
        }
        String[] remainingPaths = new String[paths.length - 1];
        System.arraycopy(paths, 1, remainingPaths, 0, paths.length - 1);
        return SWTUtils.getTreeItem(SWTUtils.getTreeItem(parentTreeItem, paths[0]), remainingPaths);
    }

    public static SWTBotTreeItem getTreeItem(SWTBotTree parentTree, String path) {
        SWTBotTreeItem[] sWTBotTreeItemArray = parentTree.getAllItems();
        int n = sWTBotTreeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            SWTBotTreeItem child = sWTBotTreeItemArray[n2];
            if (child.getText().startsWith(path)) {
                return child;
            }
            ++n2;
        }
        return null;
    }

    public static SWTBotTreeItem getTreeItem(SWTBotTreeItem parentTreeItem, String path) {
        SWTBotTreeItem[] sWTBotTreeItemArray = parentTreeItem.getItems();
        int n = sWTBotTreeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            SWTBotTreeItem child = sWTBotTreeItemArray[n2];
            if (child.getText().startsWith(path)) {
                return child;
            }
            ++n2;
        }
        return null;
    }

    private static SWTBotTreeItem getTreeItem(SWTBotTreeItem[] treeItems, String[] paths) {
        SWTBotTreeItem swtBotTreeItem = Stream.of(treeItems).filter(item -> item.getText().startsWith(paths[0])).findFirst().orElseThrow(() -> new RuntimeException("Only available items: " + Stream.of(treeItems).map(item -> item.getText()).collect(Collectors.joining(", "))));
        if (paths.length > 1) {
            SWTUtils.syncExec(() -> swtBotTreeItem.expand());
            String[] remainingPath = new String[paths.length - 1];
            System.arraycopy(paths, 1, remainingPath, 0, remainingPath.length);
            return SWTUtils.getTreeItem(swtBotTreeItem.getItems(), remainingPath);
        }
        return swtBotTreeItem;
    }

    public static SWTBotTableItem getListItem(SWTBotTable table, String name) {
        return Stream.iterate(0, i -> i + 1).limit(table.rowCount()).map(rowNumber -> table.getTableItem(rowNumber.intValue())).filter(rowItem -> Stream.iterate(0, j -> j + 1).limit(table.columnCount()).map(colNum -> rowItem.getText(colNum.intValue())).anyMatch(colValue -> colValue.contains(name))).findFirst().orElse(null);
    }

    public static void wait(int duration, TimeUnit unit) {
        try {
            Thread.sleep(unit.toMillis(duration));
        }
        catch (InterruptedException e) {
            Assertions.fail((String)("Failed to wait for a " + unit.toMillis(duration) + "ms"), (Throwable)e);
        }
    }

    public static SWTBotTreeItem select(SWTBotTreeItem parentTreeItem, String ... matchItems) {
        List<String> fullyQualifiedItems = Stream.of(parentTreeItem.getItems()).filter(treeItem -> Stream.of(matchItems).anyMatch(matchItem -> treeItem.getText().startsWith((String)matchItem))).map(item -> item.getText()).collect(Collectors.toList());
        return parentTreeItem.select(fullyQualifiedItems.toArray(new String[0]));
    }

    public static SWTBotTree select(SWTBotTree parentTree, String ... matchItems) {
        List<String> fullyQualifiedItems = Stream.of(parentTree.getAllItems()).filter(treeItem -> Stream.of(matchItems).anyMatch(matchItem -> treeItem.getText().startsWith((String)matchItem))).map(item -> item.getText()).collect(Collectors.toList());
        return parentTree.select(fullyQualifiedItems.toArray(new String[0]));
    }

    public static void select(SWTBotTreeItem treeItem) {
        treeItem.select();
    }

    public static SWTBotMenu getContextMenu(SWTBotTree tree, String ... path) {
        SWTBotMenu contextMenu = tree.contextMenu(path[0]);
        if (contextMenu == null) {
            Assert.fail((String)("Failed to find context menu '" + path[0] + "'."));
        }
        if (path.length == 1) {
            return contextMenu;
        }
        String[] remainingPath = new String[path.length - 1];
        System.arraycopy(path, 1, remainingPath, 0, remainingPath.length);
        return SWTUtils.getSubMenu(contextMenu, remainingPath);
    }

    public static void hideMenu(SWTBotTree tree) {
        try {
            final Menu menu = (Menu)UIThreadRunnable.syncExec(() -> ((Tree)sWTBotTree.widget).getMenu());
            UIThreadRunnable.syncExec((VoidResult)new VoidResult(){

                public void run() {
                    this.hide(menu);
                }

                private void hide(Menu menu2) {
                    menu2.notifyListeners(23, new Event());
                    if (menu2.getParentMenu() != null) {
                        this.hide(menu2.getParentMenu());
                    }
                }
            });
        }
        catch (WidgetNotFoundException widgetNotFoundException) {
            // empty catch block
        }
    }

    public static SWTBotMenu getSubMenu(SWTBotMenu menu, String ... path) {
        SWTBotMenu subMenu = menu.menu(path[0]);
        if (subMenu == null) {
            Assert.fail((String)("Failed to find submenu '" + path[0] + "'."));
        }
        if (path.length == 1) {
            return subMenu;
        }
        String[] remainingPath = new String[path.length - 1];
        System.arraycopy(path, 1, remainingPath, 0, remainingPath.length);
        return SWTUtils.getSubMenu(subMenu, remainingPath);
    }

    public static SWTBotTreeItem expand(SWTBotTree tree, String ... paths) {
        SWTBotTreeItem rootItem = SWTUtils.getTreeItem(tree, paths[0]);
        SWTUtils.expandTreeItem(rootItem);
        if (paths.length > 1) {
            String[] remainingPath = new String[paths.length - 1];
            System.arraycopy(paths, 1, remainingPath, 0, remainingPath.length);
            return SWTUtils.expand(rootItem, remainingPath);
        }
        return rootItem;
    }

    public static SWTBotTreeItem expand(SWTBotTreeItem treeItem, String ... paths) {
        SWTBotTreeItem childItem = SWTUtils.getTreeItem(treeItem, paths[0]);
        SWTUtils.expandTreeItem(childItem);
        if (paths.length > 1) {
            String[] remainingPath = new String[paths.length - 1];
            System.arraycopy(paths, 1, remainingPath, 0, remainingPath.length);
            return SWTUtils.expand(childItem, remainingPath);
        }
        return SWTUtils.getTreeItem(treeItem, paths[0]);
    }

    private static SWTBotTreeItem expandTreeItem(final SWTBotTreeItem treeItem) {
        UIJob expandJob = new UIJob("expanding tree"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                treeItem.expand();
                return Status.OK_STATUS;
            }
        };
        expandJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                int maxAttempts = 30;
                int currentAttempt = 0;
                while (currentAttempt < 30 && treeItem.getItems().length == 1 && treeItem.getItems()[0].getText().isEmpty()) {
                    SWTUtils.wait(1, TimeUnit.SECONDS);
                    ++currentAttempt;
                }
            }
        });
        expandJob.schedule();
        SWTUtils.wait(1, TimeUnit.SECONDS);
        return treeItem;
    }

    public static SWTBotView getSWTBotView(SWTWorkbenchBot bot, String viewId) {
        return bot.views().stream().filter(v -> v.getViewReference().getId().equals(viewId)).findFirst().orElse(null);
    }

    public static <T> T getView(SWTWorkbenchBot bot, String viewId) {
        return SWTUtils.getView(bot, viewId, false);
    }

    public static <T> T getView(SWTWorkbenchBot bot, String viewId, boolean restore) {
        SWTBotView viewBot = bot.viewById(viewId);
        viewBot.setFocus();
        return (T)((IViewReference)viewBot.getReference()).getView(restore);
    }

    public static boolean isConsoleViewVisible(SWTWorkbenchBot bot) {
        return bot.views().stream().anyMatch(v -> v.getViewReference().getId().equals("org.eclipse.ui.console.ConsoleView"));
    }

    public static SWTBotToolbarButton getConsoleToolbarButtonWithTooltipText(SWTWorkbenchBot bot, String tooltipText) {
        return bot.viewById("org.eclipse.ui.console.ConsoleView").getToolbarButtons().stream().filter(button -> button.getToolTipText().equals(tooltipText)).findFirst().get();
    }

    public static void closeView(SWTWorkbenchBot bot, String viewId) {
        bot.views().stream().filter(v -> ((IViewReference)v.getReference()).getId().equals(viewId)).forEach(v -> v.close());
    }

    public static SWTBotMenu getContextMenu(AbstractSWTBot<? extends Control> bot, String menuName) {
        return new SWTBotMenu(ContextMenuHelper.contextMenu(bot, (String[])new String[]{menuName}));
    }
}

