/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.wizards;

import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.linuxtools.docker.core.EnumDockerConnectionState;
import org.eclipse.linuxtools.docker.core.IDockerConnection;
import org.eclipse.linuxtools.docker.core.IRegistryAccount;
import org.eclipse.linuxtools.internal.docker.core.DockerConnection;
import org.eclipse.linuxtools.internal.docker.core.DockerProgressHandler;
import org.eclipse.linuxtools.internal.docker.core.RegistryAccountInfo;
import org.eclipse.linuxtools.internal.docker.core.RegistryAccountManager;
import org.eclipse.linuxtools.internal.docker.core.RegistryAccountStorageManager;
import org.eclipse.linuxtools.internal.docker.ui.testutils.MockDockerClientFactory;
import org.eclipse.linuxtools.internal.docker.ui.testutils.MockDockerConnectionFactory;
import org.eclipse.linuxtools.internal.docker.ui.testutils.MockImageFactory;
import org.eclipse.linuxtools.internal.docker.ui.testutils.MockRegistryAccountManagerFactory;
import org.eclipse.linuxtools.internal.docker.ui.testutils.swt.ButtonAssertions;
import org.eclipse.linuxtools.internal.docker.ui.testutils.swt.ClearConnectionManagerRule;
import org.eclipse.linuxtools.internal.docker.ui.testutils.swt.CloseShellRule;
import org.eclipse.linuxtools.internal.docker.ui.testutils.swt.CloseWelcomePageRule;
import org.eclipse.linuxtools.internal.docker.ui.testutils.swt.DockerConnectionManagerUtils;
import org.eclipse.linuxtools.internal.docker.ui.testutils.swt.MenuAssertion;
import org.eclipse.linuxtools.internal.docker.ui.testutils.swt.SWTUtils;
import org.eclipse.swtbot.eclipse.finder.SWTWorkbenchBot;
import org.eclipse.swtbot.eclipse.finder.widgets.SWTBotView;
import org.junit.After;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.mandas.docker.client.DockerClient;
import org.mandas.docker.client.ProgressHandler;
import org.mandas.docker.client.exceptions.DockerException;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class ImagePullSWTBotTest {
    private SWTWorkbenchBot bot = new SWTWorkbenchBot();
    private SWTBotView dockerExplorerViewBot;
    @ClassRule
    public static CloseWelcomePageRule closeWelcomePage = new CloseWelcomePageRule("org.eclipse.linuxtools.docker.ui.perspective");
    @Rule
    public ClearConnectionManagerRule clearConnectionManager = new ClearConnectionManagerRule();
    @Rule
    public CloseShellRule closeShell = new CloseShellRule(IDialogConstants.CANCEL_LABEL);
    private RegistryAccountStorageManager defaultRegistryAccountStorageManager;
    private DockerClient client;

    @Before
    public void lookupDockerExplorerView() {
        this.dockerExplorerViewBot = this.bot.viewById("org.eclipse.linuxtools.docker.ui.dockerExplorerView");
        this.dockerExplorerViewBot.show();
        this.dockerExplorerViewBot.setFocus();
        this.defaultRegistryAccountStorageManager = RegistryAccountManager.getInstance().getStorageManager();
    }

    @Before
    public void setupDockerClient() {
        this.client = MockDockerClientFactory.image(MockImageFactory.name("bar:latest", "foo/bar:latest").build()).build();
        DockerConnection dockerConnection = MockDockerConnectionFactory.from("Test", this.client).withDefaultTCPConnectionSettings();
        DockerConnectionManagerUtils.configureConnectionManager(new IDockerConnection[]{dockerConnection});
    }

    @After
    public void restoreRegistryAccountStorageManager() {
        RegistryAccountManager.getInstance().setStorageManager(this.defaultRegistryAccountStorageManager);
    }

    private void openPullWizard() {
        SWTUtils.getTreeItem(this.dockerExplorerViewBot, "Test", "Images").select();
        this.dockerExplorerViewBot.bot().tree().contextMenu("Pull...").click();
    }

    @Ignore
    @Test
    public void shoulDisableSearchButtonWhenNoRegistrySelected() {
        this.openPullWizard();
        this.bot.text(0).setText("jboss/wildfly:latest");
        ButtonAssertions.assertThat(this.bot.button("Finish")).isNotEnabled();
    }

    @Test
    public void shouldNotAllowFinishWhenImageNameIsMissing() {
        this.openPullWizard();
        ButtonAssertions.assertThat(this.bot.button("Finish")).isNotEnabled();
    }

    @Test
    public void shouldPullImageFromDockerHub() throws DockerException, InterruptedException {
        this.openPullWizard();
        this.bot.text(0).setText("jboss/wildfly:latest");
        this.bot.button("Finish").click();
        ((DockerClient)Mockito.verify((Object)this.client, (VerificationMode)Mockito.times((int)1))).pull((String)ArgumentMatchers.eq((Object)"jboss/wildfly:latest"), (ProgressHandler)ArgumentMatchers.any(DockerProgressHandler.class));
    }

    @Test
    public void shouldPullLatestImageFromDockerHub() throws DockerException, InterruptedException {
        this.openPullWizard();
        this.bot.text(0).setText("jboss/wildfly");
        this.bot.button("Finish").click();
        ((DockerClient)Mockito.verify((Object)this.client, (VerificationMode)Mockito.times((int)1))).pull((String)ArgumentMatchers.eq((Object)"jboss/wildfly:latest"), (ProgressHandler)ArgumentMatchers.any(DockerProgressHandler.class));
    }

    @Test
    public void shouldPullImageFromOtherRegistry() throws DockerException, InterruptedException {
        MockRegistryAccountManagerFactory.registryAccount((IRegistryAccount)new RegistryAccountInfo("http://foo.com", "foo", null, "secret".toCharArray(), false)).build();
        this.openPullWizard();
        this.bot.comboBox(0).setSelection("foo@http://foo.com");
        this.bot.text(0).setText("jboss/wildfly:latest");
        this.bot.button("Finish").click();
        ((DockerClient)Mockito.verify((Object)this.client, (VerificationMode)Mockito.times((int)1))).pull((String)ArgumentMatchers.eq((Object)"foo.com/jboss/wildfly:latest"), (ProgressHandler)ArgumentMatchers.any(DockerProgressHandler.class));
    }

    @Test
    public void shouldDisablePullCommandWhenConnectionStateIsUnknown() {
        this.client = MockDockerClientFactory.build();
        DockerConnection dockerConnection = MockDockerConnectionFactory.from("Test", this.client).withState(EnumDockerConnectionState.UNKNOWN);
        Assertions.assertThat((Comparable)dockerConnection.getState()).isEqualTo((Object)EnumDockerConnectionState.UNKNOWN);
        DockerConnectionManagerUtils.configureConnectionManager(new IDockerConnection[]{dockerConnection});
        SWTUtils.getTreeItem(this.dockerExplorerViewBot, "Test").select();
        MenuAssertion.assertThat(this.dockerExplorerViewBot.bot().tree().contextMenu("Pull...")).isNotEnabled();
    }

    @Test
    public void shouldDisablePullCommandWhenConnectionIsClosed() {
        this.client = MockDockerClientFactory.build();
        DockerConnection dockerConnection = MockDockerConnectionFactory.from("Test", this.client).withState(EnumDockerConnectionState.CLOSED);
        Assertions.assertThat((Comparable)dockerConnection.getState()).isEqualTo((Object)EnumDockerConnectionState.CLOSED);
        DockerConnectionManagerUtils.configureConnectionManager(new IDockerConnection[]{dockerConnection});
        SWTUtils.getTreeItem(this.dockerExplorerViewBot, "Test").select();
        MenuAssertion.assertThat(this.dockerExplorerViewBot.bot().tree().contextMenu("Pull...")).isNotEnabled();
    }

    @Test
    public void shouldEnablePullCommandWhenConnectionIsEstablished() {
        this.client = MockDockerClientFactory.build();
        DockerConnection dockerConnection = MockDockerConnectionFactory.from("Test", this.client).withDefaultTCPConnectionSettings();
        DockerConnectionManagerUtils.configureConnectionManager(new IDockerConnection[]{dockerConnection});
        SWTUtils.getTreeItem(this.dockerExplorerViewBot, "Test").select();
        SWTUtils.wait(1, TimeUnit.SECONDS);
        Assertions.assertThat((Comparable)dockerConnection.getState()).isEqualTo((Object)EnumDockerConnectionState.ESTABLISHED);
        MenuAssertion.assertThat(this.dockerExplorerViewBot.bot().tree().contextMenu("Pull...")).isEnabled();
    }

    @Test
    public void shouldEnablePullCommandWhenConnectionIsEstablishedAndExpanded() {
        this.client = MockDockerClientFactory.build();
        DockerConnection dockerConnection = MockDockerConnectionFactory.from("Test", this.client).withDefaultTCPConnectionSettings();
        DockerConnectionManagerUtils.configureConnectionManager(new IDockerConnection[]{dockerConnection});
        SWTUtils.getTreeItem(this.dockerExplorerViewBot, "Test", "Images").select();
        Assertions.assertThat((Comparable)dockerConnection.getState()).isEqualTo((Object)EnumDockerConnectionState.ESTABLISHED);
        MenuAssertion.assertThat(this.dockerExplorerViewBot.bot().tree().contextMenu("Pull...")).isEnabled();
    }
}

