/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.eclipse.m2e.core.ui.preferences;

import org.eclipse.reddeer.core.matcher.WithTextMatcher;
import org.eclipse.reddeer.core.reference.ReferencedComposite;
import org.eclipse.reddeer.jface.preference.PreferencePage;
import org.eclipse.reddeer.swt.impl.button.CheckBox;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

public class MavenPreferencePage
extends PreferencePage {
    private static final String OFFLINE = "Offline";
    private static final String DO_NOT_AUTO_UPDATE_DEPS = "Do not automatically update dependencies from remote repositories";
    private static final String DEBUG_OUTPUT = "Debug Output";
    private static final String DOWNLOAD_ARTIFACT_SOURCES = "Download Artifact Sources";
    private static final String DOWNLOAD_ARTIFACT_JAVADOC = "Download Artifact JavaDoc";
    private static final String DOWNLOAD_REPO_INDEX_UPDATES_ON_STARTUP = "Download repository index updates on startup";
    private static final String UPDATE_MAVEN_PROJECTS_ON_STARTUP = "Update Maven projects on startup";
    private static final String HIDE_FOLDERS_OF_PHYSICALLY_NESTED_MODULES = "Hide folders of physically nested modules (experimental)";

    public MavenPreferencePage(ReferencedComposite referencedComposite) {
        super(referencedComposite, new String[]{"Maven"});
    }

    public boolean isOfflineChecked() {
        return new CheckBox((ReferencedComposite)this, OFFLINE).isChecked();
    }

    public MavenPreferencePage setOffline(boolean check) {
        new CheckBox((ReferencedComposite)this, OFFLINE).toggle(check);
        return this;
    }

    public boolean isDoNotAutoUpdateDepsChecked() {
        return new CheckBox((ReferencedComposite)this, DO_NOT_AUTO_UPDATE_DEPS).isChecked();
    }

    public MavenPreferencePage setDoNotAutoUpdateDeps(boolean check) {
        new CheckBox((ReferencedComposite)this, DO_NOT_AUTO_UPDATE_DEPS).toggle(check);
        return this;
    }

    public boolean isDebugOutputChecked() {
        return new CheckBox((ReferencedComposite)this, DEBUG_OUTPUT).isChecked();
    }

    public MavenPreferencePage setDebugOutput(boolean check) {
        new CheckBox((ReferencedComposite)this, DEBUG_OUTPUT).toggle(check);
        return this;
    }

    public boolean isDownloadArtifactSourcesChecked() {
        return new CheckBox((ReferencedComposite)this, DOWNLOAD_ARTIFACT_SOURCES).isChecked();
    }

    public MavenPreferencePage setDownloadArtifactSources(boolean check) {
        new CheckBox((ReferencedComposite)this, DOWNLOAD_ARTIFACT_SOURCES).toggle(check);
        return this;
    }

    public boolean isDownloadArtifactJavadocChecked() {
        return this.getDownloadArtifactJavadocButton().isChecked();
    }

    public MavenPreferencePage setDownloadArtifactJavadoc(boolean check) {
        this.getDownloadArtifactJavadocButton().toggle(check);
        return this;
    }

    private CheckBox getDownloadArtifactJavadocButton() {
        return new CheckBox((ReferencedComposite)this, new Matcher[]{new WithTextMatcher((Matcher)new TypeSafeMatcher<String>(){

            protected boolean matchesSafely(String text) {
                return text.toLowerCase().replaceAll("&", "").split("\t")[0].equals(MavenPreferencePage.DOWNLOAD_ARTIFACT_JAVADOC.toLowerCase());
            }

            public void describeTo(Description desc) {
                desc.appendText("Matcher matching text to Download Artifact JavaDoc");
            }
        })});
    }

    public boolean isDownloadRepoIndexOnStartupChecked() {
        return new CheckBox((ReferencedComposite)this, DOWNLOAD_REPO_INDEX_UPDATES_ON_STARTUP).isChecked();
    }

    public MavenPreferencePage setDownloadRepoIndexOnStartup(boolean check) {
        new CheckBox((ReferencedComposite)this, DOWNLOAD_REPO_INDEX_UPDATES_ON_STARTUP).toggle(check);
        return this;
    }

    public boolean isUpdateMavenProjectsOnStartupChecked() {
        return new CheckBox((ReferencedComposite)this, UPDATE_MAVEN_PROJECTS_ON_STARTUP).isChecked();
    }

    public MavenPreferencePage setUpdateMavenProjectsOnStartup(boolean check) {
        new CheckBox((ReferencedComposite)this, UPDATE_MAVEN_PROJECTS_ON_STARTUP).toggle(check);
        return this;
    }

    public boolean isHideFoldersOfPhysicalyNestedModulesChecked() {
        return new CheckBox((ReferencedComposite)this, HIDE_FOLDERS_OF_PHYSICALLY_NESTED_MODULES).isChecked();
    }

    public MavenPreferencePage setHideFoldersOfPhysicalyNestedModules(boolean check) {
        new CheckBox((ReferencedComposite)this, HIDE_FOLDERS_OF_PHYSICALLY_NESTED_MODULES).toggle(check);
        return this;
    }
}

