/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.docker.reddeer.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.linuxtools.docker.core.DockerConnectionManager;
import org.eclipse.linuxtools.docker.core.IDockerConnection;
import org.eclipse.linuxtools.docker.core.IDockerConnectionStorageManager;
import org.eclipse.linuxtools.docker.reddeer.core.ui.wizards.NewDockerConnectionPage;
import org.eclipse.linuxtools.docker.reddeer.ui.resources.AuthenticationMethod;
import org.eclipse.linuxtools.docker.reddeer.ui.resources.DockerConnection;
import org.eclipse.linuxtools.internal.docker.ui.testutils.MockDockerConnectionStorageManagerFactory;
import org.eclipse.reddeer.core.exception.CoreLayerException;
import org.eclipse.reddeer.core.reference.ReferencedComposite;
import org.eclipse.reddeer.jface.exception.JFaceLayerException;
import org.eclipse.reddeer.jface.handler.TreeViewerHandler;
import org.eclipse.reddeer.swt.api.Tree;
import org.eclipse.reddeer.swt.api.TreeItem;
import org.eclipse.reddeer.swt.impl.tree.DefaultTree;
import org.eclipse.reddeer.workbench.impl.view.WorkbenchView;

public class DockerExplorerView
extends WorkbenchView {
    public static final String SCHEME_TERMINATOR = "://";
    public static final String SCHEME_TCP = "tcp";
    public static final String SCHEME_HTTP = "http";
    private TreeViewerHandler treeViewerHandler = TreeViewerHandler.getInstance();

    public DockerExplorerView() {
        super("Docker", "Docker Explorer");
    }

    public List<String> getDockerConnectionNames() {
        this.activate();
        ArrayList<String> connectionsNames = new ArrayList<String>();
        try {
            List connections = new DefaultTree().getItems();
            for (TreeItem item : connections) {
                connectionsNames.add(this.getName(item));
            }
        }
        catch (CoreLayerException coreLayerException) {
            // empty catch block
        }
        return connectionsNames;
    }

    private String getName(TreeItem item) {
        this.activate();
        return this.treeViewerHandler.getNonStyledText(item);
    }

    private String getHost(TreeItem item) {
        this.activate();
        String[] styledTexts = this.treeViewerHandler.getStyledTexts(item);
        if (styledTexts == null || styledTexts.length == 0) {
            return null;
        }
        return styledTexts[0].replaceAll("[\\(\\)]", "");
    }

    public boolean connectionExistForName(String connectionName) {
        this.activate();
        return this.getDockerConnectionByName(connectionName) != null;
    }

    public boolean connectionExistForHost(String host) {
        this.activate();
        return this.getDockerConnectionByHost(host) != null;
    }

    public void refreshView() {
        this.activate();
        List<String> connections = this.getDockerConnectionNames();
        for (String connection : connections) {
            this.getDockerConnectionByName(connection).refresh();
        }
    }

    public void createDockerConnectionSearch(String connectionName) {
        this.activate();
        NewDockerConnectionPage connectionWizard = new NewDockerConnectionPage((ReferencedComposite)this);
        connectionWizard.open();
        connectionWizard.search(connectionName);
        connectionWizard.finish();
    }

    public void createDockerConnectionUnix(String connectionName, String unixSocket) {
        this.activate();
        this.createDockerConnection(AuthenticationMethod.UNIX_SOCKET, unixSocket, null, connectionName);
    }

    public void createDockerConnectionUnix(IDockerConnection ... connections) {
        this.activate();
        IDockerConnectionStorageManager connectionStorageManager = MockDockerConnectionStorageManagerFactory.providing((IDockerConnection[])connections);
        DockerConnectionManager.getInstance().setConnectionStorageManager(connectionStorageManager);
    }

    public void createDockerConnectionURI(String connectionName, String tcpURI, String certificatePath) {
        this.activate();
        this.createDockerConnection(AuthenticationMethod.TCP_CONNECTION, tcpURI, certificatePath, connectionName);
    }

    public void createDockerConnection(AuthenticationMethod authMethod, String unixSocketOrTcpURI, String authentificationCertificatePath, String connectionName) {
        this.activate();
        NewDockerConnectionPage connectionWizard = new NewDockerConnectionPage((ReferencedComposite)this);
        connectionWizard.open();
        connectionWizard.setConnectionName(connectionName);
        if (AuthenticationMethod.TCP_CONNECTION.equals((Object)authMethod)) {
            connectionWizard.setTcpConnection(unixSocketOrTcpURI, authentificationCertificatePath, false);
        } else if (AuthenticationMethod.UNIX_SOCKET.equals((Object)authMethod)) {
            connectionWizard.setUnixSocket(unixSocketOrTcpURI);
        }
        connectionWizard.finish();
    }

    public DockerConnection getDockerConnectionByName(String connectionName) {
        this.activate();
        try {
            return new DockerConnection(this.treeViewerHandler.getTreeItem((Tree)new DefaultTree(), new String[]{connectionName}));
        }
        catch (JFaceLayerException ex) {
            return null;
        }
    }

    public DockerConnection getDockerConnectionByHost(String host) {
        this.activate();
        try {
            List connections = new DefaultTree().getItems();
            for (TreeItem item : connections) {
                if (!this.equalHosts(host, this.getHost(item))) continue;
                return new DockerConnection(item);
            }
        }
        catch (CoreLayerException coreLayerException) {
            // empty catch block
        }
        return null;
    }

    private boolean equalHosts(String host1, String host2) {
        int schemeIndex2;
        if (host1 == null) {
            return host2 == null;
        }
        if (host1.equals(host2)) {
            return true;
        }
        int schemeIndex1 = host1.indexOf(58);
        if (schemeIndex1 >= 0 && (schemeIndex2 = host2.indexOf(SCHEME_TERMINATOR)) >= 0) {
            String scheme1 = host1.substring(0, schemeIndex1);
            String scheme2 = host2.substring(0, schemeIndex2);
            if ((SCHEME_HTTP.equals(scheme1) || SCHEME_TCP.equals(scheme1)) && (SCHEME_HTTP.equals(scheme2) || SCHEME_TCP.equals(scheme2))) {
                String hostAddr1 = host1.substring(schemeIndex1 + SCHEME_TERMINATOR.length(), host1.length());
                String hostAddr2 = host2.substring(schemeIndex2 + SCHEME_TERMINATOR.length(), host2.length());
                return hostAddr1.equals(hostAddr2);
            }
        }
        return false;
    }
}

