/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.docker.reddeer.ui;

import org.eclipse.linuxtools.docker.reddeer.core.ui.wizards.ImageSearchPage;
import org.eclipse.linuxtools.docker.reddeer.core.ui.wizards.ImageTagSelectionPage;
import org.eclipse.linuxtools.docker.reddeer.perspective.DockerPerspective;
import org.eclipse.reddeer.common.condition.WaitCondition;
import org.eclipse.reddeer.common.wait.TimePeriod;
import org.eclipse.reddeer.common.wait.WaitUntil;
import org.eclipse.reddeer.common.wait.WaitWhile;
import org.eclipse.reddeer.core.condition.WidgetIsFound;
import org.eclipse.reddeer.core.matcher.WithMnemonicTextMatcher;
import org.eclipse.reddeer.core.reference.ReferencedComposite;
import org.eclipse.reddeer.eclipse.debug.ui.launchConfigurations.LaunchConfiguration;
import org.eclipse.reddeer.eclipse.exception.EclipseLayerException;
import org.eclipse.reddeer.swt.api.Shell;
import org.eclipse.reddeer.swt.condition.ShellIsActive;
import org.eclipse.reddeer.swt.condition.ShellIsAvailable;
import org.eclipse.reddeer.swt.impl.button.CheckBox;
import org.eclipse.reddeer.swt.impl.button.OkButton;
import org.eclipse.reddeer.swt.impl.button.PushButton;
import org.eclipse.reddeer.swt.impl.button.RadioButton;
import org.eclipse.reddeer.swt.impl.button.YesButton;
import org.eclipse.reddeer.swt.impl.combo.DefaultCombo;
import org.eclipse.reddeer.swt.impl.combo.LabeledCombo;
import org.eclipse.reddeer.swt.impl.ctab.DefaultCTabItem;
import org.eclipse.reddeer.swt.impl.menu.ShellMenu;
import org.eclipse.reddeer.swt.impl.shell.DefaultShell;
import org.eclipse.reddeer.swt.impl.table.DefaultTable;
import org.eclipse.reddeer.swt.impl.text.LabeledText;
import org.eclipse.reddeer.swt.impl.toolbar.DefaultToolItem;
import org.eclipse.reddeer.swt.impl.tree.DefaultTreeItem;
import org.eclipse.reddeer.workbench.core.condition.JobIsRunning;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Control;
import org.hamcrest.Matcher;
import org.junit.Assert;

public class RunDockerImageLaunchConfiguration
extends LaunchConfiguration {
    private static final String MAIN_TAB_LABEL = "Main";
    private static final String VOLUMES_TAB_LABEL = "Volumes";
    private static final String PORTS_TAB_LABEL = "Ports";
    private static final String LINKS_TAB_LABEL = "Links";
    private static final String ENVIRONMENT_TAB_LABEL = "Environment";
    private static final String LABELS_TAB_LABEL = "Labels";
    private static final String RESOURCES_TAB_LABEL = "Resources";
    private static final String DELETE_LAUNCH_CONFIGURATION_LABEL = "Delete selected launch configuration(s)";

    public RunDockerImageLaunchConfiguration() {
        super("Run Docker Image");
    }

    public void open() {
        DockerPerspective p = new DockerPerspective();
        p.open();
        new ShellMenu().getItem(new String[]{"Run", "Run Configurations..."}).select();
        new WaitUntil((WaitCondition)new ShellIsAvailable("Run Configurations"));
    }

    public void createNewConfiguration(String configurationName) {
        new DefaultTreeItem(new String[]{"Run Docker Image"}).select();
        new DefaultToolItem("New launch configuration").click();
        this.setName(configurationName);
    }

    public void selectConfiguration(String confName) {
        new DefaultTreeItem(new String[]{"Run Docker Image", confName}).select();
    }

    private void addValueInTable(String tabName, String shellName, String newValueName, String newValue) {
        this.selectTab(tabName);
        new PushButton("Add...").click();
        new WaitUntil((WaitCondition)new ShellIsAvailable(shellName));
        new LabeledText("Name:").setText(newValueName);
        new LabeledText("Value:").setText(newValue);
        new OkButton().click();
    }

    private void editValueInTable(String tabName, String shellName, String oldValueName, String newValueName, String newValue) {
        this.selectTab(tabName);
        if (!this.selectItemInTable(oldValueName)) {
            throw new EclipseLayerException("There is no " + oldValueName + " in table on tab " + tabName);
        }
        new PushButton("Edit...");
        new WaitWhile((WaitCondition)new ShellIsAvailable(shellName));
        new LabeledText("Name:").setText(newValueName);
        new LabeledText("Value:").setText(newValue);
        new OkButton().click();
    }

    private void removeValueInTable(String tabName, String valueName) {
        this.selectTab(LABELS_TAB_LABEL);
        if (!this.selectItemInTable(valueName)) {
            throw new EclipseLayerException("There is no " + valueName + " in table on tab " + tabName);
        }
        new PushButton("Remove").click();
    }

    public void setConfigurationName(String configurationName) {
        this.selectTab(MAIN_TAB_LABEL);
        new LabeledText("Name:").setText(configurationName);
    }

    public void selectConnection(String connectionName) {
        this.selectTab(MAIN_TAB_LABEL);
        new LabeledCombo("Connection:").setSelection(connectionName);
    }

    public void selectImage(String imageName) {
        this.selectTab(MAIN_TAB_LABEL);
        new LabeledCombo("Image:").setSelection(imageName);
    }

    public void searchImage(String imageName, String tag) {
        this.selectTab(MAIN_TAB_LABEL);
        new PushButton("Search...");
        ImageSearchPage pageOne = new ImageSearchPage((ReferencedComposite)new DefaultCTabItem(MAIN_TAB_LABEL));
        pageOne.searchImage(imageName);
        pageOne.next();
        new WaitWhile((WaitCondition)new ShellIsActive("Progress Information"), TimePeriod.DEFAULT);
        ImageTagSelectionPage pageTwo = new ImageTagSelectionPage((ReferencedComposite)pageOne);
        Assert.assertFalse((String)"Search tags are empty!", (boolean)pageTwo.getTags().isEmpty());
        new WaitWhile((WaitCondition)new JobIsRunning(), TimePeriod.DEFAULT);
        Assert.assertTrue((String)("Search results do not contains tag:" + tag + "!"), (boolean)pageTwo.tagsContains(tag));
        pageTwo.selectTag(tag);
        pageTwo.finish();
        new DefaultShell("Pull Image");
        new PushButton("Finish").click();
        new WaitWhile((WaitCondition)new JobIsRunning(), TimePeriod.VERY_LONG);
    }

    public void setContainerName(String containerName) {
        this.selectTab(MAIN_TAB_LABEL);
        new LabeledText("Container Name:").setText(containerName);
    }

    public void setEntrypoint(String entrypoint) {
        this.selectTab(MAIN_TAB_LABEL);
        new LabeledText("Entrypoint:").setText(entrypoint);
    }

    public void setCommand(String command) {
        this.selectTab(MAIN_TAB_LABEL);
        new LabeledText("Command:").setText(command);
    }

    public void setKeepSTDINopentoConsoleevenifnotattachedi(boolean checked) {
        this.selectTab(MAIN_TAB_LABEL);
        new CheckBox("Keep STDIN open to Console even if not attached (-i)").toggle(checked);
    }

    public void setAllocatepseudoTTYfromConsolet(boolean checked) {
        this.selectTab(MAIN_TAB_LABEL);
        new CheckBox("Allocate pseudo-TTY from Console (-t)").toggle(checked);
    }

    public void setRemoveContainerOnExit(boolean checked) {
        this.selectTab(MAIN_TAB_LABEL);
        new CheckBox("Automatically remove the container when it exits (--rm)").toggle(checked);
    }

    public void setPrivilegedMode(boolean checked) {
        this.selectTab(MAIN_TAB_LABEL);
        new CheckBox("Give extended privileges to this container (--privileged)").toggle(checked);
    }

    public void removeVolume(String valueName) {
        this.removeValueInTable(VOLUMES_TAB_LABEL, valueName);
    }

    public void addDataVolumeNoExternalMount(String containerPath) {
        this.selectTab(VOLUMES_TAB_LABEL);
        new PushButton("Add..").click();
        new LabeledText("Container path:").setText(containerPath);
        new RadioButton("No external mount").click();
        new OkButton().click();
    }

    public void addDataVolumeToHost(String containerPath, String path) {
        this.addDataVolumeToHost(containerPath, path, false);
    }

    public void addDataVolumeToHost(String containerPath, String path, boolean readOnly) {
        this.selectTab(VOLUMES_TAB_LABEL);
        new PushButton("Add...").click();
        new LabeledText("Container path:").setText(containerPath);
        new RadioButton("Mount a host directory or host file").click();
        new LabeledText("Path:").setText(path);
        new CheckBox("Read-only access").toggle(readOnly);
        new OkButton().click();
    }

    public void addDataVolumeToContainer(String containerPath, String containerName) {
        this.selectTab(VOLUMES_TAB_LABEL);
        new PushButton("Add...").click();
        new LabeledText("Container path:").setText(containerPath);
        new RadioButton("Mount a data volume container").click();
        new DefaultCombo("Container").setText(containerName);
        new OkButton().click();
    }

    public void setPublishAllExposedPortsToRandomPorts(boolean checked) {
        new CheckBox("Publish all exposed ports to random ports on the host interfaces").toggle(checked);
    }

    public void addPort(String containerPort, String hostAddress, String hostPort) {
        this.selectTab(PORTS_TAB_LABEL);
        this.setPublishAllExposedPortsToRandomPorts(false);
        new PushButton("Add...").click();
        new WaitUntil((WaitCondition)new ShellIsAvailable("Exposing a Container Port"));
        new LabeledText("Container port:").setText(containerPort);
        new LabeledText("Host address:").setText(hostAddress);
        new LabeledText("Host port:").setText(hostPort);
        new OkButton().click();
    }

    public void editPort(String oldContainerPort, String newContainerPort, String newHostAddress, String newHostPort) {
        this.selectTab(PORTS_TAB_LABEL);
        this.setPublishAllExposedPortsToRandomPorts(false);
        if (!this.selectItemInTable(oldContainerPort)) {
            throw new EclipseLayerException("There is no " + oldContainerPort + " in table on tab " + PORTS_TAB_LABEL);
        }
        new PushButton("Edit...");
        new WaitUntil((WaitCondition)new ShellIsAvailable("Exposing a Container Port"));
        new LabeledText("Container port:").setText(newContainerPort);
        new LabeledText("Host address:").setText(newHostAddress);
        new LabeledText("Host port:").setText(newHostPort);
        new OkButton().click();
    }

    public void removePort(String valueName) {
        this.setPublishAllExposedPortsToRandomPorts(false);
        this.removeValueInTable(PORTS_TAB_LABEL, valueName);
    }

    public void addLink(String containerName, String alias) {
        this.selectTab(LINKS_TAB_LABEL);
        new PushButton("Add...").click();
        new WaitWhile((WaitCondition)new ShellIsAvailable("Container Linking"));
        new LabeledText("Container:").setText(containerName);
        new LabeledText("Value:").setText(alias);
        new OkButton().click();
    }

    public void editLink(String oldContainer, String newContainer, String newAlias) {
        this.selectTab(LINKS_TAB_LABEL);
        if (!this.selectItemInTable(oldContainer)) {
            throw new EclipseLayerException("There is no " + oldContainer + " in table on tab " + LINKS_TAB_LABEL);
        }
        new PushButton("Edit...").click();
        new WaitWhile((WaitCondition)new ShellIsAvailable("Container Linking"));
        new LabeledText("Container:").setText(newContainer);
        new LabeledText("Value:").setText(newAlias);
        new OkButton().click();
    }

    public void removeLink(String linkName) {
        this.removeValueInTable(LINKS_TAB_LABEL, linkName);
    }

    public void addEnvironmentVariable(String variableName, String variableValue) {
        this.addValueInTable(ENVIRONMENT_TAB_LABEL, "Environment Variable", variableName, variableValue);
    }

    public void editEnvironmentVariable(String oldVariable, String newVariable, String newValue) {
        this.editValueInTable(ENVIRONMENT_TAB_LABEL, "Environment Variable", oldVariable, newVariable, newValue);
    }

    public void removeEnvironmentVariable(String variableName) {
        this.removeValueInTable(ENVIRONMENT_TAB_LABEL, variableName);
    }

    public void addLabel(String name, String value) {
        this.addValueInTable(LABELS_TAB_LABEL, "Label", name, value);
    }

    public void removeLabel(String label) {
        this.removeValueInTable(LABELS_TAB_LABEL, label);
    }

    public void editLabel(String label, String newName, String newValue) {
        this.editValueInTable(LABELS_TAB_LABEL, "Label", label, newName, newValue);
    }

    public void setHigh() {
        this.setEnableResourceLimitations(true);
        new RadioButton("High").click();
    }

    public void setMedium() {
        this.setEnableResourceLimitations(true);
        new RadioButton("Medium").click();
    }

    public void setLow() {
        this.setEnableResourceLimitations(true);
        new RadioButton("Low").click();
    }

    public void setEnableResourceLimitations(boolean check) {
        this.selectTab(RESOURCES_TAB_LABEL);
        new CheckBox("Enable resource limitations").toggle(check);
    }

    public void setMemoryLimit(String memoryLimit) {
        this.selectTab(RESOURCES_TAB_LABEL);
        new CheckBox("Enable resource limitations").toggle(true);
        new LabeledText("Memory limit:").setText(memoryLimit);
    }

    public String getMemoryLimit() {
        this.selectTab(RESOURCES_TAB_LABEL);
        new CheckBox("Enable resource limitations").toggle(true);
        return new LabeledText("Memory limit:").getText();
    }

    public DefaultCTabItem selectTab(String label) {
        DefaultCTabItem tab = new DefaultCTabItem(label);
        tab.activate();
        return tab;
    }

    private boolean selectItemInTable(String itemName) {
        DefaultTable table = new DefaultTable();
        if (table.containsItem(itemName)) {
            table.select(new String[]{itemName});
            return true;
        }
        return false;
    }

    public void deleteRunConfiguration(String configuratioName) {
        this.selectConfiguration(configuratioName);
        new DefaultToolItem(DELETE_LAUNCH_CONFIGURATION_LABEL).click();
        DefaultShell deleteShell = new DefaultShell("Confirm Launch Configuration Deletion");
        WidgetIsFound deleteButton = new WidgetIsFound(Button.class, (Control)deleteShell.getSWTWidget(), new Matcher[]{new WithMnemonicTextMatcher("Delete")});
        Object button = deleteButton.test() ? new PushButton((ReferencedComposite)deleteShell, "Delete") : new YesButton((ReferencedComposite)deleteShell);
        button.click();
        new WaitWhile((WaitCondition)new ShellIsAvailable((Shell)deleteShell));
        new WaitUntil((WaitCondition)new ShellIsAvailable("Run Configurations"));
    }

    public void runConfiguration(String configurationName) {
        this.selectConfiguration(configurationName);
        new PushButton("Run").click();
    }

    public void close() {
        new PushButton("Close").click();
    }
}

