/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.docker.reddeer.ui.resources;

import org.eclipse.linuxtools.docker.reddeer.ui.AbstractDockerExplorerItem;
import org.eclipse.reddeer.common.condition.WaitCondition;
import org.eclipse.reddeer.common.wait.TimePeriod;
import org.eclipse.reddeer.common.wait.WaitWhile;
import org.eclipse.reddeer.swt.api.Shell;
import org.eclipse.reddeer.swt.api.TreeItem;
import org.eclipse.reddeer.swt.condition.ShellIsAvailable;
import org.eclipse.reddeer.swt.impl.button.CheckBox;
import org.eclipse.reddeer.swt.impl.button.FinishButton;
import org.eclipse.reddeer.swt.impl.button.OkButton;
import org.eclipse.reddeer.swt.impl.combo.DefaultCombo;
import org.eclipse.reddeer.swt.impl.menu.ContextMenu;
import org.eclipse.reddeer.swt.impl.shell.DefaultShell;
import org.eclipse.reddeer.swt.impl.text.LabeledText;
import org.eclipse.reddeer.workbench.core.condition.JobIsRunning;

public class DockerImage
extends AbstractDockerExplorerItem {
    public DockerImage(TreeItem treeItem) {
        super(treeItem);
    }

    public void remove() {
        this.select();
        new ContextMenu().getItem(new String[]{"Remove"}).select();
        DefaultShell confirm = new DefaultShell("Confirm Remove Image");
        new OkButton().click();
        new WaitWhile((WaitCondition)new ShellIsAvailable((Shell)confirm));
        new WaitWhile((WaitCondition)new JobIsRunning(), TimePeriod.LONG);
    }

    public void openImageHierarchy() {
        this.select();
        new ContextMenu().getItem(new String[]{"Open Image Hierarchy"}).select();
    }

    public void pushImage(String registryAccount, boolean forceTagging, boolean keepTaggedImage) {
        this.select();
        new ContextMenu().getItem(new String[]{"Push..."}).select();
        new DefaultShell("Push Image");
        DefaultCombo combo = new DefaultCombo();
        combo.setSelection(registryAccount);
        new CheckBox("Force tagging image with selected registry").toggle(forceTagging);
        new CheckBox("Keep tagged image upon completion").toggle(keepTaggedImage);
        new FinishButton().click();
    }

    public void addTagToImage(String newTag) {
        this.select();
        new ContextMenu().getItem(new String[]{"Add Tag"}).select();
        new DefaultShell("Tag Image");
        new LabeledText("New Tag:").setText(newTag);
        new FinishButton().click();
    }

    public void run() {
        this.select();
        new ContextMenu().getItem(new String[]{"Run..."}).select();
    }
}

