/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.docker.integration.tests;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.linuxtools.docker.integration.tests.StringUtils;
import org.eclipse.linuxtools.docker.integration.tests.container.VolumeMountTest;
import org.eclipse.linuxtools.docker.integration.tests.mock.MockUtils;
import org.eclipse.linuxtools.docker.reddeer.perspective.DockerPerspective;
import org.eclipse.linuxtools.docker.reddeer.ui.DockerExplorerView;
import org.eclipse.linuxtools.docker.reddeer.ui.resources.AuthenticationMethod;
import org.eclipse.linuxtools.docker.reddeer.ui.resources.DockerConnection;
import org.eclipse.reddeer.core.exception.CoreLayerException;
import org.eclipse.reddeer.eclipse.ui.console.ConsoleView;
import org.eclipse.reddeer.eclipse.ui.views.properties.PropertySheet;
import org.eclipse.reddeer.junit.runner.RedDeerSuite;
import org.eclipse.reddeer.requirements.openperspective.OpenPerspectiveRequirement;
import org.eclipse.reddeer.swt.exception.SWTLayerException;
import org.eclipse.reddeer.swt.impl.button.PushButton;
import org.eclipse.reddeer.swt.impl.shell.DefaultShell;
import org.eclipse.reddeer.swt.impl.text.LabeledText;
import org.eclipse.reddeer.workbench.handler.WorkbenchShellHandler;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.runner.RunWith;

@RunWith(value=RedDeerSuite.class)
@OpenPerspectiveRequirement.OpenPerspective(value=DockerPerspective.class)
public abstract class AbstractDockerBotTest {
    private static final String JOB_PUSHING_DOCKER_IMAGE = "Pushing Docker Image";
    private static final String JOB_TAGGING_IMAGE = "Tagging Image";
    private static final String JOB_PULLING_DOCKER_IMAGE = "Pulling docker image";
    private static final String JOB_OPENNING_CONNECTION = "Opening connection...";
    private static final String SYSPROP_DOCKER_MACHINE_NAME = "dockerMachineName";
    private static final String SYSPROP_DOCKER_SERVER_URI = "dockerServerURI";
    private static final String SYSPROP_UNIX_SOCKET = "unixSocket";
    protected static final String SYSPROP_MOCKITO = "dockerMockito";
    protected static final String DEFAULT_CONNECTION_NAME = "default";
    protected DockerConnection connection = null;

    @BeforeClass
    public static void beforeClass() {
        AbstractDockerBotTest.deleteAllConnections();
    }

    @AfterClass
    public static void afterClass() {
        AbstractDockerBotTest.killRunningImageJobs();
        AbstractDockerBotTest.cleanupShells();
    }

    protected static void cleanupShells() {
        WorkbenchShellHandler.getInstance().closeAllNonWorbenchShells();
    }

    protected List<String> getIds(String stringWithIds) {
        if (StringUtils.isBlank(stringWithIds)) {
            return Collections.emptyList();
        }
        ArrayList<String> idList = new ArrayList();
        idList = new ArrayList<String>(Arrays.asList(stringWithIds.split("\\r?\\n")));
        return idList;
    }

    protected DockerConnection createConnection() {
        DockerExplorerView dockerView = new DockerExplorerView();
        dockerView.open();
        String dockerMachineName = System.getProperty(SYSPROP_DOCKER_MACHINE_NAME);
        String dockerServerURI = System.getProperty(SYSPROP_DOCKER_SERVER_URI);
        String unixSocket = System.getProperty(SYSPROP_UNIX_SOCKET);
        String mockito = System.getProperty(SYSPROP_MOCKITO);
        if (!StringUtils.isBlank(dockerMachineName)) {
            dockerView.createDockerConnectionSearch(dockerMachineName);
            this.connection = AbstractDockerBotTest.getConnectionByName(dockerMachineName);
        } else if (!StringUtils.isEmpty(dockerServerURI)) {
            dockerView.createDockerConnection(AuthenticationMethod.TCP_CONNECTION, dockerServerURI, null, dockerServerURI);
            this.connection = this.getConnectionByHost(dockerServerURI);
        } else if (!StringUtils.isEmpty(unixSocket)) {
            dockerView.createDockerConnection(AuthenticationMethod.UNIX_SOCKET, unixSocket, null, unixSocket);
            this.connection = this.getConnectionByHost(unixSocket);
        } else if ("true".equals(mockito)) {
            MockUtils.createDockerMockConnection(DEFAULT_CONNECTION_NAME);
            this.connection = AbstractDockerBotTest.getConnectionByName(DEFAULT_CONNECTION_NAME);
        } else {
            Assert.fail((String)"Cannot create a docker connection. Neither dockerMachineName nor dockerServerURI nor unixSocket were defined nor, dockerMockito was enabled.");
        }
        this.connection.enableConnection();
        return this.connection;
    }

    protected void deleteConnection() {
        this.getConnection().removeConnection();
        this.connection = null;
    }

    protected String createURL(String tail) {
        String dockerServerURI = System.getProperty(SYSPROP_DOCKER_SERVER_URI);
        String serverURI = null;
        if (!StringUtils.isBlank(System.getProperty(SYSPROP_DOCKER_MACHINE_NAME)) || !StringUtils.isBlank(System.getProperty(SYSPROP_UNIX_SOCKET)) || StringUtils.isBlank(dockerServerURI)) {
            serverURI = "http://localhost:1234";
        } else if (!StringUtils.isBlank(dockerServerURI)) {
            serverURI = dockerServerURI.replaceAll("tcp", "http");
        }
        return String.valueOf(serverURI.substring(0, serverURI.lastIndexOf(":"))) + tail;
    }

    protected List<String> getImages(String dockerServer) {
        return this.getConnection().getImagesNames();
    }

    protected List<String> getContainers(String dockerServer) {
        return this.getConnection().getContainersNames();
    }

    protected void cleanUpWorkspace() {
        AbstractDockerBotTest.cleanupShells();
        AbstractDockerBotTest.killRunningImageJobs();
    }

    private String getServer() {
        if (!StringUtils.isBlank(System.getProperty(SYSPROP_DOCKER_SERVER_URI))) {
            return System.getProperty(SYSPROP_DOCKER_SERVER_URI);
        }
        if (!StringUtils.isBlank(System.getProperty(SYSPROP_UNIX_SOCKET))) {
            return System.getProperty(SYSPROP_UNIX_SOCKET);
        }
        return DEFAULT_CONNECTION_NAME;
    }

    private boolean isDockerServerHost() {
        return !StringUtils.isBlank(System.getProperty(SYSPROP_DOCKER_SERVER_URI)) || !StringUtils.isBlank(System.getProperty(SYSPROP_UNIX_SOCKET));
    }

    public static void setSecureStorage(String password) {
        try {
            new DefaultShell("Secure Storage Password");
            new LabeledText("Password:").setText(password);
            new LabeledText("Confirm password:").setText(password);
            new PushButton("OK").click();
            new DefaultShell("Secure Storage - Password Hint Needed");
            new PushButton("NO").click();
        }
        catch (CoreLayerException coreLayerException) {
        }
        catch (SWTLayerException e) {
            try {
                new DefaultShell("Secure Storage");
                new LabeledText("Password:").setText(password);
                new LabeledText("Confirm password:").setText(password);
                new PushButton("OK").click();
            }
            catch (SWTLayerException sWTLayerException) {
            }
            catch (CoreLayerException ex) {
                new PushButton("OK").click();
            }
        }
    }

    public static void killRunningImageJobs() {
        Job[] currentJobs;
        Job[] jobArray = currentJobs = Job.getJobManager().find(null);
        int n = currentJobs.length;
        int n2 = 0;
        while (n2 < n) {
            Job job = jobArray[n2];
            String jobName = job.getName();
            if (jobName.startsWith(JOB_PULLING_DOCKER_IMAGE) || jobName.startsWith(JOB_TAGGING_IMAGE) || jobName.startsWith(JOB_PUSHING_DOCKER_IMAGE) || jobName.startsWith(JOB_OPENNING_CONNECTION)) {
                job.cancel();
            }
            ++n2;
        }
    }

    protected DockerConnection getConnection() {
        if (this.connection != null) {
            return this.connection;
        }
        if (this.isDockerServerHost()) {
            this.connection = this.getConnectionByHost(this.getServer());
        } else if (!this.mockitoIsUsed()) {
            this.connection = AbstractDockerBotTest.getConnectionByName(this.getServer());
        }
        if (this.connection == null) {
            this.createConnection();
        }
        this.connection.enableConnection();
        return this.connection;
    }

    protected static DockerConnection getConnectionByName(String name) {
        DockerConnection connection = new DockerExplorerView().getDockerConnectionByName(name);
        return connection;
    }

    private DockerConnection getConnectionByHost(String host) {
        DockerConnection connection = new DockerExplorerView().getDockerConnectionByHost(host);
        return connection;
    }

    protected static void deleteAllConnections() {
        for (String name : new DockerExplorerView().getDockerConnectionNames()) {
            AbstractDockerBotTest.getConnectionByName(name).removeConnection();
        }
    }

    protected void clearConsole() {
        ConsoleView cview = new ConsoleView();
        cview.open();
        try {
            cview.clearConsole();
        }
        catch (CoreLayerException coreLayerException) {
            // empty catch block
        }
    }

    protected PropertySheet openPropertiesTab(String tabName) {
        PropertySheet propertiesView = new PropertySheet();
        propertiesView.open();
        this.getConnection().select();
        propertiesView.selectTab(tabName);
        return propertiesView;
    }

    protected PropertySheet openPropertiesTabForImage(String tabName, String imageName) {
        PropertySheet propertiesView = new PropertySheet();
        propertiesView.open();
        this.getConnection().getImage(imageName).select();
        propertiesView.selectTab(tabName);
        return propertiesView;
    }

    protected PropertySheet openPropertiesTabForContainer(String tabName, String containerName) {
        PropertySheet propertiesView = new PropertySheet();
        propertiesView.open();
        this.getConnection().getContainer(containerName).select();
        propertiesView.selectTab(tabName);
        return propertiesView;
    }

    protected String getResourceAsString(String path) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        IOUtils.copy((InputStream)VolumeMountTest.class.getResourceAsStream("/" + path), (OutputStream)out);
        return new String(out.toByteArray());
    }

    protected boolean isDockerDaemon(int majorVersion, int minorVersion) {
        PropertySheet infoTab = this.openPropertiesTab("Info");
        this.getConnection().select();
        String daemonVersion = infoTab.getProperty(new String[]{"Version"}).getPropertyValue();
        Assert.assertTrue((String)"Could not retrieve docker daemon version.", (!StringUtils.isBlank(daemonVersion) ? 1 : 0) != 0);
        String[] versionComponents = daemonVersion.split("\\.");
        Assert.assertTrue((String)("Could not evaluate docker daemon version " + daemonVersion), (versionComponents == null || versionComponents.length >= 2 ? 1 : 0) != 0);
        int actualMajorVersion = Integer.parseInt(versionComponents[0]);
        if (actualMajorVersion > majorVersion) {
            return true;
        }
        int actualMinorVersion = Integer.parseInt(versionComponents[1]);
        return actualMinorVersion >= minorVersion;
    }

    protected boolean mockitoIsUsed() {
        String mockito = System.getProperty(SYSPROP_MOCKITO);
        return "true".equals(mockito);
    }

    protected void prepareConnections() {
        AbstractDockerBotTest.deleteAllConnections();
        if (this.mockitoIsUsed()) {
            MockUtils.createDockerMockConnection(DEFAULT_CONNECTION_NAME);
        } else {
            this.getConnection();
        }
    }
}

