/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.docker.integration.tests.image;

import java.io.File;
import java.io.IOException;
import org.eclipse.linuxtools.docker.integration.tests.StringUtils;
import org.eclipse.linuxtools.docker.integration.tests.image.AbstractImageBotTest;
import org.eclipse.linuxtools.docker.reddeer.ui.DockerImagesTab;
import org.eclipse.reddeer.common.condition.WaitCondition;
import org.eclipse.reddeer.common.wait.TimePeriod;
import org.eclipse.reddeer.common.wait.WaitUntil;
import org.eclipse.reddeer.common.wait.WaitWhile;
import org.eclipse.reddeer.swt.api.CTabItem;
import org.eclipse.reddeer.swt.condition.ShellIsAvailable;
import org.eclipse.reddeer.swt.impl.button.FinishButton;
import org.eclipse.reddeer.swt.impl.button.PushButton;
import org.eclipse.reddeer.swt.impl.ctab.DefaultCTabFolder;
import org.eclipse.reddeer.swt.impl.shell.DefaultShell;
import org.eclipse.reddeer.swt.impl.styledtext.DefaultStyledText;
import org.eclipse.reddeer.swt.impl.text.LabeledText;
import org.eclipse.reddeer.swt.impl.toolbar.DefaultToolItem;
import org.eclipse.reddeer.swt.keyboard.KeyboardFactory;
import org.eclipse.reddeer.workbench.core.condition.JobIsRunning;
import org.junit.After;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class EditDockerFileTest
extends AbstractImageBotTest {
    protected static final String IMAGE_NAME = "test-edit-dockerfile";
    private static final String BUILD_IMAGE = "FROM alpine:latest\nMAINTAINER Josef Kopriva <jkopriva@redhat.com>";

    @Test
    @Ignore
    public void testEditDockerFile() {
        this.getConnection();
        DockerImagesTab imageTab = this.openDockerImagesTab();
        try {
            String dockerFilePath = new File("resources/test-edit-dockerfile").getCanonicalPath();
            this.getConnection();
            imageTab.activate();
            new DefaultToolItem("Build Image").click();
            new WaitUntil((WaitCondition)new ShellIsAvailable("Build a Docker Image"));
            new LabeledText("Image Name:").setText(IMAGE_NAME);
            new LabeledText("Directory:").setText(dockerFilePath);
            new PushButton("Edit Dockerfile").click();
            new WaitUntil((WaitCondition)new ShellIsAvailable("Dockerfile Editor"), TimePeriod.LONG);
            DefaultStyledText defaultStyledText = new DefaultStyledText();
            String editorText = defaultStyledText.getText();
            Assert.assertTrue((String)"Editor is empty!", (boolean)StringUtils.isNotEmpty(editorText));
            defaultStyledText.setText(BUILD_IMAGE);
            DefaultCTabFolder tabFolder = new DefaultCTabFolder();
            CTabItem tabItem = tabFolder.getSelection();
            KeyboardFactory.getKeyboard().invokeKeyCombination(new int[]{262144, 83});
            tabItem.close();
            new DefaultShell("Build a Docker Image").setFocus();
            new FinishButton().click();
            new WaitWhile((WaitCondition)new JobIsRunning(), TimePeriod.VERY_LONG);
        }
        catch (IOException ex) {
            Assert.fail((String)"Resource file not found!");
        }
    }

    @Override
    @After
    public void after() {
        this.deleteImageContainer(IMAGE_NAME);
        this.cleanUpWorkspace();
    }
}

