/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.docker.integration.tests.image;

import java.util.List;
import org.eclipse.linuxtools.docker.core.IDockerConnection;
import org.eclipse.linuxtools.docker.integration.tests.image.AbstractImageBotTest;
import org.eclipse.linuxtools.docker.integration.tests.mock.MockDockerConnectionManager;
import org.eclipse.linuxtools.docker.reddeer.ui.DockerImageHierarchyTab;
import org.eclipse.linuxtools.docker.reddeer.ui.DockerImagesTab;
import org.eclipse.linuxtools.internal.docker.core.DockerConnection;
import org.eclipse.linuxtools.internal.docker.ui.testutils.MockDockerClientFactory;
import org.eclipse.linuxtools.internal.docker.ui.testutils.MockDockerConnectionFactory;
import org.eclipse.linuxtools.internal.docker.ui.testutils.MockImageFactory;
import org.eclipse.reddeer.common.condition.WaitCondition;
import org.eclipse.reddeer.common.wait.WaitWhile;
import org.eclipse.reddeer.swt.api.TreeItem;
import org.eclipse.reddeer.swt.condition.ShellIsAvailable;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mandas.docker.client.DockerClient;
import org.mandas.docker.client.messages.Image;

public class HierarchyViewTest
extends AbstractImageBotTest {
    private static final int DAEMON_MAJOR_VERSION = 11;
    private static final int DAEMON_MINOR_VERSION = 1;
    private DockerConnection connection;

    @Before
    public void before() {
        HierarchyViewTest.deleteAllConnections();
        this.getConnection();
    }

    @Test
    public void testHierarchyView() {
        DockerImagesTab imageTab = this.openDockerImagesTab();
        this.buildImage("test_build", "resources/test-build", imageTab);
        if (this.mockitoIsUsed()) {
            this.buildImage();
        }
        DockerImageHierarchyTab hierarchyTab = this.openDockerImageHierarchyTab();
        List treeItems = hierarchyTab.getTreeItems();
        this.compareTextInFirstNode(treeItems, "alpine:3.3");
        List treeItems2 = ((TreeItem)treeItems.get(0)).getItems();
        this.compareTextInFirstNode(treeItems2, "test_build:latest");
    }

    public void compareTextInFirstNode(List<TreeItem> treeItems, String expectedValue) {
        String nodeText = treeItems.get(0).getText().replaceAll("\\(.*\\)", "").trim();
        if (!this.mockitoIsUsed() && this.isDockerDaemon(11, 1)) {
            nodeText = nodeText.replaceAll("docker.io/", "");
        }
        Assert.assertTrue((String)("Hierarchy view contains string: " + nodeText + ", but it is expected: " + expectedValue), (boolean)nodeText.startsWith(expectedValue));
    }

    private DockerImageHierarchyTab openDockerImageHierarchyTab() {
        this.getConnection().getImage("test_build").openImageHierarchy();
        new WaitWhile((WaitCondition)new ShellIsAvailable("Docker Image Hierarchy"));
        DockerImageHierarchyTab hierarchyTab = new DockerImageHierarchyTab();
        hierarchyTab.open();
        return hierarchyTab;
    }

    @Override
    @After
    public void after() {
        this.deleteImageContainerAfter("test_build");
        this.cleanUpWorkspace();
    }

    public void buildImage() {
        Image rootImage = MockImageFactory.id((String)"sha256:alpine:3.3").name("alpine:3.3", new String[0]).build();
        Image fooImage1 = MockImageFactory.id((String)"sha256:test_build:latest").name("test_build:latest", new String[0]).parentId("sha256:alpine:3.3").build();
        DockerClient client = MockDockerClientFactory.image((Image)rootImage).image(fooImage1).build();
        this.connection = MockDockerConnectionFactory.from((String)"default", (DockerClient)client).withDefaultTCPConnectionSettings();
        this.connection.getImages(true);
        this.connection.getContainers(true);
        MockDockerConnectionManager.configureConnectionManager(new IDockerConnection[]{this.connection});
    }
}

