/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.docker.integration.tests.mock;

import org.eclipse.reddeer.eclipse.ui.browser.WebBrowserView;
import org.mockito.Mockito;

public class MockBrowserView {
    public static Builder open() {
        return new Builder().open();
    }

    public static Builder openPageURL(String url) {
        return new Builder().openPageURL(url);
    }

    public static Builder setText(String text) {
        return new Builder().setText(text);
    }

    public static class Builder {
        private String url;
        private String text;

        public Builder setText(String text) {
            this.text = text;
            return this;
        }

        public Builder openPageURL(String url) {
            this.url = url;
            return this;
        }

        public Builder open() {
            return this;
        }

        public WebBrowserView build() {
            WebBrowserView browserView = (WebBrowserView)Mockito.mock(WebBrowserView.class);
            Mockito.when((Object)browserView.getPageURL()).thenReturn((Object)this.url);
            Mockito.when((Object)browserView.getText()).thenReturn((Object)this.text);
            return browserView;
        }
    }
}

