/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.docker.reddeer.ui;

import java.util.List;
import org.eclipse.reddeer.common.condition.WaitCondition;
import org.eclipse.reddeer.common.wait.WaitUntil;
import org.eclipse.reddeer.eclipse.exception.EclipseLayerException;
import org.eclipse.reddeer.swt.api.TableItem;
import org.eclipse.reddeer.swt.condition.ShellIsAvailable;
import org.eclipse.reddeer.swt.impl.button.CheckBox;
import org.eclipse.reddeer.swt.impl.button.FinishButton;
import org.eclipse.reddeer.swt.impl.combo.DefaultCombo;
import org.eclipse.reddeer.swt.impl.menu.ContextMenu;
import org.eclipse.reddeer.swt.impl.shell.DefaultShell;
import org.eclipse.reddeer.swt.impl.table.DefaultTable;
import org.eclipse.reddeer.swt.impl.text.DefaultText;
import org.eclipse.reddeer.swt.impl.text.LabeledText;
import org.eclipse.reddeer.swt.impl.toolbar.DefaultToolItem;
import org.eclipse.reddeer.workbench.impl.view.WorkbenchView;

public class DockerImagesTab
extends WorkbenchView {
    public DockerImagesTab() {
        super("Docker Images");
    }

    public TableItem getDockerImage(String dockerImageName) {
        this.activate();
        for (TableItem item : this.getTableItems()) {
            if (!item.getText(1).contains(dockerImageName)) continue;
            return item;
        }
        throw new EclipseLayerException("There is no Docker image with name " + dockerImageName);
    }

    public void refresh() {
        this.activate();
        new DefaultToolItem("Refresh (F5)").click();
    }

    public List<TableItem> getTableItems() {
        this.activate();
        return new DefaultTable().getItems();
    }

    public void buildImage(String name, String directory) {
        this.activate();
        new DefaultToolItem("Build Image").click();
        new WaitUntil((WaitCondition)new ShellIsAvailable("Build a Docker Image"));
        new LabeledText("Image Name:").setText(name);
        new LabeledText("Directory:").setText(directory);
        new FinishButton().click();
    }

    public void runImage(String imageName) {
        this.activate();
        this.selectImage(imageName);
        new ContextMenu().getItem(new String[]{"Run..."}).select();
    }

    public String getImageTags(String imageName) {
        this.activate();
        TableItem image = this.getDockerImage(imageName);
        return image.getText(1);
    }

    public void addTagToImage(String imageName, String newTag) {
        this.selectImage(imageName);
        new ContextMenu().getItem(new String[]{"Add Tag"}).select();
        new DefaultShell("Tag Image");
        new LabeledText("New Tag:").setText(newTag);
        new FinishButton().click();
    }

    public void removeTagFromImage(String imageName, String tagToBeRemoved) {
        this.selectImage(imageName);
        new ContextMenu().getItem(new String[]{"Remove Tag"}).select();
        String fullTag = "";
        DefaultCombo combo = new DefaultCombo();
        List comboItems = combo.getItems();
        for (String item : comboItems) {
            if (!item.contains(tagToBeRemoved)) continue;
            fullTag = item;
            break;
        }
        combo.setSelection(fullTag);
        new FinishButton().click();
    }

    public void selectImage(String imageName) {
        this.activate();
        TableItem image = this.getDockerImage(imageName);
        image.select();
    }

    public void pushImage(String imageName, String registryAccount, boolean forceTagging, boolean keepTaggedImage) {
        this.selectImage(imageName);
        new ContextMenu().getItem(new String[]{"Push..."}).select();
        DefaultCombo combo = new DefaultCombo();
        combo.setSelection(registryAccount);
        new CheckBox("Force tagging image with selected registry").toggle(forceTagging);
        new CheckBox("Keep tagged image upon completion").toggle(keepTaggedImage);
        new FinishButton().click();
    }

    public void searchImage(String searchText) {
        this.activate();
        new DefaultText().setText(searchText);
    }
}

