/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.testutils;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.mandas.docker.client.messages.ContainerConfig;
import org.mandas.docker.client.messages.ImageInfo;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;

public class MockImageInfoFactory {
    public static Builder volume(String volume) {
        return new Builder().volume(volume);
    }

    public static class Builder {
        private final ImageInfo imageInfo = (ImageInfo)Mockito.mock(ImageInfo.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        private Set<String> volumes;
        private List<String> command;
        private List<String> entrypoint;
        private List<String> env;

        private Builder() {
        }

        public Builder volume(String volume) {
            if (this.volumes == null) {
                this.volumes = Set.of(volume);
            }
            HashSet<String> tmpVolumes = new HashSet<String>();
            tmpVolumes.addAll(this.volumes);
            tmpVolumes.add(volume);
            this.volumes = Collections.unmodifiableSet(tmpVolumes);
            return this;
        }

        public Builder command(List<String> command) {
            this.command = command;
            return this;
        }

        public Builder entrypoint(List<String> entrypoint) {
            this.entrypoint = entrypoint;
            return this;
        }

        public Builder env(List<String> env) {
            this.env = env;
            return this;
        }

        public ImageInfo build() {
            ContainerConfig config = (ContainerConfig)Mockito.mock(ContainerConfig.class);
            ContainerConfig containerConfig = (ContainerConfig)Mockito.mock(ContainerConfig.class);
            Mockito.when((Object)this.imageInfo.config()).thenReturn((Object)config);
            Mockito.when((Object)this.imageInfo.containerConfig()).thenReturn((Object)containerConfig);
            Mockito.when((Object)config.cmd()).thenReturn(List.copyOf(this.command));
            Mockito.when((Object)config.entrypoint()).thenReturn(List.copyOf(this.entrypoint));
            Mockito.when((Object)config.volumes()).thenReturn(Set.copyOf(this.volumes));
            Mockito.when((Object)config.env()).thenReturn(List.copyOf(this.env));
            return this.imageInfo;
        }
    }
}

