/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.views;

import java.util.List;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.eclipse.linuxtools.docker.core.IDockerConnection;
import org.eclipse.linuxtools.docker.core.IDockerContainerListener;
import org.eclipse.linuxtools.internal.docker.core.DockerConnection;
import org.eclipse.linuxtools.internal.docker.core.DockerContainerRefreshManager;
import org.eclipse.linuxtools.internal.docker.ui.testutils.MockContainerFactory;
import org.eclipse.linuxtools.internal.docker.ui.testutils.MockDockerClientFactory;
import org.eclipse.linuxtools.internal.docker.ui.testutils.MockDockerConnectionFactory;
import org.eclipse.linuxtools.internal.docker.ui.testutils.MockImageFactory;
import org.eclipse.linuxtools.internal.docker.ui.testutils.swt.ClearConnectionManagerRule;
import org.eclipse.linuxtools.internal.docker.ui.testutils.swt.CloseWelcomePageRule;
import org.eclipse.linuxtools.internal.docker.ui.testutils.swt.DockerConnectionManagerUtils;
import org.eclipse.linuxtools.internal.docker.ui.testutils.swt.DockerImageHierarchyViewAssertions;
import org.eclipse.linuxtools.internal.docker.ui.testutils.swt.SWTUtils;
import org.eclipse.linuxtools.internal.docker.ui.testutils.swt.TabDescriptorAssertions;
import org.eclipse.linuxtools.internal.docker.ui.testutils.swt.TestLoggerRule;
import org.eclipse.linuxtools.internal.docker.ui.views.DockerImageHierarchyView;
import org.eclipse.linuxtools.internal.docker.ui.views.DockerImagesView;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swtbot.eclipse.finder.SWTWorkbenchBot;
import org.eclipse.swtbot.eclipse.finder.widgets.SWTBotView;
import org.eclipse.swtbot.swt.finder.widgets.AbstractSWTBot;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTableItem;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotToolbarButton;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.properties.PropertySheet;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.mandas.docker.client.DockerClient;

public class DockerImagesViewSWTBotTest {
    private SWTWorkbenchBot bot = new SWTWorkbenchBot();
    private SWTBotView dockerImagesBotView;
    private DockerImagesView dockerImagesView;
    private SWTBotView dockerExplorerBotView;
    @ClassRule
    public static CloseWelcomePageRule closeWelcomePage = new CloseWelcomePageRule("org.eclipse.linuxtools.docker.ui.perspective");
    @Rule
    public TestLoggerRule watcher = new TestLoggerRule();
    @Rule
    public ClearConnectionManagerRule clearConnectionManager = new ClearConnectionManagerRule();

    @Before
    public void setup() {
        this.bot = new SWTWorkbenchBot();
        DockerClient client = MockDockerClientFactory.container(MockContainerFactory.name("angry_bar", new String[0]).status("Stopped").build()).image(MockImageFactory.id("987654321abcde").name("default:1", new String[0]).build()).build();
        DockerConnection dockerConnection = MockDockerConnectionFactory.from("Default", client).withDefaultTCPConnectionSettings();
        DockerConnectionManagerUtils.configureConnectionManager(new IDockerConnection[]{dockerConnection});
        SWTUtils.asyncExec(() -> {
            try {
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.eclipse.linuxtools.docker.ui.dockerExplorerView");
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.eclipse.linuxtools.docker.ui.dockerImagesView");
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.fail((String)("Failed to open Docker Images view: " + e.getMessage()));
            }
        });
        this.dockerImagesBotView = this.bot.viewById("org.eclipse.linuxtools.docker.ui.dockerImagesView");
        this.dockerImagesView = (DockerImagesView)this.dockerImagesBotView.getViewReference().getView(true);
        this.dockerExplorerBotView = this.bot.viewById("org.eclipse.linuxtools.docker.ui.dockerExplorerView");
    }

    private SWTBotTableItem selectImageInTable(String imageName) {
        SWTBotTableItem tableItem = SWTUtils.getListItem(this.dockerImagesBotView.bot().table(), imageName);
        Assertions.assertThat((Object)tableItem).isNotNull();
        return tableItem.click().select();
    }

    private void unselectImages() {
        this.dockerImagesBotView.bot().table().unselect();
    }

    private void unselectConnections() {
        this.dockerExplorerBotView.bot().tree().unselect();
    }

    @Test
    public void shouldShowDefaultImages() {
        SWTUtils.syncAssert(() -> {
            Object[] images = this.dockerImagesView.getViewer().getTable().getItems();
            Assertions.assertThat((Object[])images).hasSize(1);
            Assertions.assertThat((String)images[0].getText(1)).isEqualTo("default:1");
        });
    }

    @Test
    public void shouldShowAllImageVariants() {
        DockerClient client = MockDockerClientFactory.image(MockImageFactory.id("1a2b3c4d5e6f7g").name("foo:1.0", "foo:latest", "bar:1.0", "bar:latest").build()).build();
        DockerConnection dockerConnection = MockDockerConnectionFactory.from("Test", client).withDefaultTCPConnectionSettings();
        DockerConnectionManagerUtils.configureConnectionManager(new IDockerConnection[]{dockerConnection});
        SWTUtils.getTreeItem(this.dockerExplorerBotView, "Test").select();
        SWTUtils.syncAssert(() -> {
            Object[] images = this.dockerImagesView.getViewer().getTable().getItems();
            Assertions.assertThat((Object[])images).hasSize(1);
            Assertions.assertThat((String)images[0].getText(1)).isEqualTo("bar:1.0\nbar:latest\nfoo:1.0\nfoo:latest");
        });
    }

    @Test
    public void shouldRemoveListenersWhenClosingView() {
        DockerClient client = MockDockerClientFactory.container(MockContainerFactory.name("angry_bar", new String[0]).status("Stopped").build()).build();
        DockerConnection dockerConnection = MockDockerConnectionFactory.from("Test", client).withDefaultTCPConnectionSettings();
        DockerConnectionManagerUtils.configureConnectionManager(new IDockerConnection[]{dockerConnection});
        SWTUtils.getTreeItem(this.dockerExplorerBotView, "Test").select();
        dockerConnection.removeContainerListener((IDockerContainerListener)DockerContainerRefreshManager.getInstance());
        Assertions.assertThat((List)dockerConnection.getImageListeners()).hasSize(2);
        this.dockerImagesBotView.close();
        Assertions.assertThat((List)dockerConnection.getImageListeners()).hasSize(1);
    }

    @Test
    public void shouldNotRemoveListenersWhenNoSelectedConnectionBeforeClosingView() {
        this.dockerExplorerBotView.close();
        DockerClient client = MockDockerClientFactory.container(MockContainerFactory.name("angry_bar", new String[0]).status("Stopped").build()).build();
        DockerConnection dockerConnection = MockDockerConnectionFactory.from("Test", client).withDefaultTCPConnectionSettings();
        DockerConnectionManagerUtils.configureConnectionManager(new IDockerConnection[]{dockerConnection});
        dockerConnection.removeContainerListener((IDockerContainerListener)DockerContainerRefreshManager.getInstance());
        Assertions.assertThat((List)dockerConnection.getImageListeners()).hasSize(0);
        this.dockerImagesBotView.close();
        Assertions.assertThat((List)dockerConnection.getImageListeners()).hasSize(0);
    }

    @Test
    public void shouldOpenImageHierarchyView() {
        DockerClient client = MockDockerClientFactory.image(MockImageFactory.name("angry_bar", new String[0]).build()).image(MockImageFactory.name("gentle_foo", new String[0]).build()).build();
        DockerConnection dockerConnection = MockDockerConnectionFactory.from("Test", client).withDefaultTCPConnectionSettings();
        DockerConnectionManagerUtils.configureConnectionManager(new IDockerConnection[]{dockerConnection});
        SWTUtils.closeView(this.bot, "org.eclipse.linuxtools.docker.ui.dockerImageHierarchyView");
        this.selectImageInTable("angry_bar");
        SWTUtils.getContextMenu((AbstractSWTBot<? extends Control>)this.dockerImagesBotView.bot().table(), "Open Image Hierarchy").click();
        SWTUtils.wait(1, TimeUnit.SECONDS);
        DockerImageHierarchyViewAssertions.assertThat((DockerImageHierarchyView)SWTUtils.getView(this.bot, "org.eclipse.linuxtools.docker.ui.dockerImageHierarchyView")).isNotNull();
    }

    @Test
    public void shouldShowSelectedImageInPropertiesView() {
        DockerClient client = MockDockerClientFactory.image(MockImageFactory.name("angry_bar", new String[0]).build()).build();
        DockerConnection dockerConnection = MockDockerConnectionFactory.from("Test", client).withDefaultTCPConnectionSettings();
        DockerConnectionManagerUtils.configureConnectionManager(new IDockerConnection[]{dockerConnection});
        PropertySheet propertySheet = SWTUtils.syncExec(() -> (PropertySheet)SWTUtils.getView(this.bot, "org.eclipse.ui.views.PropertySheet", true));
        this.dockerImagesView.setFocus();
        this.selectImageInTable("angry_bar");
        Assertions.assertThat((Object)propertySheet.getCurrentPage()).isInstanceOf(TabbedPropertySheetPage.class);
        TabbedPropertySheetPage currentPage = (TabbedPropertySheetPage)propertySheet.getCurrentPage();
        ((TabDescriptorAssertions)TabDescriptorAssertions.assertThat(currentPage.getSelectedTab()).isNotNull()).hasId("org.eclipse.linuxtools.docker.ui.properties.image.info");
    }

    @Test
    public void verifyBuildAndPullActionEnablement() {
        DockerClient client = MockDockerClientFactory.image(MockImageFactory.name("angry_bar", new String[0]).build()).build();
        DockerConnection dockerConnection = MockDockerConnectionFactory.from("Test", client).withDefaultTCPConnectionSettings();
        DockerConnectionManagerUtils.configureConnectionManager(new IDockerConnection[]{dockerConnection});
        SWTUtils.syncExec(() -> SWTUtils.getView(this.bot, "org.eclipse.ui.views.PropertySheet", true));
        this.dockerImagesView.setFocus();
        this.selectImageInTable("angry_bar");
        List buttons = this.dockerImagesBotView.getToolbarButtons();
        for (SWTBotToolbarButton button : buttons) {
            if (button.getText().equals("Build Image")) {
                Assertions.assertThat((boolean)button.isEnabled());
                continue;
            }
            if (!button.getText().equals("Pull...")) continue;
            Assertions.assertThat((boolean)button.isEnabled());
        }
        this.unselectImages();
        buttons = this.dockerImagesBotView.getToolbarButtons();
        for (SWTBotToolbarButton button : buttons) {
            if (button.getText().equals("Build Image")) {
                Assertions.assertThat((boolean)button.isEnabled());
                continue;
            }
            if (!button.getText().equals("Pull...")) continue;
            Assertions.assertThat((boolean)button.isEnabled());
        }
        this.unselectConnections();
        buttons = this.dockerImagesBotView.getToolbarButtons();
        for (SWTBotToolbarButton button : buttons) {
            if (button.getText().equals("Build Image")) {
                Assertions.assertThat((!button.isEnabled() ? 1 : 0) != 0);
                continue;
            }
            if (!button.getText().equals("Pull...")) continue;
            Assertions.assertThat((!button.isEnabled() ? 1 : 0) != 0);
        }
    }
}

