/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.wizards;

import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.linuxtools.docker.core.IDockerConnection;
import org.eclipse.linuxtools.docker.core.IRegistryAccount;
import org.eclipse.linuxtools.internal.docker.core.DockerConnection;
import org.eclipse.linuxtools.internal.docker.core.RegistryAccountInfo;
import org.eclipse.linuxtools.internal.docker.core.RegistryAccountManager;
import org.eclipse.linuxtools.internal.docker.core.RegistryAccountStorageManager;
import org.eclipse.linuxtools.internal.docker.ui.testutils.MockDockerClientFactory;
import org.eclipse.linuxtools.internal.docker.ui.testutils.MockDockerConnectionFactory;
import org.eclipse.linuxtools.internal.docker.ui.testutils.MockImageFactory;
import org.eclipse.linuxtools.internal.docker.ui.testutils.MockRegistryAccountManagerFactory;
import org.eclipse.linuxtools.internal.docker.ui.testutils.swt.ClearConnectionManagerRule;
import org.eclipse.linuxtools.internal.docker.ui.testutils.swt.CloseShellRule;
import org.eclipse.linuxtools.internal.docker.ui.testutils.swt.CloseWelcomePageRule;
import org.eclipse.linuxtools.internal.docker.ui.testutils.swt.ComboAssertions;
import org.eclipse.linuxtools.internal.docker.ui.testutils.swt.DockerConnectionManagerUtils;
import org.eclipse.linuxtools.internal.docker.ui.testutils.swt.SWTUtils;
import org.eclipse.linuxtools.internal.docker.ui.views.DockerExplorerView;
import org.eclipse.linuxtools.internal.docker.ui.wizards.WizardMessages;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swtbot.eclipse.finder.SWTWorkbenchBot;
import org.eclipse.swtbot.eclipse.finder.widgets.SWTBotView;
import org.eclipse.swtbot.swt.finder.widgets.AbstractSWTBot;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTree;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTreeItem;
import org.junit.After;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.mandas.docker.client.DockerClient;
import org.mandas.docker.client.ProgressHandler;
import org.mandas.docker.client.exceptions.DockerException;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class ImagePushSWTBotTests {
    private SWTWorkbenchBot bot = new SWTWorkbenchBot();
    private DockerExplorerView dockerExplorerView;
    private SWTBotView dockerExplorerViewBot;
    @ClassRule
    public static CloseWelcomePageRule closeWelcomePage = new CloseWelcomePageRule("org.eclipse.linuxtools.docker.ui.perspective");
    @Rule
    public ClearConnectionManagerRule clearConnectionManager = new ClearConnectionManagerRule();
    @Rule
    public CloseShellRule closeShell = new CloseShellRule(IDialogConstants.CANCEL_LABEL);
    private RegistryAccountStorageManager defaultRegistryAccountStorageManager;
    private DockerClient client;

    @Before
    public void lookupDockerExplorerView() {
        this.dockerExplorerViewBot = SWTUtils.getSWTBotView(this.bot, "org.eclipse.linuxtools.docker.ui.dockerExplorerView");
        this.dockerExplorerView = (DockerExplorerView)this.dockerExplorerViewBot.getViewReference().getView(true);
        this.dockerExplorerViewBot.show();
        this.dockerExplorerViewBot.setFocus();
        this.defaultRegistryAccountStorageManager = RegistryAccountManager.getInstance().getStorageManager();
    }

    @Before
    public void setupDockerClient() {
        this.client = MockDockerClientFactory.image(MockImageFactory.name("bar:latest", "foo/bar:latest").build()).build();
        DockerConnection dockerConnection = MockDockerConnectionFactory.from("Test", this.client).withDefaultTCPConnectionSettings();
        DockerConnectionManagerUtils.configureConnectionManager(new IDockerConnection[]{dockerConnection});
    }

    @After
    public void restoreRegistryAccountStorageManager() {
        RegistryAccountManager.getInstance().setStorageManager(this.defaultRegistryAccountStorageManager);
    }

    private void openPushWizard() {
        SWTUtils.syncExec(() -> this.dockerExplorerView.getCommonViewer().expandAll());
        SWTBotTreeItem imageTreeItem = SWTUtils.getTreeItem(this.dockerExplorerViewBot, "Test", "Images", "foo/bar");
        SWTBotTree dockerExplorerViewTreeBot = this.dockerExplorerViewBot.bot().tree();
        dockerExplorerViewTreeBot.select(new SWTBotTreeItem[]{imageTreeItem});
        SWTUtils.getContextMenu((AbstractSWTBot<? extends Control>)dockerExplorerViewTreeBot, "Push...").click();
    }

    @Test
    public void shouldPrefillWizardWithSelectedImageTag() {
        MockRegistryAccountManagerFactory.registryAccount((IRegistryAccount)new RegistryAccountInfo("http://foo.com", "foo", null, "secret".toCharArray(), false)).build();
        this.openPushWizard();
        ComboAssertions.assertThat(this.bot.comboBox(0)).itemSelected("https://index.docker.io");
        ComboAssertions.assertThat(this.bot.comboBox(1)).itemSelected("foo/bar:latest");
    }

    @Test
    public void shouldPushImage() throws DockerException, InterruptedException {
        MockRegistryAccountManagerFactory.registryAccount((IRegistryAccount)new RegistryAccountInfo("http://foo.com", null, null, null, false)).build();
        this.openPushWizard();
        this.bot.comboBox(0).setSelection(1);
        this.bot.button("Finish").click();
        SWTUtils.wait(1, TimeUnit.SECONDS);
        ((DockerClient)Mockito.verify((Object)this.client, (VerificationMode)Mockito.times((int)1))).tag("foo/bar:latest", "foo.com/foo/bar:latest", false);
        ((DockerClient)Mockito.verify((Object)this.client, (VerificationMode)Mockito.times((int)1))).push((String)ArgumentMatchers.eq((Object)"foo.com/foo/bar:latest"), (ProgressHandler)ArgumentMatchers.any(ProgressHandler.class));
        ((DockerClient)Mockito.verify((Object)this.client, (VerificationMode)Mockito.times((int)1))).removeImage("foo.com/foo/bar:latest", false, false);
    }

    @Test
    public void shouldPushImageToDockerHub() throws DockerException, InterruptedException {
        this.openPushWizard();
        this.bot.button("Finish").click();
        SWTUtils.wait(1, TimeUnit.SECONDS);
        ((DockerClient)Mockito.verify((Object)this.client, (VerificationMode)Mockito.never())).tag(ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), ArgumentMatchers.anyBoolean());
        ((DockerClient)Mockito.verify((Object)this.client, (VerificationMode)Mockito.times((int)1))).push((String)ArgumentMatchers.eq((Object)"foo/bar:latest"), (ProgressHandler)ArgumentMatchers.any(ProgressHandler.class));
        ((DockerClient)Mockito.verify((Object)this.client, (VerificationMode)Mockito.never())).removeImage(ArgumentMatchers.anyString(), ArgumentMatchers.anyBoolean(), ArgumentMatchers.anyBoolean());
    }

    @Test
    public void shouldPushImageToLocalRegistry() throws DockerException, InterruptedException {
        MockRegistryAccountManagerFactory.registryAccount((IRegistryAccount)new RegistryAccountInfo("http://localhost:5000", null, null, null, false)).build();
        this.openPushWizard();
        this.bot.comboBox(0).setSelection(1);
        this.bot.button("Finish").click();
        SWTUtils.wait(1, TimeUnit.SECONDS);
        ((DockerClient)Mockito.verify((Object)this.client, (VerificationMode)Mockito.times((int)1))).tag("foo/bar:latest", "localhost:5000/foo/bar:latest", false);
        ((DockerClient)Mockito.verify((Object)this.client, (VerificationMode)Mockito.times((int)1))).push((String)ArgumentMatchers.eq((Object)"localhost:5000/foo/bar:latest"), (ProgressHandler)ArgumentMatchers.any(ProgressHandler.class));
        ((DockerClient)Mockito.verify((Object)this.client, (VerificationMode)Mockito.times((int)1))).removeImage("localhost:5000/foo/bar:latest", false, false);
    }

    @Test
    public void shouldPushImageWithForceTagging() throws DockerException, InterruptedException {
        MockRegistryAccountManagerFactory.registryAccount((IRegistryAccount)new RegistryAccountInfo("http://foo.com", "foo", null, "secret".toCharArray(), false)).build();
        this.openPushWizard();
        this.bot.checkBox(0).select();
        this.bot.comboBox(0).setSelection(1);
        this.bot.button("Finish").click();
        SWTUtils.wait(1, TimeUnit.SECONDS);
        ((DockerClient)Mockito.verify((Object)this.client, (VerificationMode)Mockito.times((int)1))).tag("foo/bar:latest", "foo.com/foo/bar:latest", true);
        ((DockerClient)Mockito.verify((Object)this.client, (VerificationMode)Mockito.times((int)1))).push((String)ArgumentMatchers.any(), (ProgressHandler)ArgumentMatchers.any(ProgressHandler.class));
        ((DockerClient)Mockito.verify((Object)this.client, (VerificationMode)Mockito.times((int)1))).removeImage("foo.com/foo/bar:latest", false, false);
    }

    @Test
    public void shouldPushImageAndKeepTaggedImage() throws DockerException, InterruptedException {
        MockRegistryAccountManagerFactory.registryAccount((IRegistryAccount)new RegistryAccountInfo("http://foo.com", "foo", null, "secret".toCharArray(), false)).build();
        this.openPushWizard();
        this.bot.comboBox(0).setSelection(1);
        this.bot.checkBox(1).select();
        this.bot.button("Finish").click();
        SWTUtils.wait(1, TimeUnit.SECONDS);
        ((DockerClient)Mockito.verify((Object)this.client, (VerificationMode)Mockito.times((int)1))).tag("foo/bar:latest", "foo.com/foo/bar:latest", false);
        ((DockerClient)Mockito.verify((Object)this.client, (VerificationMode)Mockito.times((int)1))).push((String)ArgumentMatchers.any(), (ProgressHandler)ArgumentMatchers.any(ProgressHandler.class));
        ((DockerClient)Mockito.verify((Object)this.client, (VerificationMode)Mockito.never())).removeImage(ArgumentMatchers.anyString(), ArgumentMatchers.anyBoolean(), ArgumentMatchers.anyBoolean());
    }

    @Test
    public void shouldPushImageWithNewTagToDockerHub() throws DockerException, InterruptedException {
        this.openPushWizard();
        this.bot.comboBox(1).setText("another/name");
        this.bot.button("Finish").click();
        SWTUtils.wait(1, TimeUnit.SECONDS);
        ((DockerClient)Mockito.verify((Object)this.client, (VerificationMode)Mockito.times((int)1))).tag("foo/bar:latest", "another/name:latest", false);
        ((DockerClient)Mockito.verify((Object)this.client, (VerificationMode)Mockito.times((int)1))).push((String)ArgumentMatchers.any(), (ProgressHandler)ArgumentMatchers.any(ProgressHandler.class));
        ((DockerClient)Mockito.verify((Object)this.client, (VerificationMode)Mockito.times((int)1))).removeImage(ArgumentMatchers.anyString(), ArgumentMatchers.anyBoolean(), ArgumentMatchers.anyBoolean());
    }

    @Test
    public void shouldPushImageWithNewTagToAnotherRepo() throws DockerException, InterruptedException {
        MockRegistryAccountManagerFactory.registryAccount((IRegistryAccount)new RegistryAccountInfo("http://foo.com", "foo", null, "secret".toCharArray(), false)).build();
        this.openPushWizard();
        this.bot.comboBox(0).setSelection(1);
        this.bot.comboBox(1).setText("another/name");
        this.bot.button("Finish").click();
        SWTUtils.wait(1, TimeUnit.SECONDS);
        ((DockerClient)Mockito.verify((Object)this.client, (VerificationMode)Mockito.times((int)1))).tag("foo/bar:latest", "foo.com/another/name:latest", false);
        ((DockerClient)Mockito.verify((Object)this.client, (VerificationMode)Mockito.times((int)1))).push((String)ArgumentMatchers.any(), (ProgressHandler)ArgumentMatchers.any(ProgressHandler.class));
        ((DockerClient)Mockito.verify((Object)this.client, (VerificationMode)Mockito.times((int)1))).removeImage(ArgumentMatchers.anyString(), ArgumentMatchers.anyBoolean(), ArgumentMatchers.anyBoolean());
    }

    @Test
    public void shouldAddRegistry() {
        String registryAddress = "https://foo.com";
        this.openPushWizard();
        this.bot.link(0).click(WizardMessages.getString((String)"ImagePullPushPage.add.label"));
        this.bot.text(0).setText("https://foo.com");
        this.bot.button("OK").click();
        SWTUtils.wait(1, TimeUnit.SECONDS);
        Assertions.assertThat((String)this.bot.comboBox(0).getText()).isEqualTo("https://foo.com");
    }
}

