/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.wizards;

import java.io.File;
import java.io.IOException;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.linuxtools.docker.core.IDockerConnection;
import org.eclipse.linuxtools.internal.docker.core.DockerConnection;
import org.eclipse.linuxtools.internal.docker.core.SystemUtils;
import org.eclipse.linuxtools.internal.docker.ui.testutils.MockDockerClientFactory;
import org.eclipse.linuxtools.internal.docker.ui.testutils.MockDockerConnectionFactory;
import org.eclipse.linuxtools.internal.docker.ui.testutils.MockDockerConnectionSettingsFinder;
import org.eclipse.linuxtools.internal.docker.ui.testutils.swt.ButtonAssertions;
import org.eclipse.linuxtools.internal.docker.ui.testutils.swt.CheckBoxAssertions;
import org.eclipse.linuxtools.internal.docker.ui.testutils.swt.CloseShellRule;
import org.eclipse.linuxtools.internal.docker.ui.testutils.swt.CloseWelcomePageRule;
import org.eclipse.linuxtools.internal.docker.ui.testutils.swt.DockerConnectionManagerUtils;
import org.eclipse.linuxtools.internal.docker.ui.testutils.swt.RadioAssertion;
import org.eclipse.linuxtools.internal.docker.ui.testutils.swt.SWTBotTreeItemAssertions;
import org.eclipse.linuxtools.internal.docker.ui.testutils.swt.SWTUtils;
import org.eclipse.linuxtools.internal.docker.ui.testutils.swt.TextAssertions;
import org.eclipse.linuxtools.internal.docker.ui.wizards.WizardMessages;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swtbot.eclipse.finder.SWTWorkbenchBot;
import org.eclipse.swtbot.eclipse.finder.widgets.SWTBotView;
import org.eclipse.swtbot.swt.finder.junit.SWTBotJunit4ClassRunner;
import org.eclipse.swtbot.swt.finder.waits.Conditions;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotToolbarButton;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.PlatformUI;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mandas.docker.client.DockerClient;

@RunWith(value=SWTBotJunit4ClassRunner.class)
public class NewDockerConnectionSWTBotTest {
    private SWTWorkbenchBot bot = new SWTWorkbenchBot();
    private SWTBotToolbarButton addConnectionButton;
    private SWTBotView dockerExplorerViewBot;
    @ClassRule
    public static CloseWelcomePageRule closeWelcomePage = new CloseWelcomePageRule("org.eclipse.linuxtools.docker.ui.perspective");
    @Rule
    public CloseShellRule closeShell = new CloseShellRule(IDialogConstants.CANCEL_LABEL);

    @Before
    public void lookupDockerExplorerView() throws Exception {
        SWTUtils.asyncExec(() -> {
            try {
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.eclipse.linuxtools.docker.ui.dockerExplorerView");
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.fail((String)("Failed to open Docker Explorer view: " + e.getMessage()));
            }
        });
        this.dockerExplorerViewBot = this.bot.viewById("org.eclipse.linuxtools.docker.ui.dockerExplorerView");
        this.dockerExplorerViewBot.show();
        this.bot.views().stream().filter(v -> ((IViewReference)v.getReference()).getId().equals("org.eclipse.linuxtools.docker.ui.dockerContainersView") || ((IViewReference)v.getReference()).getId().equals("org.eclipse.linuxtools.docker.ui.dockerImagesView")).forEach(v -> v.close());
        this.dockerExplorerViewBot.setFocus();
        this.addConnectionButton = this.dockerExplorerViewBot.toolbarButton("&Add Connection");
    }

    @Before
    public void clearClipboards() {
        Display.getDefault().syncExec(() -> {
            Clipboard clip = new Clipboard(Display.getCurrent());
            clip.clearContents(1);
            clip.clearContents(2);
        });
    }

    private IDockerConnection configureUnixSocketConnection(String connectionName, String pathToSocket) {
        DockerClient client = MockDockerClientFactory.build();
        DockerConnection dockerConnection = MockDockerConnectionFactory.from(connectionName, client).withUnixSocketConnectionSettings(pathToSocket);
        DockerConnectionManagerUtils.configureConnectionManager(new IDockerConnection[]{dockerConnection});
        return dockerConnection;
    }

    private IDockerConnection configureTCPConnection(String connectionName, String host) {
        DockerClient client = MockDockerClientFactory.build();
        DockerConnection dockerConnection = MockDockerConnectionFactory.from(connectionName, client).withTCPConnectionSettings(host, null);
        DockerConnectionManagerUtils.configureConnectionManager(new IDockerConnection[]{dockerConnection});
        return dockerConnection;
    }

    @Test
    public void shouldShowCustomUnixSocketSettingsWhenNoConnectionAvailable() {
        MockDockerConnectionSettingsFinder.noDockerConnectionAvailable();
        this.addConnectionButton.click();
        ((TextAssertions)((Object)TextAssertions.assertThat(this.bot.text(0)).isEnabled())).isEmpty();
        ((CheckBoxAssertions)((Object)CheckBoxAssertions.assertThat(this.bot.checkBox(0)).isEnabled())).isChecked();
        ((RadioAssertion)((Object)RadioAssertion.assertThat(this.bot.radio(0)).isEnabled())).isSelected();
        ((TextAssertions)((Object)TextAssertions.assertThat(this.bot.text(1)).isEnabled())).isEmpty();
        ((RadioAssertion)((Object)RadioAssertion.assertThat(this.bot.radio(1)).isEnabled())).isNotSelected();
        ((TextAssertions)((Object)TextAssertions.assertThat(this.bot.text(2)).isNotEnabled())).isEmpty();
        ((CheckBoxAssertions)((Object)CheckBoxAssertions.assertThat(this.bot.checkBox(1)).isNotEnabled())).isNotChecked();
        ((TextAssertions)((Object)TextAssertions.assertThat(this.bot.text(3)).isNotEnabled())).isEmpty();
    }

    @Test
    public void shouldShowDefaultUnixSocketConnectionSettingsWithValidConnectionAvailable() {
        MockDockerConnectionSettingsFinder.validUnixSocketConnectionAvailable();
        this.addConnectionButton.click();
        ((TextAssertions)((Object)TextAssertions.assertThat(this.bot.text(0)).isEnabled())).textEquals("mock");
        ((CheckBoxAssertions)((Object)CheckBoxAssertions.assertThat(this.bot.checkBox(0)).isEnabled())).isNotChecked();
        ((RadioAssertion)((Object)RadioAssertion.assertThat(this.bot.radio(0)).isNotEnabled())).isSelected();
        ((TextAssertions)((Object)TextAssertions.assertThat(this.bot.text(1)).isNotEnabled())).textEquals("unix:///var/run/docker.sock");
        ((RadioAssertion)((Object)RadioAssertion.assertThat(this.bot.radio(1)).isNotEnabled())).isNotSelected();
        ((TextAssertions)((Object)TextAssertions.assertThat(this.bot.text(2)).isNotEnabled())).isEmpty();
        ((CheckBoxAssertions)((Object)CheckBoxAssertions.assertThat(this.bot.checkBox(1)).isNotEnabled())).isNotChecked();
        ((TextAssertions)((Object)TextAssertions.assertThat(this.bot.text(3)).isNotEnabled())).isEmpty();
    }

    @Test
    public void shouldShowDefaultTCPSettingsWithValidConnectionAvailable() {
        MockDockerConnectionSettingsFinder.validTCPConnectionAvailable();
        this.addConnectionButton.click();
        this.bot.waitUntil(Conditions.shellIsActive((String)WizardMessages.getString((String)"NewDockerConnection.title")));
        ((TextAssertions)((Object)TextAssertions.assertThat(this.bot.text(0)).isEnabled())).textEquals("mock");
        ((CheckBoxAssertions)((Object)CheckBoxAssertions.assertThat(this.bot.checkBox(0)).isEnabled())).isNotChecked();
        ((RadioAssertion)((Object)RadioAssertion.assertThat(this.bot.radio(0)).isNotEnabled())).isNotSelected();
        ((TextAssertions)((Object)TextAssertions.assertThat(this.bot.text(1)).isNotEnabled())).isEmpty();
        ((RadioAssertion)((Object)RadioAssertion.assertThat(this.bot.radio(1)).isNotEnabled())).isSelected();
        ((TextAssertions)((Object)TextAssertions.assertThat(this.bot.text(2)).isNotEnabled())).textEquals("https://1.2.3.4:1234");
        ((CheckBoxAssertions)((Object)CheckBoxAssertions.assertThat(this.bot.checkBox(1)).isNotEnabled())).isChecked();
        ((TextAssertions)((Object)TextAssertions.assertThat(this.bot.text(3)).isNotEnabled())).textEquals("/path/to/certs");
    }

    @Test
    public void shouldAddConnectionToDockerExplorerView() throws IOException {
        File dockerSocketTmpFile = File.createTempFile("docker", ".sock");
        MockDockerConnectionSettingsFinder.validUnixSocketConnectionAvailable("Mock", "unix://" + dockerSocketTmpFile.getAbsolutePath());
        this.addConnectionButton.click();
        this.bot.waitUntil(Conditions.shellIsActive((String)WizardMessages.getString((String)"NewDockerConnection.title")));
        this.bot.button("Finish").click();
        SWTBotTreeItemAssertions.assertThat(SWTUtils.getTreeItem(this.dockerExplorerViewBot.bot().tree(), "Mock")).isNotNull();
    }

    @Test
    public void shouldNotAllowNewConnectionWithDifferentNameAndSameUnixSocketSettings() throws IOException {
        String dockerSocketTmpPath = File.createTempFile("docker", ".sock").getAbsolutePath();
        MockDockerConnectionSettingsFinder.validUnixSocketConnectionAvailable("Mock", "unix://" + dockerSocketTmpPath);
        this.configureUnixSocketConnection("Mock", dockerSocketTmpPath);
        this.addConnectionButton.click();
        this.bot.waitUntil(Conditions.shellIsActive((String)WizardMessages.getString((String)"NewDockerConnection.title")));
        this.bot.text(0).setText("foo");
        ButtonAssertions.assertThat(this.bot.button("Finish")).isNotEnabled();
    }

    @Test
    public void shouldNotAllowNewConnectionWithDifferentNameAndSameTCPSettings() {
        MockDockerConnectionSettingsFinder.validTCPConnectionAvailable("Mock", "https://foo:1234", null);
        this.configureTCPConnection("Mock", "https://foo:1234");
        this.addConnectionButton.click();
        this.bot.waitUntil(Conditions.shellIsActive((String)WizardMessages.getString((String)"NewDockerConnection.title")));
        this.bot.text(0).setText("foo");
        ButtonAssertions.assertThat(this.bot.button("Finish")).isNotEnabled();
    }

    @Test
    public void shouldAllowNewConnectionWithDifferentNameAndUnixSettings() throws IOException {
        String dockerSocketTmpPath = File.createTempFile("docker", ".sock").getAbsolutePath();
        this.configureUnixSocketConnection("Bar", dockerSocketTmpPath);
        MockDockerConnectionSettingsFinder.validUnixSocketConnectionAvailable("Mock", "unix://" + dockerSocketTmpPath);
        String otherDockerSocketTmpPath = File.createTempFile("docker", ".sock").getAbsolutePath();
        this.addConnectionButton.click();
        this.bot.waitUntil(Conditions.shellIsActive((String)WizardMessages.getString((String)"NewDockerConnection.title")));
        this.bot.text(0).setText("foo");
        this.bot.checkBox(0).select();
        this.bot.text(1).setText(otherDockerSocketTmpPath);
        ButtonAssertions.assertThat(this.bot.button("Finish")).isEnabled();
    }

    @Test
    public void shouldAllowNewConnectionWithDifferentNameAndTCPSettings() {
        MockDockerConnectionSettingsFinder.validTCPConnectionAvailable("Mock", "https://foo:1234", null);
        this.configureTCPConnection("Mock", "https://foo");
        this.addConnectionButton.click();
        this.bot.waitUntil(Conditions.shellIsActive((String)WizardMessages.getString((String)"NewDockerConnection.title")));
        this.bot.text(0).setText("foo");
        this.bot.checkBox(0).select();
        this.bot.text(2).setText("https://bar:1234");
        ButtonAssertions.assertThat(this.bot.button("Finish")).isEnabled();
    }

    @Test
    public void shouldPopulateConnectionWithClipboard() {
        this.verifyPopulateConnectionWithClipboard(1);
    }

    @Test
    public void shouldPopulateConnectionWithSelectionClipboard() {
        Assume.assumeTrue((String)"This test only runs on Linux", (boolean)SystemUtils.isLinux());
        this.verifyPopulateConnectionWithClipboard(2);
    }

    private void verifyPopulateConnectionWithClipboard(int clipboardType) {
        String[] connectionData = new String[]{"DOCKER_HOST=https://1.2.3.4:1234 DOCKER_CERT_PATH=/path/to/certs DOCKER_TLS_VERIFY=1"};
        Display.getDefault().syncExec(() -> {
            Clipboard clip = new Clipboard(Display.getCurrent());
            clip.setContents((Object[])connectionData, new Transfer[]{TextTransfer.getInstance()}, clipboardType);
        });
        this.addConnectionButton.click();
        ((TextAssertions)((Object)TextAssertions.assertThat(this.bot.text(0)).isEnabled())).isEmpty();
        ((CheckBoxAssertions)((Object)CheckBoxAssertions.assertThat(this.bot.checkBox(0)).isEnabled())).isChecked();
        ((RadioAssertion)((Object)RadioAssertion.assertThat(this.bot.radio(0)).isEnabled())).isNotSelected();
        ((TextAssertions)((Object)TextAssertions.assertThat(this.bot.text(1)).isNotEnabled())).isEmpty();
        ((RadioAssertion)((Object)RadioAssertion.assertThat(this.bot.radio(1)).isEnabled())).isSelected();
        ((TextAssertions)((Object)TextAssertions.assertThat(this.bot.text(2)).isEnabled())).textEquals("https://1.2.3.4:1234");
        ((CheckBoxAssertions)((Object)CheckBoxAssertions.assertThat(this.bot.checkBox(1)).isEnabled())).isChecked();
        ((TextAssertions)((Object)TextAssertions.assertThat(this.bot.text(3)).isEnabled())).textEquals("/path/to/certs");
        this.bot.button("Cancel").click();
    }
}

