/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.docker.integration.tests.container;

import org.eclipse.linuxtools.docker.core.IDockerConnection;
import org.eclipse.linuxtools.docker.integration.tests.image.AbstractImageBotTest;
import org.eclipse.linuxtools.docker.integration.tests.mock.MockDockerConnectionManager;
import org.eclipse.linuxtools.docker.reddeer.condition.ContainerIsDeployedCondition;
import org.eclipse.linuxtools.docker.reddeer.core.ui.wizards.ImageRunSelectionPage;
import org.eclipse.linuxtools.docker.reddeer.ui.DockerImagesTab;
import org.eclipse.linuxtools.internal.docker.core.DockerConnection;
import org.eclipse.linuxtools.internal.docker.ui.testutils.MockContainerFactory;
import org.eclipse.linuxtools.internal.docker.ui.testutils.MockContainerInfoFactory;
import org.eclipse.linuxtools.internal.docker.ui.testutils.MockDockerClientFactory;
import org.eclipse.linuxtools.internal.docker.ui.testutils.MockDockerConnectionFactory;
import org.eclipse.linuxtools.internal.docker.ui.testutils.MockImageFactory;
import org.eclipse.reddeer.common.condition.WaitCondition;
import org.eclipse.reddeer.common.wait.WaitUntil;
import org.eclipse.reddeer.common.wait.WaitWhile;
import org.eclipse.reddeer.core.reference.ReferencedComposite;
import org.eclipse.reddeer.eclipse.ui.views.properties.PropertySheet;
import org.eclipse.reddeer.workbench.core.condition.JobIsRunning;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mandas.docker.client.DockerClient;
import org.mandas.docker.client.exceptions.DockerException;
import org.mandas.docker.client.messages.Container;
import org.mandas.docker.client.messages.ContainerInfo;

public class UnconfinedTest
extends AbstractImageBotTest {
    private static final String IMAGE_NAME = "busybox";
    private static final String IMAGE_TAG = "latest";
    private static final String CONTAINER_NAME = "test_run_busybox";

    @Before
    public void before() throws DockerException, InterruptedException {
        UnconfinedTest.deleteAllConnections();
        this.getConnection();
        this.pullImage(IMAGE_NAME, IMAGE_TAG);
    }

    @Test
    public void testUnconfined() {
        DockerImagesTab imagesTab = this.openDockerImagesTab();
        imagesTab.runImage("busybox:latest");
        ImageRunSelectionPage firstPage = new ImageRunSelectionPage((ReferencedComposite)imagesTab);
        firstPage.setContainerName(CONTAINER_NAME);
        firstPage.setAllocatePseudoTTY();
        firstPage.setKeepSTDINOpen();
        firstPage.setUnconfined();
        firstPage.finish();
        if (this.mockitoIsUsed()) {
            this.runUnconfinedContainer();
            this.getConnection().refresh();
            new WaitUntil((WaitCondition)new ContainerIsDeployedCondition(CONTAINER_NAME, this.getConnection()));
        }
        new WaitWhile((WaitCondition)new JobIsRunning());
        PropertySheet propertiesView = this.openPropertiesTabForContainer("Inspect", CONTAINER_NAME);
        String securityProp = propertiesView.getProperty(new String[]{"HostConfig", "SecurityOpt", ""}).getPropertyValue();
        Assert.assertTrue((String)"Container is not running in seccomp:unconfined mode!", (boolean)securityProp.equals("seccomp:unconfined"));
    }

    @Override
    @After
    public void after() {
        this.deleteContainerIfExists(CONTAINER_NAME);
    }

    private void runUnconfinedContainer() {
        DockerClient client = MockDockerClientFactory.container((Container)MockContainerFactory.name((String)CONTAINER_NAME, (String[])new String[0]).status("Stopped").build(), (ContainerInfo)MockContainerInfoFactory.link((String)"busybox:latest").securityOpt("seccomp:unconfined").id("TestTestTestTestTest").ipAddress("127.0.0.1").build()).image(MockImageFactory.id((String)"987654321abcde").name("fnichol/uhttpd:latest", new String[0]).build()).build();
        DockerConnection dockerConnection = MockDockerConnectionFactory.from((String)"default", (DockerClient)client).withDefaultTCPConnectionSettings();
        MockDockerConnectionManager.configureConnectionManager(new IDockerConnection[]{dockerConnection});
    }
}

