/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.docker.integration.tests.ui;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.eclipse.linuxtools.docker.core.DockerException;
import org.eclipse.linuxtools.docker.integration.tests.StringUtils;
import org.eclipse.linuxtools.docker.integration.tests.image.AbstractImageBotTest;
import org.eclipse.linuxtools.docker.integration.tests.mock.MockUtils;
import org.eclipse.linuxtools.docker.reddeer.preferences.DockerComposePreferencePage;
import org.eclipse.linuxtools.docker.reddeer.ui.DockerImagesTab;
import org.eclipse.linuxtools.docker.reddeer.utils.BrowserContentsCheck;
import org.eclipse.linuxtools.internal.docker.core.DockerCompose;
import org.eclipse.linuxtools.internal.docker.core.ProcessLauncher;
import org.eclipse.linuxtools.internal.docker.ui.testutils.CustomMatchers;
import org.eclipse.reddeer.common.condition.WaitCondition;
import org.eclipse.reddeer.common.matcher.RegexMatcher;
import org.eclipse.reddeer.common.wait.TimePeriod;
import org.eclipse.reddeer.common.wait.WaitWhile;
import org.eclipse.reddeer.core.exception.CoreLayerException;
import org.eclipse.reddeer.core.matcher.WithTextMatcher;
import org.eclipse.reddeer.core.reference.ReferencedComposite;
import org.eclipse.reddeer.eclipse.condition.ConsoleHasNoChange;
import org.eclipse.reddeer.eclipse.jdt.ui.packageview.PackageExplorerPart;
import org.eclipse.reddeer.eclipse.ui.browser.WebBrowserView;
import org.eclipse.reddeer.jface.preference.PreferencePage;
import org.eclipse.reddeer.swt.impl.button.FinishButton;
import org.eclipse.reddeer.swt.impl.button.OkButton;
import org.eclipse.reddeer.swt.impl.button.PushButton;
import org.eclipse.reddeer.swt.impl.combo.LabeledCombo;
import org.eclipse.reddeer.swt.impl.menu.ContextMenuItem;
import org.eclipse.reddeer.swt.impl.menu.ShellMenu;
import org.eclipse.reddeer.swt.impl.shell.DefaultShell;
import org.eclipse.reddeer.workbench.core.condition.JobIsRunning;
import org.eclipse.reddeer.workbench.ui.dialogs.WorkbenchPreferenceDialog;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;

public class ComposeTest
extends AbstractImageBotTest {
    private static final String FILE_DOCKER_COMPOSE = "docker-compose.yml";
    private static final String SYSPROP_DOCKER_COMPOSE_PATH = "dockerComposePath";
    private static final String PATH_TEST_COMPOSE = "resources/test-compose";
    private static final String PROJECT_TEST_COMPOSE = "test-compose";
    private static final String IMAGE_NAME = "test_compose";
    private static final String URL = "http://0.0.0.0:5000/";
    private String dockerComposePath = System.getProperty("dockerComposePath");
    private CountDownLatch latch;

    @Before
    public void before() throws DockerException, InterruptedException {
        if (!this.mockitoIsUsed()) {
            Assume.assumeTrue((!StringUtils.isBlank(this.dockerComposePath) ? 1 : 0) != 0);
            Assert.assertTrue((String)"Please provide -DdockerComposePath=<path to docker-compose binary> in your launch parameters.", (!StringUtils.isBlank(this.dockerComposePath) ? 1 : 0) != 0);
        }
        ComposeTest.deleteAllConnections();
        if (this.mockitoIsUsed()) {
            MockUtils.createDockerMockConnection("default");
            ProcessLauncher mockProcessLauncher = (ProcessLauncher)Mockito.mock(ProcessLauncher.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
            DockerCompose.getInstance().setProcessLauncher(mockProcessLauncher);
            this.setupDockerComposeUpMockProcess(mockProcessLauncher);
            this.setupDockerComposeStopMockProcess(mockProcessLauncher);
            File dockerComposeTmpFile = null;
            String tempDir = System.getProperty("java.io.tmpdir");
            dockerComposeTmpFile = new File(tempDir, "docker-compose");
            this.dockerComposePath = tempDir;
        }
    }

    @Test
    public void testCompose() {
        WorkbenchPreferenceDialog dialog = new WorkbenchPreferenceDialog();
        DockerComposePreferencePage composePreference = new DockerComposePreferencePage((ReferencedComposite)dialog);
        dialog.open();
        dialog.select((PreferencePage)composePreference);
        composePreference.setPathToDockerCompose(this.dockerComposePath);
        composePreference.apply();
        new PushButton("Apply and Close").click();
        DockerImagesTab imagesTab = this.openDockerImagesTab();
        this.buildImage(IMAGE_NAME, PATH_TEST_COMPOSE, imagesTab);
        this.assertConsoleSuccess();
        this.importProject(PATH_TEST_COMPOSE);
        this.runDockerCompose(PROJECT_TEST_COMPOSE, FILE_DOCKER_COMPOSE);
        WebBrowserView browserView = new WebBrowserView();
        browserView.open();
        if (!this.mockitoIsUsed()) {
            browserView.openPageURL(URL);
            BrowserContentsCheck.checkBrowserForErrorPage((WebBrowserView)browserView, (String)URL);
        }
    }

    private void runDockerCompose(String project, String projectFile) {
        PackageExplorerPart pe = new PackageExplorerPart();
        pe.open();
        pe.getProject(project).getProjectItem(new String[]{projectFile}).select();
        ContextMenuItem contextMenu = new ContextMenuItem(new Matcher[]{new WithTextMatcher("Run As"), new RegexMatcher(".*Docker Compose")});
        contextMenu.select();
        new OkButton().click();
        try {
            new DefaultShell("Docker Compose");
            new PushButton("Apply and Close").click();
            Assert.fail((String)"Docker Compose has not been found! Is it installed and the path is correct?");
        }
        catch (CoreLayerException coreLayerException) {
            // empty catch block
        }
        new WaitWhile((WaitCondition)new JobIsRunning(), TimePeriod.VERY_LONG);
        new WaitWhile((WaitCondition)new ConsoleHasNoChange());
    }

    private void importProject(String path) {
        new ShellMenu().getItem(new String[]{"File", "Open Projects from File System..."}).select();
        new LabeledCombo("Import source:").setText(path);
        new FinishButton().click();
        new WaitWhile((WaitCondition)new JobIsRunning());
    }

    private void setupDockerComposeUpMockProcess(ProcessLauncher mockProcessLauncher) throws DockerException, InterruptedException {
        Process mockDockerComposeUpProcess = (Process)Mockito.mock(Process.class);
        Mockito.when((Object)mockDockerComposeUpProcess.getInputStream()).thenReturn((Object)new ByteArrayInputStream("up!\n".getBytes()));
        Mockito.when((Object)mockDockerComposeUpProcess.getErrorStream()).thenReturn((Object)new ByteArrayInputStream("".getBytes()));
        Mockito.when((Object)mockDockerComposeUpProcess.getOutputStream()).thenReturn((Object)new ByteArrayOutputStream());
        Mockito.when((Object)mockProcessLauncher.processBuilder(ArgumentMatchers.anyString(), (String)ArgumentMatchers.eq((Object)DockerCompose.getDockerComposeCommandName()), CustomMatchers.arrayContains((String)"up")).workingDir(ArgumentMatchers.anyString()).start()).thenReturn((Object)mockDockerComposeUpProcess);
        this.latch = new CountDownLatch(1);
        Mockito.when((Object)mockDockerComposeUpProcess.waitFor()).then(invocation -> {
            this.latch.await(5L, TimeUnit.SECONDS);
            return 0;
        });
    }

    private void setupDockerComposeStopMockProcess(ProcessLauncher mockProcessLauncher) throws DockerException, InterruptedException {
        Process mockDockerComposeStopProcess = (Process)Mockito.mock(Process.class);
        Mockito.when((Object)mockDockerComposeStopProcess.getInputStream()).thenReturn((Object)new ByteArrayInputStream("stop\n".getBytes()));
        Mockito.when((Object)mockDockerComposeStopProcess.getErrorStream()).thenReturn((Object)new ByteArrayInputStream("".getBytes()));
        Mockito.when((Object)mockDockerComposeStopProcess.getOutputStream()).thenReturn((Object)new ByteArrayOutputStream());
        Mockito.when((Object)mockProcessLauncher.processBuilder(ArgumentMatchers.anyString(), (String)ArgumentMatchers.eq((Object)DockerCompose.getDockerComposeCommandName()), CustomMatchers.arrayContains((String)"stop")).workingDir(ArgumentMatchers.anyString()).start()).thenReturn((Object)mockDockerComposeStopProcess);
        Mockito.when((Object)mockDockerComposeStopProcess.waitFor()).then(invocation -> {
            this.latch.countDown();
            return 0;
        });
    }

    @Override
    @After
    public void after() {
        this.deleteImageContainerAfter("testcompose_web_1", "testcompose_redis_1", "testcompose_web", IMAGE_NAME, "python:2.7", "redis");
        this.cleanUpWorkspace();
    }
}

