/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.testutils;

import org.eclipse.linuxtools.docker.core.DockerConnectionManager;
import org.eclipse.linuxtools.docker.core.IDockerConnectionSettings;
import org.eclipse.linuxtools.docker.core.IDockerConnectionSettingsFinder;
import org.eclipse.linuxtools.internal.docker.core.TCPConnectionSettings;
import org.eclipse.linuxtools.internal.docker.core.UnixSocketConnectionSettings;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class MockDockerConnectionSettingsFinder {
    public static void noDockerConnectionAvailable() {
        IDockerConnectionSettingsFinder noDockerDaemonAvailable = (IDockerConnectionSettingsFinder)Mockito.mock(IDockerConnectionSettingsFinder.class);
        DockerConnectionManager.getInstance().setConnectionSettingsFinder(noDockerDaemonAvailable);
    }

    public static void validUnixSocketConnectionAvailable() {
        MockDockerConnectionSettingsFinder.validUnixSocketConnectionAvailable("mock", "unix:///var/run/docker.sock");
    }

    public static void validUnixSocketConnectionAvailable(String connectionName, String unixSocketPath) {
        IDockerConnectionSettingsFinder validUnixSocketConnectionAvailable = (IDockerConnectionSettingsFinder)Mockito.mock(IDockerConnectionSettingsFinder.class);
        UnixSocketConnectionSettings unixSocketConnectionSettings = new UnixSocketConnectionSettings(unixSocketPath);
        unixSocketConnectionSettings.setSettingsResolved(true);
        Mockito.when((Object)validUnixSocketConnectionAvailable.findDefaultConnectionSettings()).thenReturn((Object)unixSocketConnectionSettings);
        Mockito.when((Object)validUnixSocketConnectionAvailable.resolveConnectionName((IDockerConnectionSettings)ArgumentMatchers.any(IDockerConnectionSettings.class))).thenReturn((Object)connectionName);
        DockerConnectionManager.getInstance().setConnectionSettingsFinder(validUnixSocketConnectionAvailable);
    }

    public static void validTCPConnectionAvailable() {
        MockDockerConnectionSettingsFinder.validTCPConnectionAvailable("mock", "tcp://1.2.3.4:1234", "/path/to/certs");
    }

    public static void validTCPConnectionAvailable(String connectionName, String host, String pathToCerts) {
        IDockerConnectionSettingsFinder validTCPSocketConnectionAvailable = (IDockerConnectionSettingsFinder)Mockito.mock(IDockerConnectionSettingsFinder.class);
        TCPConnectionSettings tcpConnectionSettings = new TCPConnectionSettings(host, pathToCerts);
        tcpConnectionSettings.setSettingsResolved(true);
        Mockito.when((Object)validTCPSocketConnectionAvailable.findDefaultConnectionSettings()).thenReturn((Object)tcpConnectionSettings);
        Mockito.when((Object)validTCPSocketConnectionAvailable.resolveConnectionName((IDockerConnectionSettings)ArgumentMatchers.any(IDockerConnectionSettings.class))).thenReturn((Object)connectionName);
        DockerConnectionManager.getInstance().setConnectionSettingsFinder(validTCPSocketConnectionAvailable);
    }
}

