/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.testutils.swt;

import java.util.stream.Stream;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.linuxtools.internal.docker.ui.launch.LaunchConfigurationUtils;
import org.junit.Assert;
import org.junit.rules.ExternalResource;

public class ClearLaunchConfigurationsRule
extends ExternalResource {
    private final String launchConfigTypeId;

    public ClearLaunchConfigurationsRule(String launchConfigTypeId) {
        this.launchConfigTypeId = launchConfigTypeId;
    }

    protected void before() throws Throwable {
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType launchConfigType = LaunchConfigurationUtils.getLaunchConfigType((String)this.launchConfigTypeId);
        Stream.of(manager.getLaunchConfigurations(launchConfigType)).forEach(launchConfig -> {
            try {
                launchConfig.delete();
            }
            catch (Exception e) {
                Assert.fail((String)("Failed to remove a launch configuration  '" + launchConfig.getName() + "' of type '" + this.launchConfigTypeId + "'"));
            }
        });
    }
}

