/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.testutils.swt;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.launchbar.ui.controls.internal.Activator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.junit.rules.ExternalResource;

public class CloseWelcomePageRule
extends ExternalResource {
    public static final String DOCKER_PERSPECTIVE_ID = "org.eclipse.linuxtools.docker.ui.perspective";
    public static final String JAVA_PERSPECTIVE_ID = "org.eclipse.jdt.ui.JavaPerspective";
    private final String defaultPerspectiveId;

    public CloseWelcomePageRule(String perspectiveId) {
        this.defaultPerspectiveId = perspectiveId;
    }

    protected void before() {
        Display.getDefault().syncExec(() -> {
            IWorkbench workbench = PlatformUI.getWorkbench();
            if (workbench.getIntroManager().getIntro() != null) {
                workbench.getIntroManager().closeIntro(workbench.getIntroManager().getIntro());
            }
            try {
                workbench.showPerspective(this.defaultPerspectiveId, workbench.getActiveWorkbenchWindow());
            }
            catch (WorkbenchException e) {
                e.printStackTrace();
            }
        });
        String PREF_ENABLE_LAUNCHBAR = "enableLaunchBar";
        String PREF_ENABLE_TARGETSELECTOR = "enableTargetSelector";
        String PREF_ENABLE_BUILDBUTTON = "enableBuildButton";
        Display.getDefault().asyncExec(() -> {
            IPreferenceStore store = Activator.getDefault().getPreferenceStore();
            store.setValue("enableLaunchBar", false);
            store.setValue("enableTargetSelector", false);
            store.setValue("enableBuildButton", false);
        });
    }
}

