/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.wizards;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.linuxtools.docker.core.IDockerConnection;
import org.eclipse.linuxtools.docker.core.IDockerContainerConfig;
import org.eclipse.linuxtools.docker.core.IDockerHostConfig;
import org.eclipse.linuxtools.docker.core.IDockerImage;
import org.eclipse.linuxtools.internal.docker.core.DockerConnection;
import org.eclipse.linuxtools.internal.docker.core.DockerContainerConfig;
import org.eclipse.linuxtools.internal.docker.ui.launch.LaunchConfigurationUtils;
import org.eclipse.linuxtools.internal.docker.ui.testutils.MockContainerFactory;
import org.eclipse.linuxtools.internal.docker.ui.testutils.MockContainerInfoFactory;
import org.eclipse.linuxtools.internal.docker.ui.testutils.MockDockerClientFactory;
import org.eclipse.linuxtools.internal.docker.ui.testutils.MockDockerConnectionFactory;
import org.eclipse.linuxtools.internal.docker.ui.testutils.MockDockerContainerConfigFactory;
import org.eclipse.linuxtools.internal.docker.ui.testutils.MockDockerHostConfigFactory;
import org.eclipse.linuxtools.internal.docker.ui.testutils.MockDockerImageFactory;
import org.eclipse.linuxtools.internal.docker.ui.testutils.MockImageFactory;
import org.eclipse.linuxtools.internal.docker.ui.testutils.MockImageInfoFactory;
import org.eclipse.linuxtools.internal.docker.ui.testutils.swt.ButtonAssertions;
import org.eclipse.linuxtools.internal.docker.ui.testutils.swt.ClearConnectionManagerRule;
import org.eclipse.linuxtools.internal.docker.ui.testutils.swt.CloseShellRule;
import org.eclipse.linuxtools.internal.docker.ui.testutils.swt.CloseWelcomePageRule;
import org.eclipse.linuxtools.internal.docker.ui.testutils.swt.DockerConnectionManagerUtils;
import org.eclipse.linuxtools.internal.docker.ui.testutils.swt.SWTUtils;
import org.eclipse.linuxtools.internal.docker.ui.wizards.WizardMessages;
import org.eclipse.swtbot.eclipse.finder.SWTWorkbenchBot;
import org.eclipse.swtbot.eclipse.finder.widgets.SWTBotView;
import org.eclipse.swtbot.swt.finder.waits.Conditions;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTree;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.mandas.docker.client.DockerClient;
import org.mandas.docker.client.exceptions.DockerException;
import org.mandas.docker.client.messages.Container;
import org.mandas.docker.client.messages.ContainerConfig;
import org.mandas.docker.client.messages.ContainerCreation;
import org.mandas.docker.client.messages.ContainerInfo;
import org.mandas.docker.client.messages.Image;
import org.mandas.docker.client.messages.ImageInfo;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class ImageRunSWTBotTest {
    private SWTWorkbenchBot bot = new SWTWorkbenchBot();
    private SWTBotView dockerExplorerViewBot;
    @ClassRule
    public static CloseWelcomePageRule closeWelcomePage = new CloseWelcomePageRule("org.eclipse.linuxtools.docker.ui.perspective");
    @Rule
    public ClearConnectionManagerRule clearConnectionManager = new ClearConnectionManagerRule();
    @Rule
    public CloseShellRule closeShell = new CloseShellRule(IDialogConstants.CANCEL_LABEL);

    private String configureRunImageLaunchConfiguration(IDockerConnection connection, String networkMode) {
        IDockerImage image = MockDockerImageFactory.name("images", new String[0]).connection(connection).build();
        DockerContainerConfig containerConfig = MockDockerContainerConfigFactory.cmd("cmd").build();
        IDockerHostConfig hostConfig = MockDockerHostConfigFactory.publishAllPorts(true).networkMode(networkMode).build();
        ILaunchConfiguration runImageLaunchConfiguration = LaunchConfigurationUtils.createRunImageLaunchConfiguration((IDockerImage)image, (IDockerContainerConfig)containerConfig, (IDockerHostConfig)hostConfig, new ArrayList(), (String)"some_container", (boolean)false);
        return runImageLaunchConfiguration.getName();
    }

    @Before
    public void lookupDockerExplorerView() {
        this.dockerExplorerViewBot = this.bot.viewById("org.eclipse.linuxtools.docker.ui.dockerExplorerView");
        this.dockerExplorerViewBot.show();
        this.dockerExplorerViewBot.setFocus();
    }

    @Test
    public void shouldReportErrorIfContainerWithSameNameExists() {
        DockerClient client = MockDockerClientFactory.image(MockImageFactory.name("foo:latest", new String[0]).build()).container(MockContainerFactory.name("foo_bar", new String[0]).build()).build();
        DockerConnection dockerConnection = MockDockerConnectionFactory.from("Test", client).withDefaultTCPConnectionSettings();
        DockerConnectionManagerUtils.configureConnectionManager(new IDockerConnection[]{dockerConnection});
        SWTUtils.getTreeItem(this.dockerExplorerViewBot, "Test", "Images", "foo").select();
        SWTBotTree dockerExplorerViewTreeBot = this.dockerExplorerViewBot.bot().tree();
        dockerExplorerViewTreeBot.contextMenu("Run...").click();
        this.bot.textWithLabel(WizardMessages.getString((String)"ImageRunSelectionPage.containerName")).setText("foo_bar");
        ButtonAssertions.assertThat(this.bot.button("Finish")).isNotEnabled();
    }

    @Test
    public void testNetworkModeBridge() throws CoreException {
        DockerClient client = MockDockerClientFactory.image(MockImageFactory.name("foo:latest", new String[0]).build()).container(MockContainerFactory.name("foo_bar", new String[0]).build()).build();
        DockerConnection connection = MockDockerConnectionFactory.from("Test", client).withDefaultTCPConnectionSettings();
        String runImageLaunchConfigurationName = this.configureRunImageLaunchConfiguration((IDockerConnection)connection, "bridge");
        ILaunchConfiguration runDockerImageLaunchConfig = LaunchConfigurationUtils.getLaunchConfigurationByName((String)"org.eclipse.linuxtools.docker.ui.runDockerImageLaunchConfigurationType", (String)runImageLaunchConfigurationName);
        Assertions.assertThat((Object)runDockerImageLaunchConfig).isNotNull();
        Assertions.assertThat((String)runDockerImageLaunchConfig.getAttribute("connectionName", "")).isEqualTo("Test");
        Assertions.assertThat((String)runDockerImageLaunchConfig.getAttribute("networkMode", "")).isEqualTo("bridge");
    }

    @Test
    public void testNetworkModeHost() throws CoreException {
        DockerClient client = MockDockerClientFactory.image(MockImageFactory.name("foo:latest", new String[0]).build()).container(MockContainerFactory.name("foo_bar", new String[0]).build()).build();
        DockerConnection connection = MockDockerConnectionFactory.from("Test", client).withDefaultTCPConnectionSettings();
        String runImageLaunchConfigurationName = this.configureRunImageLaunchConfiguration((IDockerConnection)connection, "host");
        ILaunchConfiguration runDockerImageLaunchConfig = LaunchConfigurationUtils.getLaunchConfigurationByName((String)"org.eclipse.linuxtools.docker.ui.runDockerImageLaunchConfigurationType", (String)runImageLaunchConfigurationName);
        Assertions.assertThat((Object)runDockerImageLaunchConfig).isNotNull();
        Assertions.assertThat((String)runDockerImageLaunchConfig.getAttribute("connectionName", "")).isEqualTo("Test");
        Assertions.assertThat((String)runDockerImageLaunchConfig.getAttribute("networkMode", "")).isEqualTo("host");
    }

    @Test
    public void testNetworkModeDefault() throws CoreException {
        DockerClient client = MockDockerClientFactory.image(MockImageFactory.name("foo:latest", new String[0]).build()).container(MockContainerFactory.name("foo_bar", new String[0]).build()).build();
        DockerConnection connection = MockDockerConnectionFactory.from("Test", client).withDefaultTCPConnectionSettings();
        String runImageLaunchConfigurationName = this.configureRunImageLaunchConfiguration((IDockerConnection)connection, "");
        ILaunchConfiguration runDockerImageLaunchConfig = LaunchConfigurationUtils.getLaunchConfigurationByName((String)"org.eclipse.linuxtools.docker.ui.runDockerImageLaunchConfigurationType", (String)runImageLaunchConfigurationName);
        Assertions.assertThat((Object)runDockerImageLaunchConfig).isNotNull();
        Assertions.assertThat((String)runDockerImageLaunchConfig.getAttribute("connectionName", "")).isEqualTo("Test");
        Assertions.assertThat((String)runDockerImageLaunchConfig.getAttribute("networkMode", "")).isEqualTo("");
    }

    @Test
    public void testNetworkModeContainer() throws CoreException {
        DockerClient client = MockDockerClientFactory.image(MockImageFactory.name("foo:latest", new String[0]).build()).container(MockContainerFactory.name("foo_bar", new String[0]).build()).build();
        DockerConnection connection = MockDockerConnectionFactory.from("Test", client).withDefaultTCPConnectionSettings();
        String runImageLaunchConfigurationName = this.configureRunImageLaunchConfiguration((IDockerConnection)connection, "container:angry_bird");
        ILaunchConfiguration runDockerImageLaunchConfig = LaunchConfigurationUtils.getLaunchConfigurationByName((String)"org.eclipse.linuxtools.docker.ui.runDockerImageLaunchConfigurationType", (String)runImageLaunchConfigurationName);
        Assertions.assertThat((Object)runDockerImageLaunchConfig).isNotNull();
        Assertions.assertThat((String)runDockerImageLaunchConfig.getAttribute("connectionName", "")).isEqualTo("Test");
        Assertions.assertThat((String)runDockerImageLaunchConfig.getAttribute("networkMode", "")).isEqualTo("container:angry_bird");
    }

    @Test
    public void testNetworkModeOther() throws CoreException {
        DockerClient client = MockDockerClientFactory.image(MockImageFactory.name("foo:latest", new String[0]).build()).container(MockContainerFactory.name("foo_bar", new String[0]).build()).build();
        DockerConnection connection = MockDockerConnectionFactory.from("Test", client).withDefaultTCPConnectionSettings();
        String runImageLaunchConfigurationName = this.configureRunImageLaunchConfiguration((IDockerConnection)connection, "jeffnet");
        ILaunchConfiguration runDockerImageLaunchConfig = LaunchConfigurationUtils.getLaunchConfigurationByName((String)"org.eclipse.linuxtools.docker.ui.runDockerImageLaunchConfigurationType", (String)runImageLaunchConfigurationName);
        Assertions.assertThat((Object)runDockerImageLaunchConfig).isNotNull();
        Assertions.assertThat((String)runDockerImageLaunchConfig.getAttribute("connectionName", "")).isEqualTo("Test");
        Assertions.assertThat((String)runDockerImageLaunchConfig.getAttribute("networkMode", "")).isEqualTo("jeffnet");
    }

    @Test
    public void shouldNotReportErrorIfNoContainerWithSameNameExists() {
        DockerClient client = MockDockerClientFactory.image(MockImageFactory.name("foo:latest", new String[0]).build()).container(MockContainerFactory.name("foo_bar", new String[0]).build()).build();
        DockerConnection dockerConnection = MockDockerConnectionFactory.from("Test", client).withDefaultTCPConnectionSettings();
        DockerConnectionManagerUtils.configureConnectionManager(new IDockerConnection[]{dockerConnection});
        SWTUtils.getTreeItem(this.dockerExplorerViewBot, "Test", "Images", "foo").select();
        SWTBotTree dockerExplorerViewTreeBot = this.dockerExplorerViewBot.bot().tree();
        dockerExplorerViewTreeBot.contextMenu("Run...").click();
        this.bot.textWithLabel(WizardMessages.getString((String)"ImageRunSelectionPage.containerName")).setText("foo_bar_baz");
        Assertions.assertThat((boolean)this.bot.button("Finish").isEnabled()).isEqualTo(true);
    }

    @Test
    public void shouldCreateLaunchConfigurationWhenRunningNamedContainer() throws InterruptedException, DockerException, CoreException {
        String imageName = "foo/bar:latest";
        Image image = MockImageFactory.id("1a2b3c4d5e6f7g").name("foo/bar:latest", new String[0]).build();
        ImageInfo imageInfo = MockImageInfoFactory.volume("/foo/bar").command(Arrays.asList("the", "command")).entrypoint(Arrays.asList("the", "entrypoint")).build();
        String containerName = "foo_bar";
        Container createdContainer = MockContainerFactory.id("MockContainer").name("foo_bar", new String[0]).imageName("1a2b3c4d5e6f7g").status("Started 1 second ago").build();
        ContainerInfo containerInfo = MockContainerInfoFactory.build();
        DockerClient client = MockDockerClientFactory.image(image, imageInfo).build();
        ContainerCreation containerCreation = (ContainerCreation)Mockito.mock(ContainerCreation.class);
        Mockito.when((Object)containerCreation.id()).thenReturn((Object)"MockContainer");
        Mockito.when((Object)client.createContainer((ContainerConfig)ArgumentMatchers.any(), (String)ArgumentMatchers.any())).thenReturn((Object)containerCreation);
        DockerConnection dockerConnection = MockDockerConnectionFactory.from("Test", client).withDefaultTCPConnectionSettings();
        DockerConnectionManagerUtils.configureConnectionManager(new IDockerConnection[]{dockerConnection});
        SWTUtils.getTreeItem(this.dockerExplorerViewBot, "Test", "Images", "foo/bar").select();
        this.dockerExplorerViewBot.bot().tree().contextMenu("Run...").click();
        this.bot.waitUntil(Conditions.shellIsActive((String)"Run a Docker Image"), TimeUnit.SECONDS.toMillis(1L));
        this.bot.text(0).setText("foo_bar");
        MockDockerClientFactory.addContainer(client, createdContainer, containerInfo);
        this.bot.button("Finish").click();
        SWTUtils.waitForJobsToComplete();
        ((DockerClient)Mockito.verify((Object)client)).createContainer((ContainerConfig)ArgumentMatchers.any(), (String)ArgumentMatchers.eq((Object)"foo_bar"));
        ILaunchConfiguration launchConfiguration = LaunchConfigurationUtils.getLaunchConfigurationByName((String)"org.eclipse.linuxtools.docker.ui.runDockerImageLaunchConfigurationType", (String)"foo_bar_latest");
        Assertions.assertThat((Object)launchConfiguration).isNotNull();
    }
}

