/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.cdt.autotools.ui.editors.automake;

import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import org.eclipse.linuxtools.internal.cdt.autotools.ui.editors.automake.Util;

public class MakefileReader
extends LineNumberReader {
    public MakefileReader(Reader reader) {
        super(reader);
    }

    public MakefileReader(Reader reader, int sz) {
        super(reader, sz);
    }

    public String readLine() throws IOException {
        boolean done = false;
        StringBuffer buffer = new StringBuffer();
        boolean escapedLine = false;
        boolean escapedCommand = false;
        while (!done) {
            String line = super.readLine();
            if (line == null) {
                return null;
            }
            if (escapedLine && line.length() > 0) {
                int i = 0;
                while (i < line.length() && Util.isSpace(line.charAt(i))) {
                    ++i;
                }
                line = line.substring(i);
            } else if (escapedCommand && line.length() > 0 && line.charAt(0) == '\t') {
                line.substring(1);
            }
            if (Util.isEscapedLine(line)) {
                int index = line.lastIndexOf(92);
                if (index <= 0) continue;
                if (!escapedLine && Util.isCommand(line)) {
                    escapedCommand = true;
                    buffer.append(line);
                    continue;
                }
                escapedLine = true;
                buffer.append(line.substring(0, index));
                buffer.append(' ');
                continue;
            }
            done = true;
            escapedLine = false;
            escapedCommand = false;
            buffer.append(line);
        }
        return buffer.toString();
    }
}

