/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.changelog.core.editors;

import java.util.Map;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.formatter.ContentFormatter;
import org.eclipse.jface.text.formatter.IContentFormatter;
import org.eclipse.jface.text.formatter.IFormattingStrategy;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.linuxtools.changelog.core.IEditorChangeLogContrib;
import org.eclipse.linuxtools.changelog.core.IEditorChangeLogContrib2;
import org.eclipse.linuxtools.changelog.core.editors.ChangeLogFormattingStrategy;
import org.eclipse.linuxtools.changelog.core.editors.ColorManager;
import org.eclipse.linuxtools.changelog.core.editors.GNUElementScanner;
import org.eclipse.linuxtools.changelog.core.editors.GNUFileEntryDamagerRepairer;
import org.eclipse.linuxtools.changelog.core.editors.GNUPartitionScanner;
import org.eclipse.linuxtools.changelog.core.editors.IChangeLogColorConstants;
import org.eclipse.linuxtools.changelog.core.editors.MultilineRuleDamagerRepairer;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.editors.text.TextSourceViewerConfiguration;

public class GNUEditorConfiguration
extends TextSourceViewerConfiguration
implements IEditorChangeLogContrib,
IEditorChangeLogContrib2 {
    public static final String CHANGELOG_PARTITIONING = "gnu_changelog_partitioning";
    private GNUElementScanner scanner;
    private ColorManager colorManager = new ColorManager();
    private TextEditor parentEditor;

    public void setTextEditor(TextEditor editor) {
        this.parentEditor = editor;
    }

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        return new String[]{"__dftl_partition_content_type", "changelog_email", "changelog_src_entry"};
    }

    protected GNUElementScanner getChangeLogFileScanner() {
        if (this.scanner == null) {
            this.scanner = new GNUElementScanner(this.colorManager);
            this.scanner.setDefaultReturnToken((IToken)new Token((Object)new TextAttribute(this.colorManager.getColor(IChangeLogColorConstants.TEXT))));
        }
        return this.scanner;
    }

    public IHyperlinkDetector[] getHyperlinkDetectors(ISourceViewer sourceViewer) {
        if (sourceViewer == null) {
            return null;
        }
        return this.getRegisteredHyperlinkDetectors(sourceViewer);
    }

    public String getConfiguredDocumentPartitioning(ISourceViewer sourceViewer) {
        return CHANGELOG_PARTITIONING;
    }

    public IContentFormatter getContentFormatter(ISourceViewer sourceViewer) {
        ContentFormatter cf = new ContentFormatter();
        cf.enablePartitionAwareFormatting(false);
        ChangeLogFormattingStrategy cfs = new ChangeLogFormattingStrategy();
        cf.setFormattingStrategy((IFormattingStrategy)cfs, "__dftl_partition_content_type");
        return cf;
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        PresentationReconciler reconciler = new PresentationReconciler();
        DefaultDamagerRepairer dr = new DefaultDamagerRepairer((ITokenScanner)this.getChangeLogFileScanner());
        reconciler.setDamager((IPresentationDamager)dr, "changelog_email");
        reconciler.setRepairer((IPresentationRepairer)dr, "changelog_email");
        dr = new GNUFileEntryDamagerRepairer((ITokenScanner)this.getChangeLogFileScanner());
        reconciler.setDamager((IPresentationDamager)dr, "changelog_src_entry");
        reconciler.setRepairer((IPresentationRepairer)dr, "changelog_src_entry");
        dr = new MultilineRuleDamagerRepairer((ITokenScanner)this.getChangeLogFileScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__dftl_partition_content_type");
        reconciler.setRepairer((IPresentationRepairer)dr, "__dftl_partition_content_type");
        return reconciler;
    }

    public void setup(IDocument document) {
        FastPartitioner partitioner = new FastPartitioner((IPartitionTokenScanner)new GNUPartitionScanner(), GNUPartitionScanner.CHANGELOG_PARTITION_TYPES);
        partitioner.connect(document);
        if (document instanceof IDocumentExtension3) {
            IDocumentExtension3 extension3 = (IDocumentExtension3)document;
            extension3.setDocumentPartitioner(CHANGELOG_PARTITIONING, (IDocumentPartitioner)partitioner);
        } else {
            document.setDocumentPartitioner((IDocumentPartitioner)partitioner);
        }
    }

    protected Map getHyperlinkDetectorTargets(ISourceViewer sourceViewer) {
        Map targets = super.getHyperlinkDetectorTargets(sourceViewer);
        targets.put("org.eclipse.changelog.editor.target", this.parentEditor);
        targets.put("org.eclipse.ui.DefaultTextEditor", this.parentEditor);
        return targets;
    }
}

