/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.changelog.core.formatters;

import java.io.File;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.FindReplaceDocumentAdapter;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.linuxtools.changelog.core.ChangelogPlugin;
import org.eclipse.linuxtools.changelog.core.IFormatterChangeLogContrib;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class GNUFormat
implements IFormatterChangeLogContrib {
    final String line_sep = System.getProperty("line.separator");
    final String TAB = "\t";

    public String formatDateLine(String authorName, String authorEmail) {
        String detail = String.valueOf(this.returnDate()) + "  " + authorName + "  " + "<" + authorEmail + ">" + this.line_sep + this.line_sep;
        return detail;
    }

    public String mergeChangelog(String dateLine, String functionGuess, String defaultContent, IEditorPart changelog, String changeLogLocation, String fileLocation) {
        String fileDetail = this.formatFileDetail(changeLogLocation, fileLocation);
        IDocument changelog_doc = this.getDocument(changelog);
        String function = this.formatFunction(functionGuess);
        boolean multipleEntrySuccess = false;
        String functionSpacer = " ";
        if (function.equals(": ")) {
            functionSpacer = "";
        }
        if (changelog_doc.getLength() > 0) {
            int offset_start = this.findChangeLogEntry(changelog_doc, dateLine);
            int offset_end = dateLine.length();
            boolean foundFunction = false;
            if (offset_start != -1) {
                int nextChangeEntry = this.findChangeLogPattern(changelog_doc, offset_start + dateLine.length());
                int functLogEntry = offset_start + dateLine.length();
                while (functLogEntry < nextChangeEntry) {
                    int line_length = 0;
                    String entry = "";
                    try {
                        line_length = changelog_doc.getLineOfOffset(functLogEntry);
                        entry = changelog_doc.get(functLogEntry, changelog_doc.getLineLength(line_length));
                    }
                    catch (BadLocationException e) {
                        e.printStackTrace();
                    }
                    if (entry.lastIndexOf("* " + fileDetail) > 0) {
                        foundFunction = true;
                        if (defaultContent.length() > 0 && entry.lastIndexOf(defaultContent) > 0) {
                            return "";
                        }
                        int nextFunctLoc = functLogEntry + fileDetail.length() + 2;
                        String nextFunc = "";
                        try {
                            nextFunc = changelog_doc.get(nextFunctLoc, nextChangeEntry - nextFunctLoc);
                        }
                        catch (BadLocationException e1) {
                            e1.printStackTrace();
                        }
                        int foundFunc = nextFunc.indexOf("* ");
                        if (foundFunc > 0) {
                            --foundFunc;
                            try {
                                while (changelog_doc.get(nextFunctLoc + foundFunc, 1).equals("\t") || changelog_doc.get(nextFunctLoc + foundFunc, 1).equals("\n")) {
                                    --foundFunc;
                                }
                            }
                            catch (BadLocationException e2) {
                                e2.printStackTrace();
                            }
                            functLogEntry = nextFunctLoc + foundFunc + 1;
                            break;
                        }
                    }
                    try {
                        functLogEntry += changelog_doc.getLineLength(line_length);
                    }
                    catch (BadLocationException e1) {
                        e1.printStackTrace();
                    }
                }
                if (functLogEntry >= nextChangeEntry) {
                    functLogEntry = nextChangeEntry - 1;
                    try {
                        while (changelog_doc.get(functLogEntry, 1).equals("\n")) {
                            --functLogEntry;
                        }
                    }
                    catch (BadLocationException e) {
                        e.printStackTrace();
                    }
                    ++functLogEntry;
                }
                if (offset_start != -1) {
                    if (foundFunction) {
                        try {
                            if (!function.equals(": ")) {
                                changelog_doc.replace(functLogEntry, 0, "\n\t" + function + " ");
                            } else {
                                changelog_doc.replace(functLogEntry, 0, "\n\t");
                            }
                        }
                        catch (BadLocationException e) {
                            e.printStackTrace();
                        }
                        ITextEditor edit = (ITextEditor)changelog;
                        if (!function.equals(": ")) {
                            edit.selectAndReveal(functLogEntry + function.length() + 3, 0);
                        } else {
                            edit.selectAndReveal(functLogEntry + function.length(), 0);
                        }
                        multipleEntrySuccess = true;
                    } else {
                        try {
                            changelog_doc.replace(offset_end, 0, "\t* " + fileDetail + functionSpacer + function + functionSpacer + defaultContent + "\n");
                        }
                        catch (BadLocationException e) {
                            e.printStackTrace();
                        }
                        ITextEditor edit = (ITextEditor)changelog;
                        edit.selectAndReveal(offset_end + fileDetail.length() + function.length() + functionSpacer.length() * 2 + 3 + defaultContent.length(), 0);
                        multipleEntrySuccess = true;
                    }
                }
            }
        }
        if (!multipleEntrySuccess) {
            try {
                if (changelog_doc.getLength() > 0) {
                    changelog_doc.replace(0, 0, "\n\n");
                }
                changelog_doc.replace(0, 0, String.valueOf(dateLine) + "\t" + "* " + fileDetail + functionSpacer + function + functionSpacer + defaultContent);
                ITextEditor edit = (ITextEditor)changelog;
                edit.selectAndReveal(dateLine.length() + fileDetail.length() + function.length() + functionSpacer.length() * 2 + 3 + defaultContent.length(), 0);
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
        }
        return "";
    }

    private IWorkspaceRoot getWorkspaceRoot() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    private String formatFileDetail(String changeLogLocation, String editorFileLocation) {
        IWorkspaceRoot myWorkspaceRoot = this.getWorkspaceRoot();
        String WorkspaceRoot = myWorkspaceRoot.getLocation().toOSString();
        String changeLogLocNoRoot = "";
        String editorFileLocNoRoot = "";
        changeLogLocNoRoot = changeLogLocation.lastIndexOf(WorkspaceRoot) >= 0 ? changeLogLocation.substring(changeLogLocation.lastIndexOf(WorkspaceRoot) + WorkspaceRoot.length(), changeLogLocation.length()) : changeLogLocation;
        editorFileLocNoRoot = editorFileLocation.lastIndexOf(WorkspaceRoot) >= 0 ? editorFileLocation.substring(editorFileLocation.lastIndexOf(WorkspaceRoot), editorFileLocation.lastIndexOf(WorkspaceRoot) + WorkspaceRoot.length()) : editorFileLocation;
        File changelogLocation = new File(changeLogLocNoRoot);
        File fileLocation = new File(editorFileLocNoRoot);
        File reversePath = fileLocation.getParentFile();
        String reversePathb = "";
        while (reversePath.getParentFile() != null) {
            if (reversePath.compareTo(changelogLocation.getParentFile()) == 0) break;
            reversePath = reversePath.getParentFile();
        }
        if (reversePath != null) {
            reversePathb = fileLocation.toString().substring(reversePath.toString().length() + 1, fileLocation.toString().length());
        }
        return reversePathb;
    }

    private int findChangeLogPattern(IDocument changelog_doc, int startOffset) {
        int nextEntry = startOffset;
        int line_length = 0;
        String entry = "";
        while (nextEntry < changelog_doc.getLength()) {
            try {
                line_length = changelog_doc.getLineOfOffset(nextEntry);
                entry = changelog_doc.get(nextEntry, changelog_doc.getLineLength(line_length));
                if (this.matchDatePattern(entry)) break;
                nextEntry += changelog_doc.getLineLength(line_length);
            }
            catch (BadLocationException e) {
                ChangelogPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.linuxtools.changelog.core", 4, e.getMessage(), (Throwable)e));
            }
        }
        return nextEntry;
    }

    private boolean matchDatePattern(String text) {
        SimpleDateFormat isoDate = new SimpleDateFormat("yyyy-MM-dd");
        try {
            Date ad = isoDate.parse(text);
            if (ad != null) {
                return true;
            }
        }
        catch (ParseException parseException) {}
        return false;
    }

    private int findChangeLogEntry(IDocument changelog_doc, String entry) {
        FindReplaceDocumentAdapter findDocumentAptd = new FindReplaceDocumentAdapter(changelog_doc);
        IRegion region = null;
        try {
            region = findDocumentAptd.find(0, entry, true, false, false, true);
        }
        catch (BadLocationException e) {
            ChangelogPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.linuxtools.changelog.core", 4, e.getMessage(), (Throwable)e));
            return -1;
        }
        if (region != null) {
            return region.getOffset() > 0 ? -1 : 0;
        }
        return -1;
    }

    private String formatFunction(String function) {
        if (function.length() > 0) {
            return "(" + function + "):";
        }
        return ": ";
    }

    public IDocument getDocument(IEditorPart currentEditor) {
        AbstractTextEditor castEditor = (AbstractTextEditor)currentEditor;
        IDocumentProvider provider = castEditor.getDocumentProvider();
        return provider.getDocument((Object)castEditor.getEditorInput());
    }

    private String returnDate() {
        SimpleDateFormat date_Format = new SimpleDateFormat("yyyy-MM-dd");
        return date_Format.format(new Date());
    }
}

