/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.lttng.ui.views.controlflow;

import java.util.Vector;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.linuxtools.lttng.event.LttngTimestamp;
import org.eclipse.linuxtools.lttng.request.ILttngSyntEventRequest;
import org.eclipse.linuxtools.lttng.state.evProcessor.ITransEventProcessor;
import org.eclipse.linuxtools.lttng.ui.TraceDebug;
import org.eclipse.linuxtools.lttng.ui.model.trange.ItemContainer;
import org.eclipse.linuxtools.lttng.ui.model.trange.TimeRangeEventProcess;
import org.eclipse.linuxtools.lttng.ui.model.trange.TimeRangeViewerProvider;
import org.eclipse.linuxtools.lttng.ui.views.common.AbsTimeUpdateView;
import org.eclipse.linuxtools.lttng.ui.views.common.ParamsUpdater;
import org.eclipse.linuxtools.lttng.ui.views.controlflow.Messages;
import org.eclipse.linuxtools.lttng.ui.views.controlflow.evProcessor.FlowEventToHandlerFactory;
import org.eclipse.linuxtools.lttng.ui.views.controlflow.model.FlowModelFactory;
import org.eclipse.linuxtools.tmf.event.TmfEvent;
import org.eclipse.linuxtools.tmf.event.TmfTimeRange;
import org.eclipse.linuxtools.tmf.experiment.TmfExperiment;
import org.eclipse.linuxtools.tmf.request.ITmfDataRequest;
import org.eclipse.linuxtools.tmf.signal.TmfExperimentSelectedSignal;
import org.eclipse.linuxtools.tmf.signal.TmfRangeSynchSignal;
import org.eclipse.linuxtools.tmf.signal.TmfSignalHandler;
import org.eclipse.linuxtools.tmf.signal.TmfTimeSynchSignal;
import org.eclipse.linuxtools.tmf.ui.viewers.TmfViewerFactory;
import org.eclipse.linuxtools.tmf.ui.viewers.timeAnalysis.ITmfTimeFilterSelectionListener;
import org.eclipse.linuxtools.tmf.ui.viewers.timeAnalysis.ITmfTimeScaleSelectionListener;
import org.eclipse.linuxtools.tmf.ui.viewers.timeAnalysis.ITmfTimeSelectionListener;
import org.eclipse.linuxtools.tmf.ui.viewers.timeAnalysis.TmfTimeAnalysisProvider;
import org.eclipse.linuxtools.tmf.ui.viewers.timeAnalysis.TmfTimeFilterSelectionEvent;
import org.eclipse.linuxtools.tmf.ui.viewers.timeAnalysis.TmfTimeScaleSelectionEvent;
import org.eclipse.linuxtools.tmf.ui.viewers.timeAnalysis.TmfTimeSelectionEvent;
import org.eclipse.linuxtools.tmf.ui.viewers.timeAnalysis.model.ITmfTimeAnalysisEntry;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class ControlFlowView
extends AbsTimeUpdateView
implements ITmfTimeSelectionListener,
ITmfTimeScaleSelectionListener,
ITmfTimeFilterSelectionListener {
    public static final String ID = "org.eclipse.linuxtools.lttng.ui.views.controlflow";
    private final String PROCESS_COLUMN = Messages.getString("ControlFlowView.processColumn");
    private final String BRAND_COLUMN = Messages.getString("ControlFlowView.brandColumn");
    private final String PID_COLUMN = Messages.getString("ControlFlowView.pidColumn");
    private final String TGID_COLUMN = Messages.getString("ControlFlowView.tgidColumn");
    private final String PPID_COLUMN = Messages.getString("ControlFlowView.ppidColumn");
    private final String CPU_COLUMN = Messages.getString("ControlFlowView.cpuColumn");
    private final String BIRTH_SEC_COLUMN = Messages.getString("ControlFlowView.birthSecColumn");
    private final String BIRTH_NSEC_COLUMN = Messages.getString("ControlFlowView.birthNSecColumn");
    private final String TRACE = Messages.getString("ControlFlowView.TraceNameColumn");
    private final String[] columnNames = new String[]{this.PROCESS_COLUMN, this.BRAND_COLUMN, this.PID_COLUMN, this.TGID_COLUMN, this.PPID_COLUMN, this.CPU_COLUMN, this.BIRTH_SEC_COLUMN, this.BIRTH_NSEC_COLUMN, this.TRACE};
    private TableViewer tableViewer;
    private Action doubleClickAction;
    private Action resetScale;
    private Action nextEvent;
    private Action prevEvent;
    private Action nextTrace;
    private Action prevTrace;
    private Action showLegend;
    private Action filterTraces;
    private Action zoomIn;
    private Action zoomOut;
    private Action zoomFilter;
    private ViewProcessFilter tableFilter = null;
    private ScrolledComposite scrollFrame = null;

    public ControlFlowView() {
        super(ID);
    }

    public void createPartControl(Composite parent) {
        TmfExperiment experiment;
        this.scrollFrame = new ScrolledComposite(parent, 512);
        this.scrollFrame.setExpandVertical(true);
        this.scrollFrame.setExpandHorizontal(true);
        this.scrollFrame.setAlwaysShowScrollBars(true);
        SashForm sash = new SashForm((Composite)this.scrollFrame, 0);
        this.scrollFrame.setContent((Control)sash);
        this.tableViewer = new TableViewer((Composite)sash, 65792);
        this.tableViewer.setContentProvider((IContentProvider)new ViewContentProvider(this.tableViewer));
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new ViewLabelProvider());
        Table table = this.tableViewer.getTable();
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection sel = event.getSelection();
                if (!sel.isEmpty()) {
                    Object firstSel = null;
                    if (sel instanceof IStructuredSelection) {
                        firstSel = ((IStructuredSelection)sel).getFirstElement();
                        this.updateScrollOrigin();
                        if (firstSel instanceof ITmfTimeAnalysisEntry) {
                            ITmfTimeAnalysisEntry trace = (ITmfTimeAnalysisEntry)firstSel;
                            ControlFlowView.this.tsfviewer.setSelectedTrace(trace);
                        }
                    }
                }
            }

            private void updateScrollOrigin() {
                Table table = ControlFlowView.this.tableViewer.getTable();
                if (table != null && table.getItemCount() > 0) {
                    TableItem item = table.getSelection()[0];
                    if (item == null) {
                        return;
                    }
                    Rectangle itemRect = item.getBounds();
                    int step = itemRect.height;
                    int hscrolly = 0;
                    ScrollBar hbar = ControlFlowView.this.scrollFrame.getHorizontalBar();
                    if (hbar != null) {
                        hscrolly = hbar.getSize().y;
                    }
                    int visibleHeight = ((ControlFlowView)ControlFlowView.this).scrollFrame.getSize().y - hscrolly;
                    Point origin = ControlFlowView.this.scrollFrame.getOrigin();
                    int endy = origin.y + visibleHeight;
                    int itemStartPos = itemRect.y + table.getHeaderHeight() + table.getBorderWidth() + table.getParent().getBorderWidth();
                    int itemEndPos = itemStartPos + step;
                    if (origin.y >= step && itemStartPos < origin.y) {
                        ControlFlowView.this.scrollFrame.setOrigin(origin.x, origin.y - step);
                    }
                    if (itemEndPos > endy) {
                        ControlFlowView.this.scrollFrame.setOrigin(origin.x, origin.y + step);
                    }
                }
            }
        });
        this.tableViewer.getTable().addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                Table table = ControlFlowView.this.tableViewer.getTable();
                Point origin = ControlFlowView.this.scrollFrame.getOrigin();
                if (table == null || table.getItemCount() < 1) {
                    return;
                }
                switch (e.keyCode) {
                    case 0x1000006: {
                        this.updateScrollPageDown();
                        break;
                    }
                    case 0x1000005: {
                        this.updateScrollUp();
                        break;
                    }
                    case 0x1000007: {
                        int count = table.getItemCount();
                        TableItem item = table.getItem(0);
                        ControlFlowView.this.scrollFrame.setOrigin(origin.x, 0);
                        break;
                    }
                    case 0x1000008: {
                        int count = table.getItemCount();
                        TableItem item = table.getItem(count - 1);
                        int itemStartPos = item.getBounds().y;
                        ControlFlowView.this.scrollFrame.setOrigin(origin.x, itemStartPos);
                        break;
                    }
                }
            }

            public void keyReleased(KeyEvent e) {
            }

            private void updateScrollPageDown() {
                Table table = ControlFlowView.this.tableViewer.getTable();
                int step = table.getItemHeight();
                int hscrolly = 0;
                ScrollBar hbar = ControlFlowView.this.scrollFrame.getHorizontalBar();
                if (hbar != null) {
                    hscrolly = hbar.getSize().y;
                }
                Point origin = ControlFlowView.this.scrollFrame.getOrigin();
                int visibleHeight = ((ControlFlowView)ControlFlowView.this).scrollFrame.getSize().y - hscrolly;
                int endy = origin.y + visibleHeight;
                ControlFlowView.this.scrollFrame.setOrigin(origin.x, endy - step);
            }

            private void updateScrollUp() {
                Table table = ControlFlowView.this.tableViewer.getTable();
                int step = table.getItemHeight();
                int hscrolly = 0;
                ScrollBar hbar = ControlFlowView.this.scrollFrame.getHorizontalBar();
                if (hbar != null) {
                    hscrolly = hbar.getSize().y;
                }
                Point origin = ControlFlowView.this.scrollFrame.getOrigin();
                int visibleHeight = ((ControlFlowView)ControlFlowView.this).scrollFrame.getSize().y - hscrolly;
                int pageUpPos = origin.y - visibleHeight + step;
                pageUpPos = pageUpPos > 0 ? pageUpPos : 0;
                ControlFlowView.this.scrollFrame.setOrigin(origin.x, pageUpPos);
            }
        });
        this.applyTableLayout(table);
        int borderWidth = table.getBorderWidth();
        int itemHeight = table.getItemHeight() + this.checkForSWTBugItemHeightAdjustement();
        int headerHeight = table.getHeaderHeight();
        table.getVerticalBar().setVisible(false);
        this.tsfviewer = TmfViewerFactory.createViewer((Composite)sash, (TmfTimeAnalysisProvider)new TimeRangeViewerProvider(this.getParamsUpdater()));
        this.tsfviewer.addWidgetSelectionListner((ITmfTimeSelectionListener)this);
        this.tsfviewer.addWidgetTimeScaleSelectionListner((ITmfTimeScaleSelectionListener)this);
        this.tsfviewer.groupTraces(false);
        this.tsfviewer.setItemHeight(itemHeight);
        this.tsfviewer.setBorderWidth(borderWidth);
        this.tsfviewer.setHeaderHeight(headerHeight);
        this.tsfviewer.setVisibleVerticalScroll(false);
        this.tsfviewer.setNameWidthPref(0);
        this.tsfviewer.setAcceptSelectionAPIcalls(true);
        this.tsfviewer.addWidgetSelectionListner((ITmfTimeSelectionListener)this);
        this.tsfviewer.addFilterSelectionListner((ITmfTimeFilterSelectionListener)this);
        this.tsfviewer.addWidgetTimeScaleSelectionListner((ITmfTimeScaleSelectionListener)this);
        sash.setWeights(new int[]{1, 1});
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.tableViewer.getControl(), "org.eclipse.linuxtools.lttnng.ui.views.flow.viewer");
        this.makeActions();
        this.hookContextMenu();
        this.hookDoubleClickAction();
        this.contributeToActionBars();
        int timeSpaceWidth = this.tsfviewer.getTimeSpace();
        if (timeSpaceWidth < 0) {
            timeSpaceWidth = -timeSpaceWidth;
        }
        if ((experiment = TmfExperiment.getCurrentExperiment()) != null) {
            TmfTimeRange experimentTRange = experiment.getTimeRange();
            TmfTimeRange adjustedTimeRange = this.initialExperimentDataRequest((Object)this, experimentTRange);
            this.ModelUpdateInit(experimentTRange, adjustedTimeRange, (Object)this);
        } else {
            TraceDebug.debug("No selected experiment information available");
        }
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                ControlFlowView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.tableViewer.getControl());
        this.tableViewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.tableViewer);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.resetScale);
        manager.add((IAction)this.nextEvent);
        manager.add((IAction)this.prevEvent);
        manager.add((IAction)this.nextTrace);
        manager.add((IAction)this.prevTrace);
        manager.add((IAction)this.zoomIn);
        manager.add((IAction)this.zoomOut);
        manager.add((IAction)this.zoomFilter);
        manager.add((IContributionItem)new Separator());
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.resetScale);
        manager.add((IAction)this.nextEvent);
        manager.add((IAction)this.prevEvent);
        manager.add((IAction)this.nextTrace);
        manager.add((IAction)this.prevTrace);
        manager.add((IAction)this.zoomIn);
        manager.add((IAction)this.zoomOut);
        manager.add((IAction)this.zoomFilter);
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)new Separator("additions"));
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.resetScale);
        manager.add((IAction)this.nextEvent);
        manager.add((IAction)this.prevEvent);
        manager.add((IAction)this.nextTrace);
        manager.add((IAction)this.prevTrace);
        manager.add((IAction)this.zoomIn);
        manager.add((IAction)this.zoomOut);
        manager.add((IAction)this.zoomFilter);
        manager.add((IContributionItem)new Separator());
    }

    private void makeActions() {
        this.resetScale = new Action(){

            public void run() {
                if (ControlFlowView.this.tsfviewer != null) {
                    ControlFlowView.this.tsfviewer.resetStartFinishTime();
                }
            }
        };
        this.resetScale.setText(Messages.getString("ControlFlowView.Action.Reset"));
        this.resetScale.setToolTipText(Messages.getString("ControlFlowView.Action.Reset.ToolTip"));
        this.resetScale.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)Messages.getString("ControlFlowView.tmf.UI"), (String)"icons/elcl16/home_nav.gif"));
        this.nextEvent = new Action(){

            public void run() {
                if (ControlFlowView.this.tsfviewer != null) {
                    ControlFlowView.this.tsfviewer.selectNextEvent();
                }
            }
        };
        this.nextEvent.setText(Messages.getString("ControlFlowView.Action.NextEvent"));
        this.nextEvent.setToolTipText(Messages.getString("ControlFlowView.Action.NextEvent.Tooltip"));
        this.nextEvent.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)Messages.getString("ControlFlowView.tmf.UI"), (String)"icons/elcl16/next_event.gif"));
        this.prevEvent = new Action(){

            public void run() {
                if (ControlFlowView.this.tsfviewer != null) {
                    ControlFlowView.this.tsfviewer.selectPrevEvent();
                }
            }
        };
        this.prevEvent.setText(Messages.getString("ControlFlowView.Action.PrevEvent"));
        this.prevEvent.setToolTipText(Messages.getString("ControlFlowView.Action.PrevEvent.Tooltip"));
        this.prevEvent.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)Messages.getString("ControlFlowView.tmf.UI"), (String)"icons/elcl16/prev_event.gif"));
        this.nextTrace = new Action(){

            public void run() {
                if (ControlFlowView.this.tsfviewer != null) {
                    ControlFlowView.this.tsfviewer.selectNextTrace();
                }
            }
        };
        this.nextTrace.setText(Messages.getString("ControlFlowView.Action.NextProcess"));
        this.nextTrace.setToolTipText(Messages.getString("ControlFlowView.Action.NextProcess.ToolTip"));
        this.nextTrace.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)Messages.getString("ControlFlowView.tmf.UI"), (String)"icons/elcl16/next_item.gif"));
        this.prevTrace = new Action(){

            public void run() {
                if (ControlFlowView.this.tsfviewer != null) {
                    ControlFlowView.this.tsfviewer.selectPrevTrace();
                }
            }
        };
        this.prevTrace.setText(Messages.getString("ControlFlowView.Action.PreviousProcess"));
        this.prevTrace.setToolTipText(Messages.getString("ControlFlowView.Action.PreviousProcess.Tooltip"));
        this.prevTrace.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)Messages.getString("ControlFlowView.tmf.UI"), (String)"icons/elcl16/prev_item.gif"));
        this.showLegend = new Action(){

            public void run() {
                if (ControlFlowView.this.tsfviewer != null) {
                    ControlFlowView.this.tsfviewer.showLegend();
                }
            }
        };
        this.showLegend.setText(Messages.getString("ControlFlowView.Action.Legend"));
        this.showLegend.setToolTipText(Messages.getString("ControlFlowView.Action.Legend.ToolTip"));
        this.filterTraces = new Action(){

            public void run() {
                if (ControlFlowView.this.tsfviewer != null) {
                    ControlFlowView.this.tsfviewer.filterTraces();
                }
            }
        };
        this.filterTraces.setText(Messages.getString("ControlFlowView.Action.Filter"));
        this.filterTraces.setToolTipText(Messages.getString("ControlFlowView.Action.Filter.ToolTip"));
        this.filterTraces.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)Messages.getString("ControlFlowView.tmf.UI"), (String)"icons/elcl16/filter_items.gif"));
        this.zoomIn = new Action(){

            public void run() {
                if (ControlFlowView.this.tsfviewer != null) {
                    ControlFlowView.this.tsfviewer.zoomIn();
                }
            }
        };
        this.zoomIn.setText(Messages.getString("ControlFlowView.Action.ZoomIn"));
        this.zoomIn.setToolTipText(Messages.getString("ControlFlowView.Action.ZoomIn.Tooltip"));
        this.zoomIn.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)Messages.getString("ControlFlowView.tmf.UI"), (String)"icons/elcl16/zoomin_nav.gif"));
        this.zoomOut = new Action(){

            public void run() {
                if (ControlFlowView.this.tsfviewer != null) {
                    ControlFlowView.this.tsfviewer.zoomOut();
                }
            }
        };
        this.zoomOut.setText(Messages.getString("ControlFlowView.Action.ZoomOut"));
        this.zoomOut.setToolTipText(Messages.getString("ControlFlowView.Action.ZoomOut.tooltip"));
        this.zoomOut.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)Messages.getString("ControlFlowView.tmf.UI"), (String)"icons/elcl16/zoomout_nav.gif"));
        this.zoomFilter = new Action(){

            public void run() {
            }
        };
        this.zoomFilter.setText(Messages.getString("ControlFlowView.Action.ZoomFilter"));
        this.zoomFilter.setToolTipText(Messages.getString("ControlFlowView.Action.ZoomFilter.tooltip"));
        this.zoomFilter.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)Messages.getString("ControlFlowView.tmf.UI"), (String)"icons/elcl16/filter_items.gif"));
        this.zoomFilter.setChecked(false);
        this.doubleClickAction = new Action(){

            public void run() {
                ISelection selection = ControlFlowView.this.tableViewer.getSelection();
                Object obj = ((IStructuredSelection)selection).getFirstElement();
                ControlFlowView.this.showMessage("Double-click detected on " + obj.toString());
            }
        };
    }

    private void hookDoubleClickAction() {
        this.tableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ControlFlowView.this.doubleClickAction.run();
            }
        });
    }

    private void showMessage(String message) {
        MessageDialog.openInformation((Shell)this.tableViewer.getControl().getShell(), (String)Messages.getString("ControlFlowView.msgSlogan"), (String)message);
    }

    public void setFocus() {
        this.tableViewer.getControl().setFocus();
    }

    @Override
    public void tsfTmProcessSelEvent(TmfTimeSelectionEvent event) {
        super.tsfTmProcessSelEvent(event);
        ISelection sel = this.tsfviewer.getSelectionTrace();
        if (sel != null && !sel.isEmpty()) {
            this.tableViewer.setSelection(sel);
        }
    }

    @Override
    public void tsfTmProcessTimeScaleEvent(TmfTimeScaleSelectionEvent event) {
        super.tsfTmProcessTimeScaleEvent(event);
    }

    private void applyTableLayout(Table table) {
        int i = 0;
        while (i < this.columnNames.length) {
            TableColumn tableColumn = new TableColumn(table, 16384);
            tableColumn.setText(this.columnNames[i]);
            tableColumn.pack();
            ++i;
        }
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
    }

    @Override
    public void displayModel(final ITmfTimeAnalysisEntry[] items, final long startBoundTime, final long endBoundTime, final boolean updateTimeBounds, final long startVisibleWindow, final long endVisibleWindow, final Object source) {
        if (this.tableViewer != null) {
            final Table table = this.tableViewer.getTable();
            if (table.isDisposed()) {
                return;
            }
            Display display = table.getDisplay();
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (!table.isDisposed()) {
                        ControlFlowView.this.tableViewer.setInput((Object)items);
                        ControlFlowView.this.tableFilter = new ViewProcessFilter((StructuredViewer)ControlFlowView.this.tableViewer);
                        ControlFlowView.this.tableViewer.setFilters(new ViewerFilter[]{ControlFlowView.this.tableFilter});
                        ControlFlowView.this.resizeTableColumns(table);
                        table.update();
                        ControlFlowView.this.tableViewer.refresh();
                        ControlFlowView.this.tsfviewer.display(items, startBoundTime, endBoundTime, updateTimeBounds);
                        if (startVisibleWindow > -1L && endVisibleWindow > -1L) {
                            ControlFlowView.this.tsfviewer.setSelectVisTimeWindow(startVisibleWindow, endVisibleWindow, source);
                        }
                        ControlFlowView.this.tsfviewer.resizeControls();
                        ControlFlowView.this.tableViewer.getTable().getDisplay().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                if (ControlFlowView.this.scrollFrame != null && !ControlFlowView.this.scrollFrame.isDisposed()) {
                                    ControlFlowView.this.updateScrolls(ControlFlowView.this.scrollFrame);
                                }
                            }
                        });
                    }
                }
            });
        }
    }

    public void dispose() {
        super.dispose();
        this.tsfviewer.removeFilterSelectionListner((ITmfTimeFilterSelectionListener)this);
        this.tsfviewer.removeWidgetSelectionListner((ITmfTimeSelectionListener)this);
        this.tsfviewer.removeWidgetTimeScaleSelectionListner((ITmfTimeScaleSelectionListener)this);
        this.tableViewer = null;
        this.tsfviewer = null;
    }

    private synchronized void resizeTableColumns(Table table) {
        if (table != null) {
            TableColumn[] columns;
            Composite parent = table.getParent();
            int tableWidthSum = parent.getBorderWidth();
            TableColumn[] tableColumnArray = columns = table.getColumns();
            int n = columns.length;
            int n2 = 0;
            while (n2 < n) {
                TableColumn column = tableColumnArray[n2];
                column.pack();
                tableWidthSum += column.getWidth();
                ++n2;
            }
        }
    }

    public void tmfTaProcessFilterSelection(TmfTimeFilterSelectionEvent event) {
        if (this.tableFilter != null) {
            Vector filteredout = event.getFilteredOut();
            if (filteredout != null) {
                this.tableFilter.setFilter(filteredout);
            } else {
                this.tableFilter.setFilter(new Vector<ITmfTimeAnalysisEntry>());
            }
            this.tableViewer.refresh();
        }
    }

    private void updateScrolls(ScrolledComposite scrollFrame) {
        scrollFrame.setMinSize(this.tableViewer.getTable().computeSize(-1, -1));
    }

    @Override
    @TmfSignalHandler
    public void synchToTime(TmfTimeSynchSignal signal) {
        super.synchToTime(signal);
    }

    @TmfSignalHandler
    public void synchToTimeRange(TmfRangeSynchSignal signal) {
        if (this.zoomFilter != null) {
            this.synchToTimeRange(signal, this.zoomFilter.isChecked());
        }
    }

    @Override
    public void modelIncomplete(ILttngSyntEventRequest request) {
    }

    @Override
    public ITransEventProcessor getEventProcessor() {
        return FlowEventToHandlerFactory.getInstance();
    }

    @TmfSignalHandler
    public void experimentSelected(TmfExperimentSelectedSignal<? extends TmfEvent> signal) {
        if (signal != null) {
            TmfTimeRange experimentTRange = signal.getExperiment().getTimeRange();
            this.ModelUpdateInit(experimentTRange, experimentTRange, signal.getSource());
            this.initialExperimentDataRequest(signal.getSource(), experimentTRange);
        }
    }

    private TmfTimeRange initialExperimentDataRequest(Object source, TmfTimeRange experimentTRange) {
        TmfTimeRange initTimeWindow = this.getInitTRange(experimentTRange);
        this.dataRequest(initTimeWindow, experimentTRange, true, ITmfDataRequest.ExecutionType.FOREGROUND);
        if (TraceDebug.isDEBUG()) {
            TraceDebug.debug("Initialization request time range is: " + initTimeWindow.getStartTime().toString() + "-" + initTimeWindow.getEndTime().toString());
        }
        return initTimeWindow;
    }

    public int checkForSWTBugItemHeightAdjustement() {
        int returnedAjustement = 0;
        String desktopSessionName = System.getenv("DESKTOP_SESSION");
        if (desktopSessionName.equals("gnome")) {
            returnedAjustement = 0;
        } else if (desktopSessionName.equals("kde")) {
            returnedAjustement = 2;
        }
        return returnedAjustement;
    }

    @Override
    protected ParamsUpdater getParamsUpdater() {
        return FlowModelFactory.getParamsUpdater();
    }

    @Override
    protected ItemContainer<?> getItemContainer() {
        return FlowModelFactory.getProcContainer();
    }

    @Override
    protected int getProviderId() {
        return 1;
    }

    class ViewContentProvider
    implements IStructuredContentProvider {
        private TableViewer cviewer = null;
        private ITmfTimeAnalysisEntry[] elements = null;

        public ViewContentProvider(TableViewer v) {
            this.cviewer = v;
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
            this.elements = (ITmfTimeAnalysisEntry[])newInput;
            if (this.elements != null) {
                TraceDebug.debug("Total number of processes provided to Control Flow view: " + this.elements.length);
            } else {
                TraceDebug.debug("New input = null");
            }
        }

        public void dispose() {
        }

        public void updateElement(int index) {
            this.cviewer.replace((Object)this.elements[index], index);
        }

        public Object[] getElements(Object inputElement) {
            return this.elements;
        }
    }

    class ViewLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        ViewLabelProvider() {
        }

        public String getColumnText(Object obj, int index) {
            String strRes = "";
            if (obj instanceof TimeRangeEventProcess) {
                TimeRangeEventProcess process = (TimeRangeEventProcess)obj;
                switch (index) {
                    case 0: {
                        strRes = process.getName();
                        break;
                    }
                    case 1: {
                        strRes = process.getBrand();
                        break;
                    }
                    case 2: {
                        strRes = process.getPid().toString();
                        break;
                    }
                    case 3: {
                        strRes = process.getTgid().toString();
                        break;
                    }
                    case 4: {
                        strRes = process.getPpid().toString();
                        break;
                    }
                    case 5: {
                        strRes = process.getCpu().toString();
                        break;
                    }
                    case 6: {
                        LttngTimestamp time = new LttngTimestamp(process.getCreationTime().longValue());
                        strRes = time.getSeconds();
                        break;
                    }
                    case 7: {
                        LttngTimestamp time = new LttngTimestamp(process.getCreationTime().longValue());
                        strRes = time.getNanoSeconds();
                        break;
                    }
                    case 8: {
                        strRes = process.getTraceID();
                        break;
                    }
                }
            } else {
                return this.getText(obj);
            }
            return strRes;
        }

        public Image getColumnImage(Object obj, int index) {
            return this.getImage(obj);
        }

        public Image getImage(Object obj) {
            return null;
        }
    }

    class ViewProcessFilter
    extends ViewerFilter {
        private Vector<ITmfTimeAnalysisEntry> filteredSet = new Vector();
        StructuredViewer viewer;

        public ViewProcessFilter(StructuredViewer rviewer) {
            this.viewer = rviewer;
        }

        public void setFilter(Vector<ITmfTimeAnalysisEntry> filtered) {
            if (filtered != null) {
                this.filteredSet = filtered;
                this.viewer.refresh();
            }
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            boolean filteredIn = true;
            if (element instanceof ITmfTimeAnalysisEntry) {
                ITmfTimeAnalysisEntry process = (ITmfTimeAnalysisEntry)element;
                if (this.filteredSet.contains(process)) {
                    return false;
                }
            } else {
                TraceDebug.debug("Unexpected type of filter element received: " + element.toString());
            }
            return filteredIn;
        }
    }
}

