/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.lttng.ui.views.controlflow.evProcessor;

import java.util.Vector;
import org.eclipse.linuxtools.lttng.event.LttngEvent;
import org.eclipse.linuxtools.lttng.state.StateStrings;
import org.eclipse.linuxtools.lttng.state.evProcessor.ILttngEventProcessor;
import org.eclipse.linuxtools.lttng.state.model.LttngProcessState;
import org.eclipse.linuxtools.lttng.state.model.LttngTraceState;
import org.eclipse.linuxtools.lttng.ui.TraceDebug;
import org.eclipse.linuxtools.lttng.ui.model.trange.TimeRangeComponent;
import org.eclipse.linuxtools.lttng.ui.model.trange.TimeRangeEvent;
import org.eclipse.linuxtools.lttng.ui.model.trange.TimeRangeEventProcess;
import org.eclipse.linuxtools.lttng.ui.views.controlflow.evProcessor.AbsFlowTRangeUpdate;

public class FlowFinishUpdateHandler
extends AbsFlowTRangeUpdate
implements ILttngEventProcessor {
    public StateStrings.Events getEventHandleType() {
        return null;
    }

    public boolean process(LttngEvent trcEvent, LttngTraceState traceSt) {
        long endOfTrace = traceSt.getContext().getTraceTimeWindow().getEndTime().getValue();
        long halfWindow = (this.params.getEndTime() - this.params.getStartTime()) / 2L;
        long endOfEvent = this.params.getEndTime() + halfWindow;
        if (endOfEvent > endOfTrace) {
            endOfEvent = endOfTrace;
        }
        TraceDebug.debug("Number of localProcesses: " + this.procContainer.readItems().length);
        String traceId = traceSt.getTraceId();
        int numLocalFound = 0;
        int numLocalNotFound = 0;
        int numWithNoChildren = 0;
        TimeRangeEventProcess[] timeRangeEventProcessArray = this.procContainer.readItems();
        int n = timeRangeEventProcessArray.length;
        int n2 = 0;
        while (n2 < n) {
            TimeRangeEventProcess localProcess = timeRangeEventProcessArray[n2];
            LttngProcessState stateProcess = this.lttv_state_find_process(traceSt, localProcess.getCpu(), localProcess.getPid());
            if (localProcess.getTraceID().equals(traceId)) {
                if (stateProcess == null) {
                    Vector<TimeRangeComponent> childrenEvents = localProcess.getTraceEvents();
                    if (childrenEvents.size() > 0) {
                        TimeRangeComponent prevEvent = childrenEvents.get(childrenEvents.size() - 1);
                        if (prevEvent instanceof TimeRangeEvent) {
                            TimeRangeEvent prevTimeRange = (TimeRangeEvent)prevEvent;
                            long nextGoodTime = localProcess.getNext_good_time();
                            String stateMode = prevTimeRange.getStateMode();
                            this.makeDraw(traceSt, nextGoodTime, endOfEvent, localProcess, this.params, stateMode);
                        } else {
                            TraceDebug.debug("previous event not instance of TimeRangeEvent?: " + prevEvent.getClass().getSimpleName());
                        }
                    } else {
                        ++numWithNoChildren;
                    }
                    ++numLocalNotFound;
                } else {
                    ++numLocalFound;
                    this.makeDraw(traceSt, endOfEvent, stateProcess, localProcess, this.params);
                }
            }
            ++n2;
        }
        TraceDebug.debug("Print Last Event: NumLocalFound " + numLocalFound + "; NumLocalNotFound: " + numLocalNotFound + "; NumWithNoChildren: " + numWithNoChildren);
        return false;
    }
}

