/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.lttng.ui.views.histogram;

import org.eclipse.linuxtools.lttng.ui.views.histogram.AsyncCanvasRedrawer;
import org.eclipse.linuxtools.lttng.ui.views.histogram.HistogramCanvas;
import org.eclipse.linuxtools.lttng.ui.views.histogram.HistogramCanvasKeyListener;
import org.eclipse.linuxtools.lttng.ui.views.histogram.HistogramCanvasMouseListener;
import org.eclipse.linuxtools.lttng.ui.views.histogram.HistogramContent;
import org.eclipse.linuxtools.lttng.ui.views.histogram.HistogramSelectedWindow;
import org.eclipse.linuxtools.lttng.ui.views.histogram.HistogramView;
import org.eclipse.linuxtools.lttng.ui.views.histogram.ParentHistogramCanvasControlListener;
import org.eclipse.linuxtools.lttng.ui.views.histogram.ParentHistogramCanvasPaintListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public class ParentHistogramCanvas
extends HistogramCanvas {
    private ParentHistogramCanvasPaintListener paintListener = null;
    private HistogramCanvasMouseListener mouseListener = null;
    private HistogramCanvasKeyListener keyListener = null;
    private ParentHistogramCanvasControlListener controlListener = null;
    private HistogramSelectedWindow currentWindow = null;

    public ParentHistogramCanvas(HistogramView histogramView, Composite parent, int style) {
        super(histogramView, parent, style);
        if (histogramView != null && HistogramView.getFullExperimentCanvas() != null) {
            this.createNewSelectedWindow(HistogramView.getFullExperimentCanvas().getHistogramContent().getStartTime() + HistogramView.getDEFAULT_WINDOW_SIZE() / 2L, HistogramView.getDEFAULT_WINDOW_SIZE());
        }
        this.createAndAddPaintListener();
        this.createAndAddMouseListener();
        this.createAndAddKeyListener();
        this.createAndAddControlListener();
    }

    @Override
    public void createNewHistogramContent(int canvasSize, int widthPerBar, int barsHeight, double maxBarsDifferenceToAverage) {
        int canvasMaxSize = this.getParent().getDisplay().getBounds().width;
        int exp = (int)Math.ceil(Math.log(canvasMaxSize) / Math.log(2.0));
        int contentSize = (int)Math.pow(2.0, exp);
        this.histogramContent = new HistogramContent(contentSize, canvasSize, widthPerBar, barsHeight, maxBarsDifferenceToAverage);
        double maxBarsDiffFactor = (double)contentSize / Math.pow(2.0, exp - 1);
        this.histogramContent.setMaxDifferenceToAverageFactor(maxBarsDiffFactor);
    }

    private void createAndAddPaintListener() {
        this.paintListener = new ParentHistogramCanvasPaintListener(this);
        this.addPaintListener(this.paintListener);
    }

    private void createAndAddMouseListener() {
        this.mouseListener = new HistogramCanvasMouseListener(this);
        this.addMouseListener(this.mouseListener);
        this.addMouseMoveListener(this.mouseListener);
        this.addMouseWheelListener(this.mouseListener);
    }

    private void createAndAddKeyListener() {
        this.keyListener = new HistogramCanvasKeyListener(this);
        this.addKeyListener(this.keyListener);
    }

    private void createAndAddControlListener() {
        this.controlListener = new ParentHistogramCanvasControlListener(this);
        this.addControlListener(this.controlListener);
    }

    public void createNewSelectedWindow(long timestampOfLeftPosition, long windowTimeDuration) {
        this.currentWindow = new HistogramSelectedWindow(this.histogramContent, timestampOfLeftPosition, windowTimeDuration);
    }

    public HistogramSelectedWindow getCurrentWindow() {
        return this.currentWindow;
    }

    public long getSelectedWindowSize() {
        return this.currentWindow.getWindowTimeWidth();
    }

    public void setSelectedWindowSize(long newSelectedWindowSize) {
        if (newSelectedWindowSize <= 0L) {
            newSelectedWindowSize = 1L;
        } else if (newSelectedWindowSize > 2L * this.histogramContent.getCompleteTimeInterval()) {
            newSelectedWindowSize = 2L * this.histogramContent.getCompleteTimeInterval();
        }
        this.currentWindow.setWindowTimeWidth(newSelectedWindowSize);
    }

    public void moveWindow(int newRelativeXPosition) {
        int absolutePosition = this.currentWindow.getWindowXPositionCenter() + newRelativeXPosition;
        this.setWindowCenterPosition(absolutePosition);
        this.notifyParentSelectionWindowChangedAsynchronously();
    }

    public void setWindowCenterPosition(int newAbsoluteXPosition) {
        if (newAbsoluteXPosition != this.currentWindow.getWindowXPositionCenter()) {
            long timestampOfLeftPosition = this.getHistogramContent().getClosestElementFromXPosition((int)newAbsoluteXPosition).firstIntervalTimestamp - this.currentWindow.getWindowTimeWidth() / 2L;
            long timestampOfCenterPosition = 0L;
            long timestampOfRightPosition = 0L;
            if (timestampOfLeftPosition < this.histogramContent.getStartTime()) {
                timestampOfLeftPosition = this.histogramContent.getStartTime();
                timestampOfCenterPosition = timestampOfLeftPosition + this.currentWindow.getWindowTimeWidth() / 2L;
                timestampOfRightPosition = timestampOfLeftPosition + this.currentWindow.getWindowTimeWidth();
            } else {
                timestampOfRightPosition = this.getHistogramContent().getClosestElementFromXPosition((int)newAbsoluteXPosition).firstIntervalTimestamp + this.currentWindow.getWindowTimeWidth() / 2L;
                if (timestampOfRightPosition > this.histogramContent.getEndTime()) {
                    timestampOfRightPosition = this.histogramContent.getEndTime();
                    timestampOfCenterPosition = timestampOfRightPosition - this.currentWindow.getWindowTimeWidth() / 2L;
                    timestampOfLeftPosition = timestampOfRightPosition - this.currentWindow.getWindowTimeWidth();
                } else {
                    timestampOfCenterPosition = this.getHistogramContent().getClosestElementFromXPosition((int)newAbsoluteXPosition).firstIntervalTimestamp;
                }
            }
            if (timestampOfCenterPosition != this.currentWindow.getTimestampOfCenterPosition()) {
                this.currentWindow.setTimestampOfLeftPosition(timestampOfLeftPosition);
                this.currentWindow.setTimestampOfCenterPosition(timestampOfCenterPosition);
                this.currentWindow.setTimestampOfRightPosition(timestampOfRightPosition);
                this.currentWindow.setWindowXPositionLeft(this.histogramContent.getClosestXPositionFromTimestamp(timestampOfLeftPosition));
                this.currentWindow.setWindowXPositionCenter(this.histogramContent.getClosestXPositionFromTimestamp(timestampOfCenterPosition));
                this.currentWindow.setWindowXPositionRight(this.histogramContent.getClosestXPositionFromTimestamp(timestampOfRightPosition));
                this.redrawAsynchronously();
            }
        }
    }

    public void setWindowCenterPosition(long timestampOfCenterPosition) {
        if (timestampOfCenterPosition != this.currentWindow.getTimestampOfCenterPosition()) {
            long timestampOfLeft = timestampOfCenterPosition - this.currentWindow.getWindowTimeWidth() / 2L;
            long timestampOfCenter = 0L;
            long timestampOfRight = 0L;
            int windowXPositionLeft = this.histogramContent.getClosestXPositionFromTimestamp(timestampOfLeft);
            int windowXPositionCenter = 0;
            int windowXPositionRight = 0;
            if (timestampOfLeft < this.histogramContent.getStartTime()) {
                timestampOfLeft = this.histogramContent.getStartTime();
                timestampOfCenter = timestampOfLeft + this.currentWindow.getWindowTimeWidth() / 2L;
                timestampOfRight = timestampOfLeft + this.currentWindow.getWindowTimeWidth();
                windowXPositionLeft = this.histogramContent.getClosestXPositionFromTimestamp(timestampOfLeft);
                windowXPositionCenter = this.histogramContent.getClosestXPositionFromTimestamp(timestampOfCenter);
                windowXPositionRight = this.histogramContent.getClosestXPositionFromTimestamp(timestampOfRight);
            } else {
                timestampOfRight = timestampOfCenterPosition + this.currentWindow.getWindowTimeWidth() / 2L;
                windowXPositionRight = this.histogramContent.getClosestXPositionFromTimestamp(timestampOfRight);
                if ((long)windowXPositionRight > this.histogramContent.getEndTime()) {
                    timestampOfRight = this.histogramContent.getEndTime();
                    timestampOfCenter = timestampOfRight - this.currentWindow.getWindowTimeWidth() / 2L;
                    timestampOfLeft = timestampOfRight - this.currentWindow.getWindowTimeWidth();
                    windowXPositionLeft = this.histogramContent.getClosestXPositionFromTimestamp(timestampOfLeft);
                    windowXPositionCenter = this.histogramContent.getClosestXPositionFromTimestamp(timestampOfCenter);
                    windowXPositionRight = this.histogramContent.getClosestXPositionFromTimestamp(timestampOfRight);
                } else {
                    timestampOfCenter = timestampOfCenterPosition;
                    windowXPositionCenter = this.histogramContent.getClosestXPositionFromTimestamp(timestampOfCenter);
                }
            }
            this.currentWindow.setTimestampOfLeftPosition(timestampOfLeft);
            this.currentWindow.setTimestampOfCenterPosition(timestampOfCenter);
            this.currentWindow.setTimestampOfRightPosition(timestampOfRight);
            if (windowXPositionCenter != this.currentWindow.getWindowXPositionCenter()) {
                this.currentWindow.setWindowXPositionLeft(windowXPositionLeft);
                this.currentWindow.setWindowXPositionCenter(windowXPositionCenter);
                this.currentWindow.setWindowXPositionRight(windowXPositionRight);
                this.redrawAsynchronously();
            }
        }
    }

    public void resizeWindowByAbsoluteTime(long newTime) {
        if (newTime != this.getSelectedWindowSize()) {
            this.resizeWindowByAbsoluteTimeWithoutNotification(newTime);
            this.notifyParentSelectionWindowChangedAsynchronously();
        }
    }

    public void resizeWindowByAbsoluteTimeWithoutNotification(long newTime) {
        if (newTime != 0L) {
            if (newTime > this.getHistogramContent().getEndTime() - this.getHistogramContent().getStartTime()) {
                newTime = this.getHistogramContent().getEndTime() - this.getHistogramContent().getStartTime();
            }
            this.setSelectedWindowSize(newTime);
            long timestampOfLeftPosition = this.currentWindow.getTimestampOfCenterPosition() - this.currentWindow.getWindowTimeWidth() / 2L;
            long timestampOfCenterPosition = this.currentWindow.getTimestampOfCenterPosition();
            long timestampOfRightPosition = 0L;
            if (timestampOfLeftPosition < this.histogramContent.getStartTime()) {
                timestampOfLeftPosition = this.histogramContent.getStartTime();
                timestampOfCenterPosition = timestampOfLeftPosition + this.currentWindow.getWindowTimeWidth() / 2L;
                timestampOfRightPosition = timestampOfLeftPosition + this.currentWindow.getWindowTimeWidth();
            } else {
                timestampOfRightPosition = this.currentWindow.getTimestampOfCenterPosition() + this.currentWindow.getWindowTimeWidth() / 2L;
                if (timestampOfRightPosition > this.histogramContent.getEndTime()) {
                    timestampOfRightPosition = this.histogramContent.getEndTime();
                    timestampOfCenterPosition = timestampOfRightPosition - this.currentWindow.getWindowTimeWidth() / 2L;
                    timestampOfLeftPosition = timestampOfRightPosition - this.currentWindow.getWindowTimeWidth();
                }
            }
            this.currentWindow.setTimestampOfLeftPosition(timestampOfLeftPosition);
            this.currentWindow.setTimestampOfCenterPosition(timestampOfCenterPosition);
            this.currentWindow.setTimestampOfRightPosition(timestampOfRightPosition);
            this.currentWindow.setWindowXPositionLeft(this.histogramContent.getClosestXPositionFromTimestamp(timestampOfLeftPosition));
            this.currentWindow.setWindowXPositionCenter(this.histogramContent.getClosestXPositionFromTimestamp(timestampOfCenterPosition));
            this.currentWindow.setWindowXPositionRight(this.histogramContent.getClosestXPositionFromTimestamp(timestampOfRightPosition));
            this.redrawAsynchronously();
        }
    }

    @Override
    public void notifyParentUpdatedInformation() {
        ParentHistogramCanvas.getHistogramView().updateFullExperimentInformation();
    }

    public void notifyParentSelectionWindowChanged() {
        ParentHistogramCanvas.getHistogramView().windowChangedNotification();
        ParentHistogramCanvas.getHistogramView().sendTmfRangeSynchSignalBroadcast();
    }

    public void notifyParentSelectionWindowChangedAsynchronously() {
        if (this.canvasRedrawer == null) {
            this.canvasRedrawer = new AsyncCanvasRedrawer(this);
        }
        this.asynchronousNotifyParentSelectionWindowChanged();
    }

    public void asynchronousNotifyParentSelectionWindowChanged() {
        if (this.isDisposed()) {
            return;
        }
        Display display = this.getDisplay();
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!ParentHistogramCanvas.this.isDisposed()) {
                    ParentHistogramCanvas.this.notifyParentSelectionWindowChanged();
                }
            }
        });
    }
}

