/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.lttng.ui.views.project.model;

import java.lang.reflect.Array;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.linuxtools.lttng.ui.views.project.model.ILTTngProjectTreeNode;
import org.eclipse.linuxtools.lttng.ui.views.project.model.LTTngProjectNode;
import org.eclipse.linuxtools.lttng.ui.views.project.model.LTTngProjectTreeNode;
import org.eclipse.linuxtools.lttng.ui.views.project.model.LTTngTraceNode;

public class LTTngTraceFolderNode
extends LTTngProjectTreeNode {
    private final IFolder fTraceFolder;

    public LTTngTraceFolderNode(IFolder folder) {
        this(null, folder);
    }

    public LTTngTraceFolderNode(ILTTngProjectTreeNode parent, IFolder folder) {
        super(parent);
        this.fTraceFolder = folder;
    }

    @Override
    public String getName() {
        return this.fTraceFolder.getName();
    }

    @Override
    public void refreshChildren() {
        try {
            IResource[] resources;
            IResource[] iResourceArray = resources = this.fTraceFolder.members();
            int n = resources.length;
            int n2 = 0;
            while (n2 < n) {
                LTTngTraceNode node;
                IResource resource = iResourceArray[n2];
                if (resource instanceof IFolder && (node = this.find(resource.getName())) == null) {
                    node = new LTTngTraceNode(this, (IFolder)resource);
                    this.fChildren.add(node);
                }
                ++n2;
            }
            for (ILTTngProjectTreeNode node : this.fChildren) {
                if (this.exists(node.getName(), resources)) continue;
                this.fChildren.remove(node);
            }
        }
        catch (CoreException coreException) {}
    }

    private LTTngTraceNode find(String name) {
        for (ILTTngProjectTreeNode node : this.fChildren) {
            if (!(node instanceof LTTngTraceNode) || !node.getName().equals(name)) continue;
            return (LTTngTraceNode)node;
        }
        return null;
    }

    private boolean exists(String name, IResource[] resources) {
        IResource[] iResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            if (resource.getName().equals(name)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public LTTngProjectNode getProject() {
        return (LTTngProjectNode)this.getParent();
    }

    public IFolder getFolder() {
        return this.fTraceFolder;
    }

    public LTTngTraceNode[] getTraces() {
        LTTngTraceNode[] result = (LTTngTraceNode[])Array.newInstance(LTTngTraceNode.class, this.fChildren.size());
        return this.fChildren.toArray(result);
    }

    public void addTrace(IFolder trace) {
    }
}

